/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.config;

public final class AerospikeDataSettings {
    private final boolean scansEnabled;
    private final boolean sendKey;
    private final boolean createIndexesOnStartup;

    private static boolean $default$scansEnabled() {
        return false;
    }

    private static boolean $default$sendKey() {
        return true;
    }

    private static boolean $default$createIndexesOnStartup() {
        return true;
    }

    AerospikeDataSettings(boolean scansEnabled, boolean sendKey, boolean createIndexesOnStartup) {
        this.scansEnabled = scansEnabled;
        this.sendKey = sendKey;
        this.createIndexesOnStartup = createIndexesOnStartup;
    }

    public static AerospikeDataSettingsBuilder builder() {
        return new AerospikeDataSettingsBuilder();
    }

    public boolean isScansEnabled() {
        return this.scansEnabled;
    }

    public boolean isSendKey() {
        return this.sendKey;
    }

    public boolean isCreateIndexesOnStartup() {
        return this.createIndexesOnStartup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AerospikeDataSettings)) {
            return false;
        }
        AerospikeDataSettings other = (AerospikeDataSettings)o;
        if (this.isScansEnabled() != other.isScansEnabled()) {
            return false;
        }
        if (this.isSendKey() != other.isSendKey()) {
            return false;
        }
        return this.isCreateIndexesOnStartup() == other.isCreateIndexesOnStartup();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isScansEnabled() ? 79 : 97);
        result = result * 59 + (this.isSendKey() ? 79 : 97);
        result = result * 59 + (this.isCreateIndexesOnStartup() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AerospikeDataSettings(scansEnabled=" + this.isScansEnabled() + ", sendKey=" + this.isSendKey() + ", createIndexesOnStartup=" + this.isCreateIndexesOnStartup() + ")";
    }

    public static class AerospikeDataSettingsBuilder {
        private boolean scansEnabled$set;
        private boolean scansEnabled$value;
        private boolean sendKey$set;
        private boolean sendKey$value;
        private boolean createIndexesOnStartup$set;
        private boolean createIndexesOnStartup$value;

        AerospikeDataSettingsBuilder() {
        }

        public AerospikeDataSettingsBuilder scansEnabled(boolean scansEnabled) {
            this.scansEnabled$value = scansEnabled;
            this.scansEnabled$set = true;
            return this;
        }

        public AerospikeDataSettingsBuilder sendKey(boolean sendKey) {
            this.sendKey$value = sendKey;
            this.sendKey$set = true;
            return this;
        }

        public AerospikeDataSettingsBuilder createIndexesOnStartup(boolean createIndexesOnStartup) {
            this.createIndexesOnStartup$value = createIndexesOnStartup;
            this.createIndexesOnStartup$set = true;
            return this;
        }

        public AerospikeDataSettings build() {
            boolean scansEnabled$value = this.scansEnabled$value;
            if (!this.scansEnabled$set) {
                scansEnabled$value = AerospikeDataSettings.$default$scansEnabled();
            }
            boolean sendKey$value = this.sendKey$value;
            if (!this.sendKey$set) {
                sendKey$value = AerospikeDataSettings.$default$sendKey();
            }
            boolean createIndexesOnStartup$value = this.createIndexesOnStartup$value;
            if (!this.createIndexesOnStartup$set) {
                createIndexesOnStartup$value = AerospikeDataSettings.$default$createIndexesOnStartup();
            }
            return new AerospikeDataSettings(scansEnabled$value, sendKey$value, createIndexesOnStartup$value);
        }

        public String toString() {
            return "AerospikeDataSettings.AerospikeDataSettingsBuilder(scansEnabled$value=" + this.scansEnabled$value + ", sendKey$value=" + this.sendKey$value + ", createIndexesOnStartup$value=" + this.createIndexesOnStartup$value + ")";
        }
    }
}

