/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import java.util.Collection;
import java.util.Map;
import org.springframework.data.aerospike.convert.AerospikeConverter;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.utility.Utils;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.util.CloseableIterator;

public class AerospikeKeyValueAdapter
extends AbstractKeyValueAdapter {
    private final AerospikeConverter converter;
    private final IAerospikeClient client;
    private final String namespace;
    private final WritePolicy insertPolicy;
    private final WritePolicy updatePolicy;

    public AerospikeKeyValueAdapter(IAerospikeClient client, AerospikeConverter converter, String namespace) {
        this.client = client;
        this.converter = converter;
        this.namespace = namespace;
        this.insertPolicy = WritePolicyBuilder.builder(client.getWritePolicyDefault()).recordExistsAction(RecordExistsAction.CREATE_ONLY).build();
        this.updatePolicy = WritePolicyBuilder.builder(client.getWritePolicyDefault()).recordExistsAction(RecordExistsAction.UPDATE_ONLY).build();
    }

    public Object put(Object id, Object item, String keyspace) {
        AerospikeWriteData data = AerospikeWriteData.forWrite(this.namespace);
        this.converter.write(item, data);
        this.client.put(null, data.getKey(), data.getBinsAsArray());
        return item;
    }

    public boolean contains(Object id, String keyspace) {
        return this.client.exists(null, this.makeKey(keyspace, id.toString()));
    }

    public Object get(Object id, String keyspace) {
        Key key = this.makeKey(keyspace, id.toString());
        Record record = this.client.get(null, key);
        if (record == null) {
            return null;
        }
        AerospikeReadData data = AerospikeReadData.forRead(key, record);
        return this.converter.read(Object.class, data);
    }

    public Object delete(Object id, String keyspace) {
        Key key = new Key(this.namespace, keyspace, id.toString());
        Object object = this.get(id, keyspace);
        if (object != null) {
            WritePolicy writePolicy = WritePolicyBuilder.builder(this.client.getWritePolicyDefault()).recordExistsAction(RecordExistsAction.UPDATE_ONLY).build();
            this.client.delete(writePolicy, key);
        }
        return object;
    }

    public Collection<?> getAllOf(String keyspace) {
        return null;
    }

    public void deleteAllOf(String keyspace) {
        Utils.infoAll(this.client, "set-config:context=namespace;id=" + this.namespace + ";set=" + keyspace + ";set-delete=true;");
    }

    public void clear() {
    }

    public void destroy() throws Exception {
    }

    public Collection<?> find(KeyValueQuery<?> query, String keyspace) {
        return super.find(query, keyspace);
    }

    public CloseableIterator<Map.Entry<Object, Object>> entries(String keyspace) {
        return null;
    }

    public long count(String keyspace) {
        return 0L;
    }

    private Key makeKey(String set, Object keyValue) {
        return new Key(this.namespace, set, Value.get((Object)keyValue));
    }
}

