/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.Bin;
import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import java.util.Map;
import java.util.function.Function;

public class OperationUtils {
    static <T> Operation[] operations(Map<String, T> values, Operation.Type operationType, Operation ... additionalOperations) {
        Operation[] operations = new Operation[values.size() + additionalOperations.length];
        int x = 0;
        for (Map.Entry<String, T> entry : values.entrySet()) {
            operations[x] = new Operation(operationType, entry.getKey(), Value.get(entry.getValue()));
            ++x;
        }
        Operation[] operationArray = additionalOperations;
        int n = operationArray.length;
        for (int i = 0; i < n; ++i) {
            Operation additionalOp;
            operations[x] = additionalOp = operationArray[i];
            ++x;
        }
        return operations;
    }

    static Operation[] operations(Bin[] bins, Function<Bin, Operation> binToOperation, Operation ... additionalOperations) {
        Operation[] operations = new Operation[bins.length + additionalOperations.length];
        int i = 0;
        for (Bin bin : bins) {
            operations[i] = binToOperation.apply(bin);
            ++i;
        }
        for (Bin bin : additionalOperations) {
            operations[i] = bin;
            ++i;
        }
        return operations;
    }
}

