/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.data.aerospike.IndexAlreadyExistsException;
import org.springframework.data.aerospike.core.AerospikeTemplate;
import org.springframework.data.aerospike.index.AerospikeIndexDefinition;
import org.springframework.data.aerospike.index.AerospikeIndexResolver;
import org.springframework.data.aerospike.index.BaseAerospikePersistenceEntityIndexCreator;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;

public class AerospikePersistenceEntityIndexCreator
extends BaseAerospikePersistenceEntityIndexCreator {
    private static final Logger log = LoggerFactory.getLogger(AerospikePersistenceEntityIndexCreator.class);
    private final AerospikeTemplate template;

    public AerospikePersistenceEntityIndexCreator(ObjectProvider<AerospikeMappingContext> mappingContext, boolean createIndexesOnStartup, AerospikeIndexResolver aerospikeIndexResolver, AerospikeTemplate template) {
        super(mappingContext, createIndexesOnStartup, aerospikeIndexResolver);
        this.template = template;
    }

    @Override
    protected void installIndexes(Set<AerospikeIndexDefinition> indexes) {
        indexes.forEach(this::installIndex);
    }

    private void installIndex(AerospikeIndexDefinition index) {
        log.debug("Installing aerospike index: {}...", (Object)index);
        try {
            this.template.createIndex(index.getEntityClass(), index.getName(), index.getFieldName(), index.getType(), index.getCollectionType());
            log.info("Installed aerospike index: {} successfully.", (Object)index);
        }
        catch (IndexAlreadyExistsException e) {
            log.info("Skipping index [{}] creation. Index with the same name already exists. {}", (Object)index, (Object)e.getMessage());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to install aerospike index: " + index, e);
        }
    }
}

