/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.exp.ListExp;
import com.aerospike.client.exp.MapExp;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Qualifier
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = -2689196529952712849L;
    private static final String listIterVar = "listIterVar";
    private static final String mapIterVar = "mapIterVar";
    private static final String FIELD = "field";
    private static final String IGNORE_CASE = "ignoreCase";
    private static final String VALUE2 = "value2";
    private static final String VALUE1 = "value1";
    private static final String QUALIFIERS = "qualifiers";
    private static final String OPERATION = "operation";
    private static final String AS_FILTER = "queryAsFilter";
    protected Map<String, Object> internalMap = new HashMap<String, Object>();

    public Qualifier() {
    }

    public Qualifier(FilterOperation operation, Qualifier ... qualifiers) {
        this();
        this.internalMap.put(QUALIFIERS, qualifiers);
        this.internalMap.put(OPERATION, (Object)operation);
    }

    public Qualifier(String field, FilterOperation operation, Value value1) {
        this(field, operation, Boolean.FALSE, value1);
    }

    public Qualifier(String field, FilterOperation operation, Boolean ignoreCase, Value value1) {
        this();
        this.internalMap.put(FIELD, field);
        this.internalMap.put(OPERATION, (Object)operation);
        this.internalMap.put(VALUE1, value1);
        this.internalMap.put(IGNORE_CASE, ignoreCase);
    }

    public Qualifier(String field, FilterOperation operation, Value value1, Value value2) {
        this(field, operation, Boolean.FALSE, value1);
        this.internalMap.put(VALUE2, value2);
    }

    public FilterOperation getOperation() {
        return (FilterOperation)((Object)this.internalMap.get(OPERATION));
    }

    public String getField() {
        return (String)this.internalMap.get(FIELD);
    }

    public void asFilter(Boolean queryAsFilter) {
        this.internalMap.put(AS_FILTER, queryAsFilter);
    }

    public Boolean queryAsFilter() {
        return this.internalMap.containsKey(AS_FILTER) && (Boolean)this.internalMap.get(AS_FILTER) != false;
    }

    public Qualifier[] getQualifiers() {
        return (Qualifier[])this.internalMap.get(QUALIFIERS);
    }

    public Value getValue1() {
        return (Value)this.internalMap.get(VALUE1);
    }

    public Value getValue2() {
        return (Value)this.internalMap.get(VALUE2);
    }

    public Filter asFilter() {
        FilterOperation op = this.getOperation();
        switch (op) {
            case EQ: {
                if (this.getValue1().getType() == 1) {
                    return Filter.equal((String)this.getField(), (long)this.getValue1().toLong());
                }
                if (this.ignoreCase().booleanValue()) {
                    return null;
                }
                return Filter.equal((String)this.getField(), (String)this.getValue1().toString());
            }
            case GTEQ: 
            case BETWEEN: {
                return Filter.range((String)this.getField(), (long)this.getValue1().toLong(), (long)(this.getValue2() == null ? Long.MAX_VALUE : this.getValue2().toLong()));
            }
            case GT: {
                return Filter.range((String)this.getField(), (long)(this.getValue1().toLong() + 1L), (long)(this.getValue2() == null ? Long.MAX_VALUE : this.getValue2().toLong()));
            }
            case LT: {
                return Filter.range((String)this.getField(), (long)Long.MIN_VALUE, (long)(this.getValue1().toLong() - 1L));
            }
            case LTEQ: {
                return Filter.range((String)this.getField(), (long)Long.MIN_VALUE, (long)this.getValue1().toLong());
            }
            case LIST_CONTAINS: {
                return this.collectionContains(IndexCollectionType.LIST);
            }
            case MAP_KEYS_CONTAINS: {
                return this.collectionContains(IndexCollectionType.MAPKEYS);
            }
            case MAP_VALUES_CONTAINS: {
                return this.collectionContains(IndexCollectionType.MAPVALUES);
            }
            case LIST_BETWEEN: {
                return this.collectionRange(IndexCollectionType.LIST);
            }
            case MAP_KEYS_BETWEEN: {
                return this.collectionRange(IndexCollectionType.MAPKEYS);
            }
            case MAP_VALUES_BETWEEN: {
                return this.collectionRange(IndexCollectionType.MAPVALUES);
            }
            case GEO_WITHIN: {
                return this.geoWithinRadius(IndexCollectionType.DEFAULT);
            }
        }
        return null;
    }

    private Filter geoWithinRadius(IndexCollectionType collectionType) {
        return Filter.geoContains((String)this.getField(), (String)this.getValue1().toString());
    }

    private Filter collectionContains(IndexCollectionType collectionType) {
        Value val = this.getValue1();
        int valType = val.getType();
        switch (valType) {
            case 1: {
                return Filter.contains((String)this.getField(), (IndexCollectionType)collectionType, (long)val.toLong());
            }
            case 3: {
                return Filter.contains((String)this.getField(), (IndexCollectionType)collectionType, (String)val.toString());
            }
        }
        return null;
    }

    private Filter collectionRange(IndexCollectionType collectionType) {
        return Filter.range((String)this.getField(), (IndexCollectionType)collectionType, (long)this.getValue1().toLong(), (long)this.getValue2().toLong());
    }

    public Exp toFilterExp() {
        Exp exp;
        int regexFlags = this.ignoreCase() != false ? 2 : 0;
        block0 : switch (this.getOperation()) {
            case AND: {
                Qualifier[] qs = (Qualifier[])this.get(QUALIFIERS);
                Exp[] childrenExp = new Exp[qs.length];
                for (int i = 0; i < qs.length; ++i) {
                    childrenExp[i] = qs[i].toFilterExp();
                }
                exp = Exp.and((Exp[])childrenExp);
                break;
            }
            case OR: {
                Qualifier[] qs = (Qualifier[])this.get(QUALIFIERS);
                Exp[] childrenExp = new Exp[qs.length];
                for (int i = 0; i < qs.length; ++i) {
                    childrenExp[i] = qs[i].toFilterExp();
                }
                exp = Exp.or((Exp[])childrenExp);
                break;
            }
            case IN: {
                Value val = this.getValue1();
                int valType = val.getType();
                if (valType != 20) {
                    throw new IllegalArgumentException("FilterOperation.IN expects List argument with type: 20, but got: " + valType);
                }
                List inList = (List)val.getObject();
                Exp[] listElementsExp = new Exp[inList.size()];
                for (int i = 0; i < inList.size(); ++i) {
                    listElementsExp[i] = new Qualifier(this.getField(), FilterOperation.EQ, Value.get(inList.get(i))).toFilterExp();
                }
                exp = Exp.or((Exp[])listElementsExp);
                break;
            }
            case EQ: {
                Value val = this.getValue1();
                int valType = val.getType();
                switch (valType) {
                    case 1: {
                        exp = Exp.eq((Exp)Exp.intBin((String)this.getField()), (Exp)Exp.val((long)val.toLong()));
                        break block0;
                    }
                    case 3: {
                        if (this.ignoreCase().booleanValue()) {
                            String equalsRegexp = QualifierRegexpBuilder.getStringEquals(this.getValue1().toString());
                            exp = Exp.regexCompare((String)equalsRegexp, (int)2, (Exp)Exp.stringBin((String)this.getField()));
                            break block0;
                        }
                        exp = Exp.eq((Exp)Exp.stringBin((String)this.getField()), (Exp)Exp.val((String)val.toString()));
                        break block0;
                    }
                }
                throw new AerospikeException("FilterExpression Unsupported Particle Type: " + valType);
            }
            case NOTEQ: {
                Value val = this.getValue1();
                int valType = val.getType();
                if (valType == 1) {
                    exp = Exp.ne((Exp)Exp.intBin((String)this.getField()), (Exp)Exp.val((long)val.toLong()));
                    break;
                }
                exp = Exp.ne((Exp)Exp.stringBin((String)this.getField()), (Exp)Exp.val((String)val.toString()));
                break;
            }
            case GT: {
                exp = Exp.gt((Exp)Exp.intBin((String)this.getField()), (Exp)Exp.val((long)this.getValue1().toLong()));
                break;
            }
            case GTEQ: {
                exp = Exp.ge((Exp)Exp.intBin((String)this.getField()), (Exp)Exp.val((long)this.getValue1().toLong()));
                break;
            }
            case LT: {
                exp = Exp.lt((Exp)Exp.intBin((String)this.getField()), (Exp)Exp.val((long)this.getValue1().toLong()));
                break;
            }
            case LTEQ: {
                exp = Exp.le((Exp)Exp.intBin((String)this.getField()), (Exp)Exp.val((long)this.getValue1().toLong()));
                break;
            }
            case BETWEEN: {
                exp = Exp.and((Exp[])new Exp[]{Exp.ge((Exp)Exp.intBin((String)this.getField()), (Exp)Exp.val((long)this.getValue1().toLong())), Exp.le((Exp)Exp.intBin((String)this.getField()), (Exp)Exp.val((long)this.getValue2().toLong()))});
                break;
            }
            case GEO_WITHIN: {
                exp = Exp.geoCompare((Exp)Exp.geoBin((String)this.getField()), (Exp)Exp.geo((String)this.getValue1().toString()));
                break;
            }
            case START_WITH: {
                String startWithRegexp = QualifierRegexpBuilder.getStartsWith(this.getValue1().toString());
                exp = Exp.regexCompare((String)startWithRegexp, (int)regexFlags, (Exp)Exp.stringBin((String)this.getField()));
                break;
            }
            case ENDS_WITH: {
                String endWithRegexp = QualifierRegexpBuilder.getEndsWith(this.getValue1().toString());
                exp = Exp.regexCompare((String)endWithRegexp, (int)regexFlags, (Exp)Exp.stringBin((String)this.getField()));
                break;
            }
            case CONTAINING: {
                String containingRegexp = QualifierRegexpBuilder.getContaining(this.getValue1().toString());
                exp = Exp.regexCompare((String)containingRegexp, (int)regexFlags, (Exp)Exp.stringBin((String)this.getField()));
                break;
            }
            case LIST_CONTAINS: {
                if (this.getValue1().getType() == 3) {
                    exp = Exp.gt((Exp)ListExp.getByValue((int)5, (Exp)Exp.val((String)this.getValue1().toString()), (Exp)Exp.listBin((String)this.getField()), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                    break;
                }
                exp = Exp.gt((Exp)ListExp.getByValue((int)5, (Exp)Exp.val((long)this.getValue1().toLong()), (Exp)Exp.listBin((String)this.getField()), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                break;
            }
            case MAP_KEYS_CONTAINS: {
                if (this.getValue1().getType() == 3) {
                    exp = Exp.gt((Exp)MapExp.getByKey((int)5, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue1().toString()), (Exp)Exp.mapBin((String)this.getField()), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                    break;
                }
                exp = Exp.gt((Exp)MapExp.getByKey((int)5, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((long)this.getValue1().toLong()), (Exp)Exp.mapBin((String)this.getField()), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                break;
            }
            case MAP_VALUES_CONTAINS: {
                if (this.getValue1().getType() == 3) {
                    exp = Exp.gt((Exp)MapExp.getByValue((int)5, (Exp)Exp.val((String)this.getValue1().toString()), (Exp)Exp.mapBin((String)this.getField()), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                    break;
                }
                exp = Exp.gt((Exp)MapExp.getByValue((int)5, (Exp)Exp.val((long)this.getValue1().toLong()), (Exp)Exp.mapBin((String)this.getField()), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                break;
            }
            case LIST_BETWEEN: {
                exp = Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)Exp.val((long)this.getValue1().toLong()), (Exp)Exp.val((long)(this.getValue2().toLong() + 1L)), (Exp)Exp.listBin((String)this.getField()), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                break;
            }
            case MAP_KEYS_BETWEEN: {
                exp = Exp.gt((Exp)MapExp.getByKeyRange((int)5, (Exp)Exp.val((long)this.getValue1().toLong()), (Exp)Exp.val((long)(this.getValue2().toLong() + 1L)), (Exp)Exp.mapBin((String)this.getField()), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                break;
            }
            case MAP_VALUES_BETWEEN: {
                exp = Exp.gt((Exp)MapExp.getByValueRange((int)5, (Exp)Exp.val((long)this.getValue1().toLong()), (Exp)Exp.val((long)(this.getValue2().toLong() + 1L)), (Exp)Exp.mapBin((String)this.getField()), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                break;
            }
            default: {
                throw new AerospikeException("FilterExpression Unsupported Operation: " + (Object)((Object)this.getOperation()));
            }
        }
        return exp;
    }

    private Boolean ignoreCase() {
        Boolean ignoreCase = (Boolean)this.internalMap.get(IGNORE_CASE);
        return ignoreCase == null ? false : ignoreCase;
    }

    protected String luaFieldString(String field) {
        return String.format("rec['%s']", field);
    }

    protected String luaValueString(Value value) {
        String res = null;
        if (null == value) {
            return res;
        }
        int type = value.getType();
        switch (type) {
            case 3: {
                res = String.format("'%s'", value.toString());
                break;
            }
            case 23: {
                res = String.format("'%s'", value.toString());
                break;
            }
            default: {
                res = value.toString();
            }
        }
        return res;
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.internalMap.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.internalMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.internalMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.internalMap.putAll(m);
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.internalMap.entrySet();
    }

    public String toString() {
        return String.format("%s:%s:%s:%s", new Object[]{this.getField(), this.getOperation(), this.getValue1(), this.getValue2()});
    }

    public static enum FilterOperation {
        EQ,
        GT,
        GTEQ,
        LT,
        LTEQ,
        NOTEQ,
        BETWEEN,
        START_WITH,
        ENDS_WITH,
        CONTAINING,
        IN,
        LIST_CONTAINS,
        MAP_KEYS_CONTAINS,
        MAP_VALUES_CONTAINS,
        LIST_BETWEEN,
        MAP_KEYS_BETWEEN,
        MAP_VALUES_BETWEEN,
        GEO_WITHIN,
        OR,
        AND;

    }

    public static class QualifierRegexpBuilder {
        private static final Character BACKSLASH = Character.valueOf('\\');
        private static final Character DOT = Character.valueOf('.');
        private static final Character ASTERISK = Character.valueOf('*');
        private static final Character DOLLAR = Character.valueOf('$');
        private static final Character OPEN_BRACKET = Character.valueOf('[');
        private static final Character CIRCUMFLEX = Character.valueOf('^');

        public static String escapeBRERegexp(String base) {
            StringBuilder builder = new StringBuilder();
            for (char stringChar : base.toCharArray()) {
                if (stringChar == BACKSLASH.charValue() || stringChar == DOT.charValue() || stringChar == ASTERISK.charValue() || stringChar == DOLLAR.charValue() || stringChar == OPEN_BRACKET.charValue() || stringChar == CIRCUMFLEX.charValue()) {
                    builder.append(BACKSLASH);
                }
                builder.append(stringChar);
            }
            return builder.toString();
        }

        private static String getRegexp(String base, FilterOperation op) {
            String escapedBase = QualifierRegexpBuilder.escapeBRERegexp(base);
            if (op == FilterOperation.START_WITH) {
                return "^" + escapedBase;
            }
            if (op == FilterOperation.ENDS_WITH) {
                return escapedBase + "$";
            }
            if (op == FilterOperation.EQ) {
                return "^" + escapedBase + "$";
            }
            return escapedBase;
        }

        public static String getStartsWith(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.START_WITH);
        }

        public static String getEndsWith(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.ENDS_WITH);
        }

        public static String getContaining(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.CONTAINING);
        }

        public static String getStringEquals(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.EQ);
        }
    }
}

