/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.StringUtils;

abstract class AerospikeConverters {
    private AerospikeConverters() {
    }

    static Collection<Object> getConvertersToRegister() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add((Object)BigDecimalToStringConverter.INSTANCE);
        converters.add((Object)StringToBigDecimalConverter.INSTANCE);
        converters.add((Object)LongToBooleanConverter.INSTANCE);
        converters.add((Object)EnumToStringConverter.INSTANCE);
        return converters;
    }

    public static enum BigDecimalToStringConverter implements Converter<BigDecimal, String>
    {
        INSTANCE;


        public String convert(BigDecimal source) {
            return source.toString();
        }
    }

    public static enum StringToBigDecimalConverter implements Converter<String, BigDecimal>
    {
        INSTANCE;


        public BigDecimal convert(String source) {
            return StringUtils.hasText((String)source) ? new BigDecimal(source) : null;
        }
    }

    @ReadingConverter
    public static enum LongToBooleanConverter implements Converter<Long, Boolean>
    {
        INSTANCE;


        public Boolean convert(Long source) {
            return source != 0L;
        }
    }

    @WritingConverter
    public static enum EnumToStringConverter implements Converter<Enum<?>, String>
    {
        INSTANCE;


        public String convert(Enum<?> source) {
            return source.name();
        }
    }
}

