/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.aerospike.annotation.Indexed;
import org.springframework.data.aerospike.index.AerospikeIndexDefinition;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AerospikeIndexResolver
implements EnvironmentAware {
    private Environment environment;

    public Set<AerospikeIndexDefinition> detectIndexes(BasicAerospikePersistentEntity<?> persistentEntity) {
        return StreamSupport.stream(persistentEntity.spliterator(), false).filter(property -> property.isAnnotationPresent(Indexed.class)).map(property -> this.convertToIndex(persistentEntity, (AerospikePersistentProperty)property)).collect(Collectors.toSet());
    }

    private AerospikeIndexDefinition convertToIndex(BasicAerospikePersistentEntity<?> persistentEntity, AerospikePersistentProperty property) {
        String indexName;
        Indexed annotation = (Indexed)property.getRequiredAnnotation(Indexed.class);
        if (StringUtils.hasText((String)annotation.name())) {
            Assert.notNull((Object)this.environment, (String)"Environment must be set to use 'indexed'");
            indexName = this.environment.resolveRequiredPlaceholders(annotation.name());
        } else {
            indexName = this.getIndexName(persistentEntity, property, annotation);
        }
        return AerospikeIndexDefinition.builder().entityClass(persistentEntity.getType()).fieldName(property.getFieldName()).name(indexName).type(annotation.type()).collectionType(annotation.collectionType()).build();
    }

    private String getIndexName(BasicAerospikePersistentEntity<?> entity, AerospikePersistentProperty property, Indexed annotation) {
        return String.join((CharSequence)"_", entity.getSetName(), property.getFieldName(), annotation.type().name().toLowerCase(), annotation.collectionType().name().toLowerCase());
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

