/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import com.aerospike.client.Key;
import com.aerospike.client.Record;
import java.util.Map;
import org.springframework.util.Assert;

public class AerospikeReadData {
    private final Key key;
    private final Map<String, Object> aeroRecord;
    private final int expiration;
    private final int version;

    private AerospikeReadData(Key key, Map<String, Object> aeroRecord, int expiration, int version) {
        this.key = key;
        this.aeroRecord = aeroRecord;
        this.expiration = expiration;
        this.version = version;
    }

    public static AerospikeReadData forRead(Key key, Record aeroRecord) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)aeroRecord, (String)"Record must not be null");
        Assert.notNull((Object)aeroRecord.bins, (String)"Record bins must not be null");
        return new AerospikeReadData(key, aeroRecord.bins, aeroRecord.getTimeToLive(), aeroRecord.generation);
    }

    public Map<String, Object> getAeroRecord() {
        return this.aeroRecord;
    }

    public Key getKey() {
        return this.key;
    }

    public Object getValue(String key) {
        return this.aeroRecord.get(key);
    }

    public int getExpiration() {
        return this.expiration;
    }

    public int getVersion() {
        return this.version;
    }
}

