/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Record;
import com.aerospike.client.policy.GenerationPolicy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.EntitiesKeys;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.Field;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;

abstract class BaseAerospikeTemplate {
    private static final Logger log = LoggerFactory.getLogger(BaseAerospikeTemplate.class);
    protected final MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty> mappingContext;
    protected final MappingAerospikeConverter converter;
    protected final String namespace;
    protected final AerospikeExceptionTranslator exceptionTranslator;
    protected final WritePolicy writePolicyDefault;

    BaseAerospikeTemplate(String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, WritePolicy writePolicyDefault) {
        Assert.notNull((Object)writePolicyDefault, (String)"Write policy must not be null!");
        Assert.notNull((Object)namespace, (String)"Namespace cannot be null");
        Assert.hasLength((String)namespace, (String)"Namespace cannot be empty");
        this.converter = converter;
        this.exceptionTranslator = exceptionTranslator;
        this.namespace = namespace;
        this.mappingContext = mappingContext;
        this.writePolicyDefault = writePolicyDefault;
        this.loggerSetup();
    }

    private void loggerSetup() {
        Logger log = LoggerFactory.getLogger((String)"com.aerospike.client");
        Log.setCallback((level, message) -> {
            switch (level) {
                case INFO: {
                    log.info("{}", (Object)message);
                    break;
                }
                case DEBUG: {
                    log.debug("{}", (Object)message);
                    break;
                }
                case ERROR: {
                    log.error("{}", (Object)message);
                    break;
                }
                case WARN: {
                    log.warn("{}", (Object)message);
                }
            }
        });
    }

    public <T> String getSetName(Class<T> entityClass) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        return entity.getSetName();
    }

    public MappingContext<?, ?> getMappingContext() {
        return this.mappingContext;
    }

    public String getNamespace() {
        return this.namespace;
    }

    <T> Class<T> getEntityClass(T entity) {
        return entity.getClass();
    }

    <T> T mapToEntity(Key key, Class<T> type, Record aeroRecord) {
        if (aeroRecord == null) {
            return null;
        }
        AerospikeReadData data = AerospikeReadData.forRead(key, aeroRecord);
        return this.converter.read(type, data);
    }

    protected <T> Comparator<T> getComparator(Query query) {
        return query.getSort().stream().map(this::getPropertyComparator).reduce(Comparator::thenComparing).orElseThrow(() -> new IllegalStateException("Comparator can not be created if sort orders are empty"));
    }

    protected <T> Comparator<T> getComparator(Sort sort) {
        return sort.stream().map(this::getPropertyComparator).reduce(Comparator::thenComparing).orElseThrow(() -> new IllegalStateException("Comparator can not be created if sort orders are empty"));
    }

    private <T> Comparator<T> getPropertyComparator(Sort.Order order) {
        boolean ignoreCase = true;
        boolean ascending = order.getDirection().isAscending();
        return new PropertyComparator(order.getProperty(), ignoreCase, ascending);
    }

    <T> ConvertingPropertyAccessor<T> getPropertyAccessor(AerospikePersistentEntity<?> entity, T source) {
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, this.converter.getConversionService());
    }

    <T> T updateVersion(T document, Record newAeroRecord) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        ConvertingPropertyAccessor<T> propertyAccessor = this.getPropertyAccessor(entity, document);
        AerospikePersistentProperty versionProperty = (AerospikePersistentProperty)entity.getRequiredVersionProperty();
        propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)newAeroRecord.generation);
        return document;
    }

    RuntimeException translateCasError(AerospikeException e) {
        int code = e.getResultCode();
        if (code == 5 || code == 3) {
            return new OptimisticLockingFailureException("Save document with version value failed", (Throwable)e);
        }
        return this.translateError(e);
    }

    RuntimeException translateError(AerospikeException e) {
        DataAccessException translated = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)e);
        return translated == null ? e : translated;
    }

    <T> AerospikeWriteData writeData(T document) {
        AerospikeWriteData data = AerospikeWriteData.forWrite(this.getNamespace());
        this.converter.write(document, data);
        return data;
    }

    <T> AerospikeWriteData writeDataWithSpecificFields(T document, Collection<String> fields) {
        AerospikeWriteData data = AerospikeWriteData.forWrite(this.getNamespace());
        data.setRequestedBins(this.fieldsToBinNames(document, fields));
        this.converter.write(document, data);
        return data;
    }

    WritePolicy expectGenerationCasAwareSavePolicy(AerospikeWriteData data) {
        RecordExistsAction recordExistsAction = data.getVersion().filter(v -> (long)v.intValue() > 0L).map(v -> RecordExistsAction.UPDATE_ONLY).orElse(RecordExistsAction.CREATE_ONLY);
        return this.expectGenerationSavePolicy(data, recordExistsAction);
    }

    WritePolicy expectGenerationSavePolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction) {
        return WritePolicyBuilder.builder(this.writePolicyDefault).generationPolicy(GenerationPolicy.EXPECT_GEN_EQUAL).generation(data.getVersion().orElse(0)).expiration(data.getExpiration()).recordExistsAction(recordExistsAction).build();
    }

    WritePolicy ignoreGenerationSavePolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction) {
        return WritePolicyBuilder.builder(this.writePolicyDefault).generationPolicy(GenerationPolicy.NONE).expiration(data.getExpiration()).recordExistsAction(recordExistsAction).build();
    }

    WritePolicy ignoreGenerationDeletePolicy() {
        return WritePolicyBuilder.builder(this.writePolicyDefault).generationPolicy(GenerationPolicy.NONE).build();
    }

    Key getKey(Object id, AerospikePersistentEntity<?> entity) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        String userKey = this.convertIfNecessary(id, String.class);
        return new Key(this.namespace, entity.getSetName(), userKey);
    }

    GroupedEntities toGroupedEntities(EntitiesKeys entitiesKeys, Record[] records) {
        GroupedEntities.GroupedEntitiesBuilder builder = GroupedEntities.builder();
        IntStream.range(0, entitiesKeys.getKeys().length).filter(index -> records[index] != null).mapToObj(index -> this.mapToEntity(entitiesKeys.getKeys()[index], entitiesKeys.getEntityClasses()[index], records[index])).filter(Objects::nonNull).forEach(entity -> builder.entity(this.getEntityClass(entity), entity));
        return builder.build();
    }

    Map<Class<?>, List<Key>> toEntitiesKeyMap(GroupedKeys groupedKeys) {
        return groupedKeys.getEntitiesKeys().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.toKeysList((Class)entry.getKey(), (Collection)entry.getValue())));
    }

    private <T> List<String> fieldsToBinNames(T document, Collection<String> fields) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        return fields.stream().map(field -> {
            if (entity.getPersistentProperty((String)field) != null) {
                return Objects.requireNonNull((AerospikePersistentProperty)entity.getPersistentProperty((String)field)).getFieldName();
            }
            if (this.getFieldAnnotatedValue(entity, (String)field) != null) {
                return field;
            }
            throw this.translateError(new AerospikeException("Cannot convert field: " + field + " to bin name. field doesn't exists."));
        }).collect(Collectors.toList());
    }

    private String getFieldAnnotatedValue(AerospikePersistentEntity<?> entity, String field) {
        for (AerospikePersistentProperty property : entity.getPersistentProperties(Field.class)) {
            if (!property.getFieldName().equals(field)) continue;
            return field;
        }
        return null;
    }

    private <T> List<Key> toKeysList(Class<T> entityClass, Collection<?> ids) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(ids, (String)"List of ids must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        List idsList = IterableConverter.toList(ids);
        return idsList.stream().map(id -> this.getKey(id, entity)).collect(Collectors.toList());
    }

    private <S> S convertIfNecessary(Object source, Class<S> type) {
        return (S)(type.isAssignableFrom(source.getClass()) ? source : this.converter.getConversionService().convert(source, type));
    }
}

