/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.Bin;
import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import java.util.Map;
import java.util.function.Function;
import org.springframework.lang.Nullable;

public class OperationUtils {
    static <T> Operation[] operations(Map<String, T> values, Operation.Type operationType, Operation ... additionalOperations) {
        Operation[] operations = new Operation[values.size() + additionalOperations.length];
        int x = 0;
        for (Map.Entry<String, T> entry : values.entrySet()) {
            operations[x] = new Operation(operationType, entry.getKey(), Value.get(entry.getValue()));
            ++x;
        }
        Operation[] operationArray = additionalOperations;
        int n = operationArray.length;
        for (int i = 0; i < n; ++i) {
            Operation additionalOp;
            operations[x] = additionalOp = operationArray[i];
            ++x;
        }
        return operations;
    }

    static Operation[] operations(Bin[] bins, Function<Bin, Operation> binToOperation) {
        return OperationUtils.operations(bins, binToOperation, null, null);
    }

    static Operation[] operations(Bin[] bins, Function<Bin, Operation> binToOperation, Operation[] precedingOperations) {
        return OperationUtils.operations(bins, binToOperation, precedingOperations, null);
    }

    static Operation[] operations(Bin[] bins, Function<Bin, Operation> binToOperation, @Nullable Operation[] precedingOperations, @Nullable Operation[] additionalOperations) {
        int n;
        int n2;
        Operation[] operationArray;
        int precedingOpsLength = precedingOperations == null ? 0 : precedingOperations.length;
        int additionalOpsLength = additionalOperations == null ? 0 : additionalOperations.length;
        Operation[] operations = new Operation[precedingOpsLength + bins.length + additionalOpsLength];
        int i = 0;
        if (precedingOpsLength > 0) {
            operationArray = precedingOperations;
            n2 = operationArray.length;
            for (n = 0; n < n2; ++n) {
                Operation operation;
                operations[i] = operation = operationArray[n];
                ++i;
            }
        }
        for (Operation operation : bins) {
            operations[i] = binToOperation.apply((Bin)operation);
            ++i;
        }
        if (additionalOpsLength > 0) {
            operationArray = additionalOperations;
            n2 = operationArray.length;
            for (n = 0; n < n2; ++n) {
                Operation operation;
                operations[i] = operation = operationArray[n];
                ++i;
            }
        }
        return operations;
    }
}

