/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.exp.ListExp;
import com.aerospike.client.exp.MapExp;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FilterOperation {
    AND{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            Qualifier[] qs = (Qualifier[])map.get("qualifiers");
            Exp[] childrenExp = new Exp[qs.length];
            for (int i = 0; i < qs.length; ++i) {
                childrenExp[i] = qs[i].toFilterExp();
            }
            return Exp.and((Exp[])childrenExp);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    OR{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            Qualifier[] qs = (Qualifier[])map.get("qualifiers");
            Exp[] childrenExp = new Exp[qs.length];
            for (int i = 0; i < qs.length; ++i) {
                childrenExp[i] = qs[i].toFilterExp();
            }
            return Exp.or((Exp[])childrenExp);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    IN{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            Value val = this.getValue1(map);
            int valType = val.getType();
            if (valType != 20) {
                throw new IllegalArgumentException("FilterOperation.IN expects List argument with type: 20, but got: " + valType);
            }
            List inList = (List)val.getObject();
            Exp[] listElementsExp = new Exp[inList.size()];
            for (int i = 0; i < inList.size(); ++i) {
                listElementsExp[i] = new Qualifier(new Qualifier.QualifierBuilder().setField(this.getField(map)).setFilterOperation(EQ).setValue1(Value.get(inList.get(i)))).toFilterExp();
            }
            return Exp.or((Exp[])listElementsExp);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    EQ{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            Value val = this.getValue1(map);
            return switch (val.getType()) {
                case 1 -> Exp.eq((Exp)Exp.intBin((String)this.getField(map)), (Exp)Exp.val((long)val.toLong()));
                case 3 -> {
                    if (this.ignoreCase(map).booleanValue()) {
                        String equalsRegexp = Qualifier.QualifierRegexpBuilder.getStringEquals(this.getValue1(map).toString());
                        yield Exp.regexCompare((String)equalsRegexp, (int)2, (Exp)Exp.stringBin((String)this.getField(map)));
                    }
                    yield Exp.eq((Exp)Exp.stringBin((String)this.getField(map)), (Exp)Exp.val((String)val.toString()));
                }
                case 7, 19 -> Exp.eq((Exp)Exp.mapBin((String)this.getField(map)), (Exp)FilterOperation.toExp(this.getConverter(map).toWritableValue(val.getObject(), TypeInformation.of(val.getObject().getClass()))));
                default -> throw new AerospikeException("EQ FilterExpression unsupported particle type: " + val.getType());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() == 1) {
                return Filter.equal((String)this.getField(map), (long)this.getValue1(map).toLong(), (CTX[])new CTX[0]);
            }
            if (this.ignoreCase(map).booleanValue()) {
                return null;
            }
            return Filter.equal((String)this.getField(map), (String)this.getValue1(map).toString(), (CTX[])new CTX[0]);
        }
    }
    ,
    NOTEQ{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            Value val = this.getValue1(map);
            return switch (val.getType()) {
                case 1 -> Exp.ne((Exp)Exp.intBin((String)this.getField(map)), (Exp)Exp.val((long)val.toLong()));
                case 3 -> {
                    if (this.ignoreCase(map).booleanValue()) {
                        String equalsRegexp = Qualifier.QualifierRegexpBuilder.getStringEquals(this.getValue1(map).toString());
                        yield Exp.not((Exp)Exp.regexCompare((String)equalsRegexp, (int)2, (Exp)Exp.stringBin((String)this.getField(map))));
                    }
                    yield Exp.ne((Exp)Exp.stringBin((String)this.getField(map)), (Exp)Exp.val((String)val.toString()));
                }
                case 7, 19 -> Exp.ne((Exp)Exp.mapBin((String)this.getField(map)), (Exp)FilterOperation.toExp(this.getConverter(map).toWritableValue(val.getObject(), TypeInformation.of(val.getObject().getClass()))));
                default -> throw new AerospikeException("NOTEQ FilterExpression unsupported particle type: " + val.getType());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    GT{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            Value val = this.getValue1(map);
            return switch (val.getType()) {
                case 1 -> Exp.gt((Exp)Exp.intBin((String)this.getField(map)), (Exp)Exp.val((long)this.getValue1(map).toLong()));
                case 3 -> Exp.gt((Exp)Exp.stringBin((String)this.getField(map)), (Exp)Exp.val((String)this.getValue1(map).toString()));
                case 7, 19 -> Exp.gt((Exp)Exp.mapBin((String)this.getField(map)), (Exp)FilterOperation.toExp(this.getConverter(map).toWritableValue(val.getObject(), TypeInformation.of(val.getObject().getClass()))));
                default -> throw new AerospikeException("GT FilterExpression unsupported particle type: " + val.getType());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue1(map).toLong() == Long.MAX_VALUE) {
                throw new AerospikeException("GT sIndexFilter unsupported type: expected [Long.MIN_VALUE..Long.MAX_VALUE-1]");
            }
            return Filter.range((String)this.getField(map), (long)(this.getValue1(map).toLong() + 1L), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    GTEQ{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            Value val = this.getValue1(map);
            return switch (val.getType()) {
                case 1 -> Exp.ge((Exp)Exp.intBin((String)this.getField(map)), (Exp)Exp.val((long)this.getValue1(map).toLong()));
                case 3 -> Exp.ge((Exp)Exp.stringBin((String)this.getField(map)), (Exp)Exp.val((String)this.getValue1(map).toString()));
                case 7, 19 -> Exp.ge((Exp)Exp.mapBin((String)this.getField(map)), (Exp)FilterOperation.toExp(this.getConverter(map).toWritableValue(val.getObject(), TypeInformation.of(val.getObject().getClass()))));
                default -> throw new AerospikeException("GTEQ FilterExpression unsupported particle type: " + val.getType());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1) {
                throw new AerospikeException("GTEQ sIndexFilter unsupported type: expected Long");
            }
            return Filter.range((String)this.getField(map), (long)this.getValue1(map).toLong(), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    LT{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            Value val = this.getValue1(map);
            return switch (val.getType()) {
                case 1 -> Exp.lt((Exp)Exp.intBin((String)this.getField(map)), (Exp)Exp.val((long)this.getValue1(map).toLong()));
                case 3 -> Exp.lt((Exp)Exp.stringBin((String)this.getField(map)), (Exp)Exp.val((String)this.getValue1(map).toString()));
                case 7, 19 -> Exp.lt((Exp)Exp.mapBin((String)this.getField(map)), (Exp)FilterOperation.toExp(this.getConverter(map).toWritableValue(val.getObject(), TypeInformation.of(val.getObject().getClass()))));
                default -> throw new AerospikeException("LT FilterExpression unsupported particle type: " + val.getType());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue1(map).toLong() == Long.MIN_VALUE) {
                throw new AerospikeException("LT sIndexFilter unsupported type: expected [Long.MIN_VALUE+1..Long.MAX_VALUE]");
            }
            return Filter.range((String)this.getField(map), (long)Long.MIN_VALUE, (long)(this.getValue1(map).toLong() - 1L), (CTX[])new CTX[0]);
        }
    }
    ,
    LTEQ{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            Value val = this.getValue1(map);
            return switch (val.getType()) {
                case 1 -> Exp.le((Exp)Exp.intBin((String)this.getField(map)), (Exp)Exp.val((long)this.getValue1(map).toLong()));
                case 3 -> Exp.le((Exp)Exp.stringBin((String)this.getField(map)), (Exp)Exp.val((String)this.getValue1(map).toString()));
                case 7, 19 -> Exp.le((Exp)Exp.mapBin((String)this.getField(map)), (Exp)FilterOperation.toExp(this.getConverter(map).toWritableValue(val.getObject(), TypeInformation.of(val.getObject().getClass()))));
                default -> throw new AerospikeException("LTEQ FilterExpression unsupported particle type: " + val.getType());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1) {
                throw new AerospikeException("LTEQ sIndexFilter unsupported type: expected Long");
            }
            return Filter.range((String)this.getField(map), (long)Long.MIN_VALUE, (long)this.getValue1(map).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    BETWEEN{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() == 1 && this.getValue2(map).getType() == 1) {
                return Exp.and((Exp[])new Exp[]{Exp.ge((Exp)Exp.intBin((String)this.getField(map)), (Exp)Exp.val((long)this.getValue1(map).toLong())), Exp.le((Exp)Exp.intBin((String)this.getField(map)), (Exp)Exp.val((long)this.getValue2(map).toLong()))});
            }
            throw new AerospikeException("BETWEEN FilterExpression unsupported type: expected Long");
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue2(map).getType() != 1) {
                throw new AerospikeException("BETWEEN sIndexFilter unsupported type: expected Long");
            }
            return Filter.range((String)this.getField(map), (long)this.getValue1(map).toLong(), (long)this.getValue2(map).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    STARTS_WITH{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            String startWithRegexp = Qualifier.QualifierRegexpBuilder.getStartsWith(this.getValue1(map).toString());
            return Exp.regexCompare((String)startWithRegexp, (int)this.regexFlags(map), (Exp)Exp.stringBin((String)this.getField(map)));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    ENDS_WITH{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            String endWithRegexp = Qualifier.QualifierRegexpBuilder.getEndsWith(this.getValue1(map).toString());
            return Exp.regexCompare((String)endWithRegexp, (int)this.regexFlags(map), (Exp)Exp.stringBin((String)this.getField(map)));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    CONTAINING{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            String containingRegexp = Qualifier.QualifierRegexpBuilder.getContaining(this.getValue1(map).toString());
            return Exp.regexCompare((String)containingRegexp, (int)this.regexFlags(map), (Exp)Exp.stringBin((String)this.getField(map)));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    LIKE{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            int flags = 1;
            if (this.ignoreCase(map).booleanValue()) {
                flags = 3;
            }
            return Exp.regexCompare((String)this.getValue1(map).toString(), (int)flags, (Exp)Exp.stringBin((String)this.getField(map)));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    MAP_VALUE_EQ_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUE_EQ_BY_KEY filter expression: dotPath has not been set");
            boolean useCtx = dotPathArr.length > 2;
            return switch (this.getValue1(map).getType()) {
                case 3 -> {
                    if (this.ignoreCase(map).booleanValue()) {
                        throw new IllegalArgumentException("MAP_VALUE_EQ_BY_KEY FilterExpression: case insensitive comparison is not supported");
                    }
                    Exp mapExp = useCtx ? MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]);
                    yield Exp.eq((Exp)mapExp, (Exp)Exp.val((String)this.getValue1(map).toString()));
                }
                case 1 -> {
                    Exp mapExp = useCtx ? MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]);
                    yield Exp.eq((Exp)mapExp, (Exp)Exp.val((long)this.getValue1(map).toLong()));
                }
                case 7 -> {
                    Object obj = this.getValue1(map).getObject();
                    Exp mapExp = useCtx ? MapExp.getByKey((int)7, (Exp.Type)Exp.Type.MAP, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)Exp.Type.MAP, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]);
                    yield Exp.eq((Exp)mapExp, (Exp)FilterOperation.toExp(this.getConverter(map).toWritableValue(obj, TypeInformation.of(obj.getClass()))));
                }
                default -> throw new AerospikeException("MAP_VALUE_EQ_BY_KEY FilterExpression unsupported type: " + this.getValue1(map).getType());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUE_EQ_BY_KEY secondary index filter: dotPath has not been set");
            boolean useCtx = dotPathArr.length > 2;
            return switch (this.getValue1(map).getType()) {
                case 3 -> {
                    if (this.ignoreCase(map).booleanValue()) {
                        yield null;
                    }
                    if (useCtx) {
                        yield null;
                    }
                    yield Filter.contains((String)this.getField(map), (IndexCollectionType)IndexCollectionType.MAPVALUES, (String)this.getValue1(map).toString(), (CTX[])new CTX[0]);
                }
                case 1 -> {
                    if (useCtx) {
                        yield null;
                    }
                    yield Filter.range((String)this.getField(map), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)this.getValue1(map).toLong(), (long)this.getValue1(map).toLong(), (CTX[])new CTX[0]);
                }
                default -> throw new AerospikeException("MAP_VALUE_EQ_BY_KEY FilterExpression unsupported type: " + this.getValue1(map).getType());
            };
        }
    }
    ,
    MAP_VALUE_NOTEQ_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUE_NOTEQ_BY_KEY filter expression: dotPath has not been set");
            boolean useCtx = dotPathArr.length > 2;
            return switch (this.getValue1(map).getType()) {
                case 3 -> {
                    if (this.ignoreCase(map).booleanValue()) {
                        throw new IllegalArgumentException("MAP_VALUE_NOTEQ_BY_KEY FilterExpression: case insensitive comparison is not supported");
                    }
                    Exp mapExp = useCtx ? MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]);
                    yield Exp.ne((Exp)mapExp, (Exp)Exp.val((String)this.getValue1(map).toString()));
                }
                case 1 -> {
                    Exp mapExp = useCtx ? MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]);
                    yield Exp.ne((Exp)mapExp, (Exp)Exp.val((long)this.getValue1(map).toLong()));
                }
                case 7 -> {
                    Object obj = this.getValue1(map).getObject();
                    Exp mapExp = useCtx ? MapExp.getByKey((int)7, (Exp.Type)Exp.Type.MAP, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)Exp.Type.MAP, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]);
                    yield Exp.ne((Exp)mapExp, (Exp)FilterOperation.toExp(this.getConverter(map).toWritableValue(obj, TypeInformation.of(obj.getClass()))));
                }
                default -> throw new AerospikeException("MAP_VALUE_NOTEQ_BY_KEY FilterExpression unsupported type: " + this.getValue1(map).getType());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    MAP_VALUE_GT_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() == 1) {
                String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUE_GT_BY_KEY filter expression: dotPath has not been set");
                Exp mapExp = dotPathArr.length > 2 ? MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]);
                return Exp.gt((Exp)mapExp, (Exp)Exp.val((long)this.getValue1(map).toLong()));
            }
            throw new AerospikeException("MAP_VALUE_GT_BY_KEY FilterExpression unsupported type: expected Long");
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue1(map).toLong() == Long.MAX_VALUE) {
                throw new AerospikeException("MAP_VALUE_GT_BY_KEY sIndexFilter unsupported type: expected [Long.MIN_VALUE..Long.MAX_VALUE-1]");
            }
            String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUE_GT_BY_KEY secondary index filter: dotPath has not been set");
            if (dotPathArr.length > 2) {
                return null;
            }
            return Filter.range((String)this.getField(map), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)(this.getValue1(map).toLong() + 1L), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    MAP_VALUE_GTEQ_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() == 1) {
                String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUE_GTEQ_BY_KEY filter expression: dotPath has not been set");
                Exp mapExp = dotPathArr.length > 2 ? MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]);
                return Exp.ge((Exp)mapExp, (Exp)Exp.val((long)this.getValue1(map).toLong()));
            }
            throw new AerospikeException("MAP_VALUE_GTEQ_BY_KEY FilterExpression unsupported type: expected Long");
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1) {
                throw new AerospikeException("MAP_VALUE_GTEQ_BY_KEY sIndexFilter unsupported type: expected Long");
            }
            String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUE_GTEQ_BY_KEY secondary index filter: dotPath has not been set");
            if (dotPathArr.length > 2) {
                return null;
            }
            return Filter.range((String)this.getField(map), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)this.getValue1(map).toLong(), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    MAP_VALUE_LT_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUE_LT_BY_KEY filter expression: dotPath has not been set");
            if (this.getValue1(map).getType() == 1) {
                Exp mapExp = dotPathArr.length > 2 ? MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]);
                return Exp.lt((Exp)mapExp, (Exp)Exp.val((long)this.getValue1(map).toLong()));
            }
            throw new AerospikeException("MAP_VALUE_LT_BY_KEY FilterExpression unsupported type: expected Long");
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue1(map).toLong() == Long.MIN_VALUE) {
                throw new AerospikeException("MAP_VALUE_LT_BY_KEY sIndexFilter unsupported type: expected [Long.MIN_VALUE+1..Long.MAX_VALUE]");
            }
            String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUE_LT_BY_KEY secondary index filter: dotPath has not been set");
            if (dotPathArr.length > 2) {
                return null;
            }
            return Filter.range((String)this.getField(map), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)Long.MIN_VALUE, (long)(this.getValue1(map).toLong() - 1L), (CTX[])new CTX[0]);
        }
    }
    ,
    MAP_VALUE_LTEQ_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() == 1) {
                String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUE_LTEQ_BY_KEY filter expression: dotPath has not been set");
                Exp mapExp = dotPathArr.length > 2 ? MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]);
                return Exp.le((Exp)mapExp, (Exp)Exp.val((long)this.getValue1(map).toLong()));
            }
            throw new AerospikeException("MAP_VALUE_LTEQ_BY_KEY FilterExpression unsupported type: expected Long");
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1) {
                throw new AerospikeException("MAP_VALUE_LTEQ_BY_KEY sIndexFilter unsupported type: expected Long");
            }
            String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUE_LTEQ_BY_KEY secondary index filter: dotPath has not been set");
            if (dotPathArr.length > 2) {
                return null;
            }
            return Filter.range((String)this.getField(map), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)Long.MIN_VALUE, (long)this.getValue1(map).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    MAP_VALUES_BETWEEN_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue3(map).getType() != 1) {
                throw new AerospikeException("MAP_VALUES_BETWEEN_BY_KEY FilterExpression unsupported type: expected Long");
            }
            String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUES_BETWEEN_BY_KEY filter expression: dotPath has not been set");
            Exp mapExp = dotPathArr.length > 2 ? MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]);
            return Exp.and((Exp[])new Exp[]{Exp.ge((Exp)mapExp, (Exp)Exp.val((long)this.getValue1(map).toLong())), Exp.le((Exp)mapExp, (Exp)Exp.val((long)this.getValue3(map).toLong()))});
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue3(map).getType() != 1) {
                throw new AerospikeException("MAP_VALUES_BETWEEN_BY_KEY sIndex filter unsupported type: expected Long");
            }
            String[] dotPathArr = FilterOperation.getDotPathArray(this.getDotPath(map), "MAP_VALUES_BETWEEN_BY_KEY secondary index filter: dotPath has not been set");
            if (dotPathArr.length > 2) {
                return null;
            }
            return Filter.range((String)this.getField(map), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)this.getValue1(map).toLong(), (long)this.getValue3(map).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    MAP_VALUE_STARTS_WITH_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            String startWithRegexp = Qualifier.QualifierRegexpBuilder.getStartsWith(this.getValue1(map).toString());
            return Exp.regexCompare((String)startWithRegexp, (int)this.regexFlags(map), (Exp)MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    MAP_VALUE_LIKE_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            int flags = 1;
            if (this.ignoreCase(map).booleanValue()) {
                flags = 3;
            }
            return Exp.regexCompare((String)this.getValue1(map).toString(), (int)flags, (Exp)MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    MAP_VALUE_ENDS_WITH_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            String endWithRegexp = Qualifier.QualifierRegexpBuilder.getEndsWith(this.getValue1(map).toString());
            return Exp.regexCompare((String)endWithRegexp, (int)this.regexFlags(map), (Exp)MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    MAP_VALUE_CONTAINING_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            String containingRegexp = Qualifier.QualifierRegexpBuilder.getContaining(this.getValue1(map).toString());
            return Exp.regexCompare((String)containingRegexp, (int)this.regexFlags(map), (Exp)MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)this.getValue2(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return null;
        }
    }
    ,
    MAP_KEYS_CONTAIN{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            return switch (this.getValue1(map).getType()) {
                case 3 -> Exp.gt((Exp)MapExp.getByKey((int)5, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)this.getValue1(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                case 1 -> Exp.gt((Exp)MapExp.getByKey((int)5, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((long)this.getValue1(map).toLong()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                default -> throw new AerospikeException("MAP_KEYS_CONTAINS FilterExpression unsupported type: expected String or Long");
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return this.collectionContains(IndexCollectionType.MAPKEYS, map);
        }
    }
    ,
    MAP_VALUES_CONTAIN{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            return switch (this.getValue1(map).getType()) {
                case 3 -> Exp.gt((Exp)MapExp.getByValue((int)5, (Exp)Exp.val((String)this.getValue1(map).toString()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                case 1 -> Exp.gt((Exp)MapExp.getByValue((int)5, (Exp)Exp.val((long)this.getValue1(map).toLong()), (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                default -> throw new AerospikeException("MAP_VALUES_CONTAINS FilterExpression unsupported type: expected String or Long");
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return this.collectionContains(IndexCollectionType.MAPVALUES, map);
        }
    }
    ,
    MAP_KEYS_BETWEEN{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue2(map).getType() != 1) {
                throw new AerospikeException("MAP_KEYS_BETWEEN FilterExpression unsupported type: expected Long");
            }
            Exp upperLimit = Exp.val((long)(this.getValue2(map).toLong() + 1L));
            if (this.getValue2(map).toLong() == Long.MAX_VALUE) {
                upperLimit = null;
            }
            return Exp.gt((Exp)MapExp.getByKeyRange((int)5, (Exp)Exp.val((long)this.getValue1(map).toLong()), (Exp)upperLimit, (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return this.collectionRange(IndexCollectionType.MAPKEYS, map);
        }
    }
    ,
    MAP_VALUES_BETWEEN{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue2(map).getType() != 1) {
                throw new AerospikeException("MAP_VALUES_BETWEEN FilterExpression unsupported type: expected Long");
            }
            Exp upperLimit = Exp.val((long)(this.getValue2(map).toLong() + 1L));
            if (this.getValue2(map).toLong() == Long.MAX_VALUE) {
                upperLimit = null;
            }
            return Exp.gt((Exp)MapExp.getByValueRange((int)5, (Exp)Exp.val((long)this.getValue1(map).toLong()), (Exp)upperLimit, (Exp)Exp.mapBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue2(map).getType() != 1) {
                throw new AerospikeException("MAP_VALUES_BETWEEN sIndex filter unsupported type: expected Long");
            }
            return this.collectionRange(IndexCollectionType.MAPVALUES, map);
        }
    }
    ,
    GEO_WITHIN{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            return Exp.geoCompare((Exp)Exp.geoBin((String)this.getField(map)), (Exp)Exp.geo((String)this.getValue1(map).toString()));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            return this.geoWithinRadius(IndexCollectionType.DEFAULT, map);
        }
    }
    ,
    LIST_CONTAINS{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            return switch (this.getValue1(map).getType()) {
                case 3 -> Exp.gt((Exp)ListExp.getByValue((int)5, (Exp)Exp.val((String)this.getValue1(map).toString()), (Exp)Exp.listBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                case 1 -> Exp.gt((Exp)ListExp.getByValue((int)5, (Exp)Exp.val((long)this.getValue1(map).toLong()), (Exp)Exp.listBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                default -> throw new AerospikeException("LIST_CONTAINS FilterExpression unsupported type: expected String or Long");
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 3 && this.getValue1(map).getType() != 1) {
                throw new AerospikeException("LIST_CONTAINS sIndexFilter unsupported type: expected String or Long");
            }
            return this.collectionContains(IndexCollectionType.LIST, map);
        }
    }
    ,
    LIST_VALUE_BETWEEN{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue2(map).getType() != 1) {
                throw new AerospikeException("LIST_BETWEEN FilterExpression unsupported type: expected Long");
            }
            Exp upperLimit = Exp.val((long)(this.getValue2(map).toLong() + 1L));
            if (this.getValue2(map).toLong() == Long.MAX_VALUE) {
                upperLimit = null;
            }
            return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)Exp.val((long)this.getValue1(map).toLong()), (Exp)upperLimit, (Exp)Exp.listBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue2(map).getType() != 1) {
                throw new AerospikeException("LIST_BETWEEN sIndexFilter unsupported type: expected Long");
            }
            return this.collectionRange(IndexCollectionType.LIST, map);
        }
    }
    ,
    LIST_VALUE_GT{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue1(map).toLong() == Long.MAX_VALUE) {
                throw new AerospikeException("LIST_VALUE_GT FilterExpression unsupported type: expected [Long.MIN_VALUE..Long.MAX_VALUE-1]");
            }
            return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)Exp.val((long)(this.getValue1(map).toLong() + 1L)), (Exp)Exp.val((long)Long.MAX_VALUE), (Exp)Exp.listBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue1(map).toLong() == Long.MAX_VALUE) {
                throw new AerospikeException("LIST_VALUE_GT sIndexFilter unsupported type: expected [Long.MIN_VALUE..Long.MAX_VALUE-1]");
            }
            return Filter.range((String)this.getField(map), (IndexCollectionType)IndexCollectionType.LIST, (long)(this.getValue1(map).toLong() + 1L), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    LIST_VALUE_GTEQ{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1) {
                throw new AerospikeException("LIST_VALUE_GTEQ FilterExpression unsupported type: expected Long");
            }
            return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)Exp.val((long)this.getValue1(map).toLong()), null, (Exp)Exp.listBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1) {
                throw new AerospikeException("LIST_VALUE_GTEQ sIndexFilter unsupported type: expected Long");
            }
            return Filter.range((String)this.getField(map), (IndexCollectionType)IndexCollectionType.LIST, (long)this.getValue1(map).toLong(), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    LIST_VALUE_LT{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue1(map).toLong() == Long.MIN_VALUE) {
                throw new AerospikeException("LIST_VALUE_LT FilterExpression unsupported type: expected [Long.MIN_VALUE+1..Long.MAX_VALUE]");
            }
            return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)Exp.val((long)Long.MIN_VALUE), (Exp)Exp.val((long)(this.getValue1(map).toLong() - 1L)), (Exp)Exp.listBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1 || this.getValue1(map).toLong() == Long.MIN_VALUE) {
                throw new AerospikeException("LIST_VALUE_LT sIndexFilter unsupported type: expected [Long.MIN_VALUE+1..Long.MAX_VALUE]");
            }
            return Filter.range((String)this.getField(map), (IndexCollectionType)IndexCollectionType.LIST, (long)Long.MIN_VALUE, (long)(this.getValue1(map).toLong() - 1L), (CTX[])new CTX[0]);
        }
    }
    ,
    LIST_VALUE_LTEQ{

        @Override
        public Exp filterExp(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1) {
                throw new AerospikeException("LIST_VALUE_LTEQ FilterExpression unsupported type: expected Long");
            }
            Exp upperLimit = Exp.val((long)(this.getValue1(map).toLong() + 1L));
            if (this.getValue1(map).toLong() == Long.MAX_VALUE) {
                upperLimit = null;
            }
            return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)Exp.val((long)Long.MIN_VALUE), (Exp)upperLimit, (Exp)Exp.listBin((String)this.getField(map)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> map) {
            if (this.getValue1(map).getType() != 1) {
                throw new AerospikeException("LIST_VALUE_LTEQ sIndexFilter unsupported type: expected Long");
            }
            return Filter.range((String)this.getField(map), (IndexCollectionType)IndexCollectionType.LIST, (long)Long.MIN_VALUE, (long)this.getValue1(map).toLong(), (CTX[])new CTX[0]);
        }
    };

    public static final List<FilterOperation> dualFilterOperations;

    private static String[] getDotPathArray(String dotPath, String errMsg) {
        if (StringUtils.hasLength((String)dotPath)) {
            return dotPath.split("\\.");
        }
        throw new IllegalArgumentException(errMsg);
    }

    private static CTX[] dotPathToCtxMapKeys(String[] dotPathArray) {
        return (CTX[])Arrays.stream(dotPathArray).map(str -> CTX.mapKey((Value)Value.get((String)str))).skip(1L).limit((long)dotPathArray.length - 2L).toArray(CTX[]::new);
    }

    private static Exp toExp(Object value) {
        Exp res;
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            res = Exp.val((long)((Number)value).longValue());
        } else if (value instanceof Float || value instanceof Double) {
            res = Exp.val((double)((Number)value).doubleValue());
        } else if (value instanceof String) {
            res = Exp.val((String)((String)value));
        } else if (value instanceof Boolean) {
            res = Exp.val((boolean)((Boolean)value));
        } else if (value instanceof Map) {
            res = Exp.val((Map)((Map)value));
        } else if (value instanceof List) {
            res = Exp.val((List)((List)value));
        } else if (value instanceof byte[]) {
            res = Exp.val((byte[])((byte[])value));
        } else if (value instanceof Calendar) {
            res = Exp.val((Calendar)((Calendar)value));
        } else {
            throw new IllegalArgumentException("Unsupported type for converting: " + value.getClass().getCanonicalName());
        }
        return res;
    }

    public abstract Exp filterExp(Map<String, Object> var1);

    public abstract Filter sIndexFilter(Map<String, Object> var1);

    protected String getField(Map<String, Object> map) {
        return (String)map.get("field");
    }

    protected Boolean ignoreCase(Map<String, Object> map) {
        return (Boolean)map.getOrDefault("ignoreCase", false);
    }

    protected int regexFlags(Map<String, Object> map) {
        return this.ignoreCase(map) != false ? 2 : 0;
    }

    protected Value getValue1(Map<String, Object> map) {
        return (Value)map.get("value1");
    }

    protected Value getValue2(Map<String, Object> map) {
        return (Value)map.get("value2");
    }

    protected Value getValue3(Map<String, Object> map) {
        return (Value)map.get("value3");
    }

    protected String getDotPath(Map<String, Object> map) {
        return (String)map.get("dotPath");
    }

    protected MappingAerospikeConverter getConverter(Map<String, Object> map) {
        return (MappingAerospikeConverter)map.get("converter");
    }

    protected Filter collectionContains(IndexCollectionType collectionType, Map<String, Object> map) {
        Value val = this.getValue1(map);
        int valType = val.getType();
        return switch (valType) {
            case 1 -> Filter.contains((String)this.getField(map), (IndexCollectionType)collectionType, (long)val.toLong(), (CTX[])new CTX[0]);
            case 3 -> Filter.contains((String)this.getField(map), (IndexCollectionType)collectionType, (String)val.toString(), (CTX[])new CTX[0]);
            default -> null;
        };
    }

    protected Filter collectionRange(IndexCollectionType collectionType, Map<String, Object> map) {
        return Filter.range((String)this.getField(map), (IndexCollectionType)collectionType, (long)this.getValue1(map).toLong(), (long)this.getValue2(map).toLong(), (CTX[])new CTX[0]);
    }

    protected Filter geoWithinRadius(IndexCollectionType collectionType, Map<String, Object> map) {
        return Filter.geoContains((String)this.getField(map), (String)this.getValue1(map).toString(), (CTX[])new CTX[0]);
    }

    static {
        dualFilterOperations = Arrays.asList(MAP_VALUE_EQ_BY_KEY, MAP_VALUE_GT_BY_KEY, MAP_VALUE_GTEQ_BY_KEY, MAP_VALUE_LT_BY_KEY, MAP_VALUE_LTEQ_BY_KEY, MAP_VALUES_BETWEEN_BY_KEY);
    }
}

