/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.Key;
import com.aerospike.client.Value;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.query.QueryEngine;

public class KeyQualifier
extends Qualifier {
    private static final long serialVersionUID = 2430949321378171078L;
    boolean hasDigest = false;

    public KeyQualifier(Value value) {
        super(new Qualifier.QualifierBuilder().setField(QueryEngine.Meta.KEY.toString()).setFilterOperation(FilterOperation.EQ).setValue1(value));
    }

    public KeyQualifier(byte[] digest) {
        super(new Qualifier.QualifierBuilder().setField(QueryEngine.Meta.KEY.toString()).setFilterOperation(FilterOperation.EQ).setValue1(null));
        this.internalMap.put("digest", digest);
        this.hasDigest = true;
    }

    @Override
    protected String luaFieldString(String field) {
        return "digest";
    }

    public byte[] getDigest() {
        return (byte[])this.internalMap.get("digest");
    }

    public Key makeKey(String namespace, String set) {
        if (this.hasDigest) {
            byte[] digest = this.getDigest();
            return new Key(namespace, digest, set, null);
        }
        return new Key(namespace, set, this.getValue1());
    }
}

