/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.query.Filter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.query.FilterOperation;

public class Qualifier
implements Map<String, Object>,
Serializable {
    protected static final String FIELD = "field";
    protected static final String IGNORE_CASE = "ignoreCase";
    protected static final String VALUE1 = "value1";
    protected static final String VALUE2 = "value2";
    protected static final String VALUE3 = "value3";
    protected static final String DOT_PATH = "dotPath";
    protected static final String CONVERTER = "converter";
    protected static final String QUALIFIERS = "qualifiers";
    protected static final String OPERATION = "operation";
    protected static final String AS_FILTER = "queryAsFilter";
    private static final long serialVersionUID = -2689196529952712849L;
    protected final Map<String, Object> internalMap = new HashMap<String, Object>();

    public Qualifier(QualifierBuilder builder) {
        if (!builder.buildMap().isEmpty()) {
            this.internalMap.putAll(builder.buildMap());
        }
    }

    public FilterOperation getOperation() {
        return (FilterOperation)((Object)this.internalMap.get(OPERATION));
    }

    public String getField() {
        return (String)this.internalMap.get(FIELD);
    }

    public void asFilter(Boolean queryAsFilter) {
        this.internalMap.put(AS_FILTER, queryAsFilter);
    }

    public Boolean queryAsFilter() {
        return this.internalMap.containsKey(AS_FILTER) && (Boolean)this.internalMap.get(AS_FILTER) != false;
    }

    public Qualifier[] getQualifiers() {
        return (Qualifier[])this.internalMap.get(QUALIFIERS);
    }

    public Value getValue1() {
        return (Value)this.internalMap.get(VALUE1);
    }

    public Value getValue2() {
        return (Value)this.internalMap.get(VALUE2);
    }

    public Value getValue3() {
        return (Value)this.internalMap.get(VALUE3);
    }

    public Filter asFilter() {
        try {
            return FilterOperation.valueOf(this.getOperation().toString()).sIndexFilter(this.internalMap);
        }
        catch (Exception e) {
            throw new AerospikeException((String)(e.getMessage().isEmpty() ? "Secondary index filter unsupported operation: " + this.getOperation() : e.getMessage()));
        }
    }

    public Exp toFilterExp() {
        try {
            return FilterOperation.valueOf(this.getOperation().toString()).filterExp(this.internalMap);
        }
        catch (Exception e) {
            throw new AerospikeException((String)(e.getMessage().isEmpty() ? "FilterExpression unsupported operation: " + this.getOperation() : e.getMessage()));
        }
    }

    protected String luaFieldString(String field) {
        return String.format("rec['%s']", field);
    }

    protected String luaValueString(Value value) {
        String res = null;
        if (null == value) {
            return res;
        }
        int type = value.getType();
        switch (type) {
            case 3: 
            case 23: {
                res = String.format("'%s'", value);
                break;
            }
            default: {
                res = value.toString();
            }
        }
        return res;
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.internalMap.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.internalMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.internalMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.internalMap.putAll(m);
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.internalMap.entrySet();
    }

    public String toString() {
        return String.format("%s:%s:%s:%s", new Object[]{this.getField(), this.getOperation(), this.getValue1(), this.getValue2()});
    }

    public static class QualifierBuilder {
        private final Map<String, Object> map = new HashMap<String, Object>();

        public QualifierBuilder setField(String field) {
            this.map.put(Qualifier.FIELD, field);
            return this;
        }

        public QualifierBuilder setIgnoreCase(boolean ignoreCase) {
            this.map.put(Qualifier.IGNORE_CASE, ignoreCase);
            return this;
        }

        public QualifierBuilder setFilterOperation(FilterOperation filterOperation) {
            this.map.put(Qualifier.OPERATION, (Object)filterOperation);
            return this;
        }

        public QualifierBuilder setQualifiers(Qualifier ... qualifiers) {
            this.map.put(Qualifier.QUALIFIERS, qualifiers);
            return this;
        }

        public QualifierBuilder setValue1(Value value1) {
            this.map.put(Qualifier.VALUE1, value1);
            return this;
        }

        public QualifierBuilder setValue2(Value value2) {
            this.map.put(Qualifier.VALUE2, value2);
            return this;
        }

        public QualifierBuilder setValue3(Value value3) {
            this.map.put(Qualifier.VALUE3, value3);
            return this;
        }

        public void setDotPath(String dotPath) {
            this.map.put(Qualifier.DOT_PATH, dotPath);
        }

        public QualifierBuilder setConverter(MappingAerospikeConverter converter) {
            this.map.put(Qualifier.CONVERTER, converter);
            return this;
        }

        public boolean hasValue1() {
            return this.map.containsKey(Qualifier.VALUE1) && this.map.get(Qualifier.VALUE1) != null;
        }

        public boolean hasValue2() {
            return this.map.containsKey(Qualifier.VALUE2) && this.map.get(Qualifier.VALUE2) != null;
        }

        public Qualifier build() {
            return new Qualifier(this);
        }

        public Map<String, Object> buildMap() {
            return this.map;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QualifierBuilder)) {
                return false;
            }
            QualifierBuilder other = (QualifierBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$map = this.getMap();
            Map<String, Object> other$map = other.getMap();
            return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QualifierBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $map = this.getMap();
            result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
            return result;
        }

        public String toString() {
            return "Qualifier.QualifierBuilder(map=" + this.getMap() + ")";
        }
    }

    public static class QualifierRegexpBuilder {
        private static final Character BACKSLASH = Character.valueOf('\\');
        private static final Character DOT = Character.valueOf('.');
        private static final Character ASTERISK = Character.valueOf('*');
        private static final Character DOLLAR = Character.valueOf('$');
        private static final Character OPEN_BRACKET = Character.valueOf('[');
        private static final Character CIRCUMFLEX = Character.valueOf('^');

        public static String escapeBRERegexp(String base) {
            StringBuilder builder = new StringBuilder();
            for (char stringChar : base.toCharArray()) {
                if (stringChar == BACKSLASH.charValue() || stringChar == DOT.charValue() || stringChar == ASTERISK.charValue() || stringChar == DOLLAR.charValue() || stringChar == OPEN_BRACKET.charValue() || stringChar == CIRCUMFLEX.charValue()) {
                    builder.append(BACKSLASH);
                }
                builder.append(stringChar);
            }
            return builder.toString();
        }

        private static String getRegexp(String base, FilterOperation op) {
            String escapedBase = QualifierRegexpBuilder.escapeBRERegexp(base);
            return switch (op) {
                case FilterOperation.STARTS_WITH -> "^" + escapedBase;
                case FilterOperation.ENDS_WITH -> escapedBase + "$";
                case FilterOperation.EQ -> "^" + escapedBase + "$";
                default -> escapedBase;
            };
        }

        public static String getStartsWith(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.STARTS_WITH);
        }

        public static String getEndsWith(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.ENDS_WITH);
        }

        public static String getContaining(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.CONTAINING);
        }

        public static String getStringEquals(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.EQ);
        }
    }
}

