/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import org.springframework.data.aerospike.query.FilterExpressionsBuilder;
import org.springframework.data.aerospike.query.KeyQualifier;
import org.springframework.data.aerospike.query.KeyRecordIterator;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.query.StatementBuilder;

public class QueryEngine {
    public static final String SCANS_DISABLED_MESSAGE = "Query without a filter will initiate a scan. Since scans are potentially dangerous operations, they are disabled by default in spring-data-aerospike. If you still need to use them, enable them via `scansEnabled` property in `org.springframework.data.aerospike.config.AerospikeDataSettings`.";
    private final IAerospikeClient client;
    private final StatementBuilder statementBuilder;
    private final FilterExpressionsBuilder filterExpressionsBuilder;
    private final QueryPolicy queryPolicy;
    private boolean scansEnabled = false;

    public QueryEngine(IAerospikeClient client, StatementBuilder statementBuilder, FilterExpressionsBuilder filterExpressionsBuilder, QueryPolicy queryPolicy) {
        this.client = client;
        this.statementBuilder = statementBuilder;
        this.filterExpressionsBuilder = filterExpressionsBuilder;
        this.queryPolicy = queryPolicy;
    }

    public KeyRecordIterator select(String namespace, String set, Filter filter, Qualifier ... qualifiers) {
        return this.select(namespace, set, null, filter, qualifiers);
    }

    public KeyRecordIterator select(String namespace, String set, String[] binNames, Filter filter, Qualifier ... qualifiers) {
        Qualifier qualifier;
        if (qualifiers != null && qualifiers.length == 1 && (qualifier = qualifiers[0]) instanceof KeyQualifier) {
            KeyQualifier kq = (KeyQualifier)qualifier;
            Key key = kq.makeKey(namespace, set);
            Record record = this.getRecord(null, key, binNames);
            if (record == null) {
                return new KeyRecordIterator(namespace);
            }
            KeyRecord keyRecord = new KeyRecord(key, record);
            return new KeyRecordIterator(namespace, keyRecord);
        }
        Statement statement = this.statementBuilder.build(namespace, set, filter, qualifiers, binNames);
        QueryPolicy localQueryPolicy = new QueryPolicy(this.queryPolicy);
        localQueryPolicy.filterExp = this.filterExpressionsBuilder.build(qualifiers);
        if (!this.scansEnabled && statement.getFilter() == null) {
            throw new IllegalStateException(SCANS_DISABLED_MESSAGE);
        }
        RecordSet rs = this.client.query(localQueryPolicy, statement);
        return new KeyRecordIterator(namespace, rs);
    }

    private Record getRecord(Policy policy, Key key, String[] binNames) {
        if (binNames == null || binNames.length == 0) {
            return this.client.get(policy, key);
        }
        return this.client.get(policy, key, binNames);
    }

    public void setScansEnabled(boolean scansEnabled) {
        this.scansEnabled = scansEnabled;
    }

    public QueryPolicy getQueryPolicy() {
        return this.queryPolicy;
    }

    public static enum Meta {
        KEY,
        TTL,
        EXPIRATION,
        GENERATION;


        public String toString() {
            switch (this) {
                case KEY: {
                    return "__key";
                }
                case EXPIRATION: {
                    return "__Expiration";
                }
                case GENERATION: {
                    return "__generation";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

