/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.cache;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.InfoPolicy;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.query.cache.IndexesCacheUpdater;
import org.springframework.data.aerospike.query.cache.InternalIndexOperations;
import org.springframework.data.aerospike.query.model.IndexesInfo;

public class IndexRefresher {
    private final Logger log = LoggerFactory.getLogger(IndexRefresher.class);
    private final IAerospikeClient client;
    private final InfoPolicy infoPolicy;
    private final InternalIndexOperations indexOperations;
    private final IndexesCacheUpdater indexesCacheUpdater;

    public IndexRefresher(IAerospikeClient client, InfoPolicy infoPolicy, InternalIndexOperations indexOperations, IndexesCacheUpdater indexesCacheUpdater) {
        this.client = client;
        this.infoPolicy = infoPolicy;
        this.indexOperations = indexOperations;
        this.indexesCacheUpdater = indexesCacheUpdater;
    }

    public void refreshIndexes() {
        this.log.trace("Loading indexes");
        IndexesInfo cache = Arrays.stream(this.client.getNodes()).filter(Node::isActive).findAny().map(node -> Info.request((InfoPolicy)this.infoPolicy, (Node)node, (String)this.indexOperations.buildGetIndexesCommand())).map(this.indexOperations::parseIndexesInfo).orElse(IndexesInfo.empty());
        this.log.debug("Loaded indexes: {}", cache.indexes);
        this.indexesCacheUpdater.update(cache);
    }

    public void clearCache() {
        this.indexesCacheUpdater.update(IndexesInfo.empty());
    }
}

