/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.repository.query.BaseAerospikePartTreeQuery;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;

public class AerospikePartTreeQuery
extends BaseAerospikePartTreeQuery {
    private final AerospikeOperations aerospikeOperations;

    public AerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evalContextProvider, AerospikeOperations aerospikeOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evalContextProvider, queryCreator);
        this.aerospikeOperations = aerospikeOperations;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Query query = this.prepareQuery(parameters, accessor);
        Class<?> targetClass = this.getTargetClass(accessor);
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            Stream<?> result = this.findByQuery(query, targetClass);
            long total = this.queryMethod.isSliceQuery() ? 0L : this.aerospikeOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
            return new PageImpl(result.collect(Collectors.toList()), accessor.getPageable(), total);
        }
        if (this.queryMethod.isStreamQuery()) {
            return this.findByQuery(query, targetClass);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.findByQuery(query, targetClass).collect(Collectors.toList());
        }
        if (this.queryMethod.isQueryForEntity()) {
            Stream<?> result = this.findByQuery(query, targetClass);
            return result.findFirst().orElse(null);
        }
        throw new UnsupportedOperationException("Query method " + this.queryMethod.getNamedQueryName() + " not supported.");
    }

    private Class<?> getTargetClass(ParametersParameterAccessor accessor) {
        if (accessor.getParameters().hasDynamicProjection()) {
            return accessor.findDynamicProjection();
        }
        if (this.queryMethod.getReturnedObjectType() != this.queryMethod.getEntityInformation().getJavaType()) {
            return this.queryMethod.getReturnedObjectType();
        }
        return this.queryMethod.getEntityInformation().getJavaType();
    }

    private Stream<?> findByQuery(Query query, Class<?> targetClass) {
        if (targetClass != this.queryMethod.getEntityInformation().getJavaType()) {
            return this.aerospikeOperations.find(query, this.queryMethod.getEntityInformation().getJavaType(), targetClass);
        }
        return this.aerospikeOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
    }
}

