/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.AerospikeCustomConversions;
import org.springframework.data.aerospike.convert.AerospikeTypeAliasAccessor;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeCriteria;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.TypeInformation;

public class AerospikeQueryCreator
extends AbstractQueryCreator<Query, AerospikeCriteria> {
    private static final Logger LOG = LoggerFactory.getLogger(AerospikeQueryCreator.class);
    private final AerospikeMappingContext context;
    private final AerospikeCustomConversions conversions = new AerospikeCustomConversions(Collections.emptyList());
    private final MappingAerospikeConverter converter = this.getMappingAerospikeConverter(this.conversions);

    public AerospikeQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
        this.context = new AerospikeMappingContext();
    }

    public AerospikeQueryCreator(PartTree tree, ParameterAccessor parameters, AerospikeMappingContext context) {
        super(tree, parameters);
        this.context = context;
    }

    private MappingAerospikeConverter getMappingAerospikeConverter(AerospikeCustomConversions conversions) {
        MappingAerospikeConverter converter = new MappingAerospikeConverter(new AerospikeMappingContext(), conversions, new AerospikeTypeAliasAccessor());
        converter.afterPropertiesSet();
        return converter;
    }

    protected AerospikeCriteria create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        return this.create(part, property, iterator);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AerospikeCriteria create(Part part, AerospikePersistentProperty property, Iterator<?> parameters) {
        void var6_8;
        FilterOperation op;
        String fieldName = property.getFieldName();
        Object obj = parameters.next();
        Object v2 = null;
        Qualifier.QualifierBuilder qb = new Qualifier.QualifierBuilder();
        Object value = obj;
        Optional basicTargetType = this.conversions.getCustomWriteTarget(obj.getClass());
        Object object = basicTargetType.map(aClass -> this.converter.getConversionService().convert(value, aClass)).orElse(obj);
        switch (part.getType()) {
            case AFTER: 
            case GREATER_THAN: {
                op = FilterOperation.GT;
                break;
            }
            case GREATER_THAN_EQUAL: {
                op = FilterOperation.GTEQ;
                break;
            }
            case BEFORE: 
            case LESS_THAN: {
                op = FilterOperation.LT;
                break;
            }
            case LESS_THAN_EQUAL: {
                op = FilterOperation.LTEQ;
                break;
            }
            case BETWEEN: {
                op = FilterOperation.BETWEEN;
                v2 = parameters.next();
                break;
            }
            case LIKE: {
                op = FilterOperation.LIKE;
                break;
            }
            case STARTING_WITH: {
                op = FilterOperation.STARTS_WITH;
                break;
            }
            case ENDING_WITH: {
                op = FilterOperation.ENDS_WITH;
                break;
            }
            case CONTAINING: {
                op = FilterOperation.CONTAINING;
                break;
            }
            case WITHIN: {
                op = FilterOperation.GEO_WITHIN;
                Value value2 = Value.get((String)String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", object, parameters.next(), parameters.next()));
                break;
            }
            case SIMPLE_PROPERTY: {
                op = FilterOperation.EQ;
                break;
            }
            case NEGATING_SIMPLE_PROPERTY: {
                op = FilterOperation.NOTEQ;
                break;
            }
            case IN: {
                op = FilterOperation.IN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported keyword!");
            }
        }
        TypeInformation propertyType = property.getTypeInformation();
        if (propertyType.isCollectionLike()) {
            switch (op) {
                case CONTAINING: {
                    op = FilterOperation.LIST_CONTAINS;
                    break;
                }
                case BETWEEN: {
                    op = FilterOperation.LIST_VALUE_BETWEEN;
                    break;
                }
                case GT: {
                    op = FilterOperation.LIST_VALUE_GT;
                    break;
                }
                case GTEQ: {
                    op = FilterOperation.LIST_VALUE_GTEQ;
                    break;
                }
                case LT: {
                    op = FilterOperation.LIST_VALUE_LT;
                    break;
                }
                case LTEQ: {
                    op = FilterOperation.LIST_VALUE_LTEQ;
                }
            }
        } else if (propertyType.isMap()) {
            ArrayList params = new ArrayList();
            parameters.forEachRemaining(params::add);
            if (params.size() == 1) {
                Object next = params.get(0);
                switch (op) {
                    case EQ: {
                        op = FilterOperation.MAP_VALUE_EQ_BY_KEY;
                        this.setQbValuesForMapByKey(qb, var6_8, next);
                        qb.setDotPath(part.getProperty().toDotPath());
                        break;
                    }
                    case NOTEQ: {
                        op = FilterOperation.MAP_VALUE_NOTEQ_BY_KEY;
                        this.setQbValuesForMapByKey(qb, var6_8, next);
                        qb.setDotPath(part.getProperty().toDotPath());
                        break;
                    }
                    case GT: {
                        op = FilterOperation.MAP_VALUE_GT_BY_KEY;
                        this.setQbValuesForMapByKey(qb, var6_8, next);
                        break;
                    }
                    case GTEQ: {
                        op = FilterOperation.MAP_VALUE_GTEQ_BY_KEY;
                        this.setQbValuesForMapByKey(qb, var6_8, next);
                        break;
                    }
                    case LT: {
                        op = FilterOperation.MAP_VALUE_LT_BY_KEY;
                        this.setQbValuesForMapByKey(qb, var6_8, next);
                        break;
                    }
                    case LTEQ: {
                        op = FilterOperation.MAP_VALUE_LTEQ_BY_KEY;
                        this.setQbValuesForMapByKey(qb, var6_8, next);
                        break;
                    }
                    case STARTS_WITH: {
                        op = FilterOperation.MAP_VALUE_STARTS_WITH_BY_KEY;
                        this.setQbValuesForMapByKey(qb, var6_8, next);
                        break;
                    }
                    case LIKE: {
                        op = FilterOperation.MAP_VALUE_LIKE_BY_KEY;
                        this.setQbValuesForMapByKey(qb, var6_8, next);
                        break;
                    }
                    case ENDS_WITH: {
                        op = FilterOperation.MAP_VALUE_ENDS_WITH_BY_KEY;
                        this.setQbValuesForMapByKey(qb, var6_8, next);
                        break;
                    }
                    case CONTAINING: {
                        if (next instanceof CriteriaDefinition.AerospikeMapCriteria) {
                            CriteriaDefinition.AerospikeMapCriteria onMap = (CriteriaDefinition.AerospikeMapCriteria)((Object)next);
                            switch (onMap) {
                                case KEY: {
                                    op = FilterOperation.MAP_KEYS_CONTAIN;
                                    break;
                                }
                                case VALUE: {
                                    op = FilterOperation.MAP_VALUES_CONTAIN;
                                }
                            }
                            break;
                        }
                        op = FilterOperation.MAP_VALUE_CONTAINING_BY_KEY;
                        this.setQbValuesForMapByKey(qb, var6_8, next);
                        break;
                    }
                    case BETWEEN: {
                        op = FilterOperation.MAP_VALUES_BETWEEN_BY_KEY;
                        qb.setValue2(Value.get((Object)var6_8));
                        qb.setValue1(Value.get(v2));
                        qb.setValue3(Value.get(next));
                    }
                }
                fieldName = part.getProperty().getSegment();
                qb.setDotPath(part.getProperty().toDotPath() + "." + Value.get((Object)var6_8));
            } else {
                if (params.size() != 0) throw new IllegalArgumentException("Expected not more than 2 arguments (propertyType: Map, filterOperation: " + op + ")");
                fieldName = part.getProperty().getSegment();
                qb.setValue2(Value.get((String)property.getFieldName()));
            }
        } else if (part.getProperty().hasNext()) {
            switch (op) {
                case EQ: {
                    op = FilterOperation.MAP_VALUE_EQ_BY_KEY;
                    break;
                }
                case NOTEQ: {
                    op = FilterOperation.MAP_VALUE_NOTEQ_BY_KEY;
                    break;
                }
                case GT: {
                    op = FilterOperation.MAP_VALUE_GT_BY_KEY;
                    break;
                }
                case GTEQ: {
                    op = FilterOperation.MAP_VALUE_GTEQ_BY_KEY;
                    break;
                }
                case LT: {
                    op = FilterOperation.MAP_VALUE_LT_BY_KEY;
                    break;
                }
                case LTEQ: {
                    op = FilterOperation.MAP_VALUE_LTEQ_BY_KEY;
                    break;
                }
                case BETWEEN: {
                    op = FilterOperation.MAP_VALUES_BETWEEN_BY_KEY;
                    qb.setValue3(Value.get(v2));
                    break;
                }
                case STARTS_WITH: {
                    op = FilterOperation.MAP_VALUE_STARTS_WITH_BY_KEY;
                    break;
                }
                case LIKE: {
                    op = FilterOperation.MAP_VALUE_LIKE_BY_KEY;
                    break;
                }
                case ENDS_WITH: {
                    op = FilterOperation.MAP_VALUE_ENDS_WITH_BY_KEY;
                    break;
                }
                case CONTAINING: {
                    op = FilterOperation.MAP_VALUE_CONTAINING_BY_KEY;
                    break;
                }
            }
            fieldName = part.getProperty().getSegment();
            qb.setValue2(Value.get((String)property.getFieldName()));
            qb.setDotPath(part.getProperty().toDotPath());
        } else if (this.isPojo(part)) {
            fieldName = part.getProperty().getSegment();
            qb.setValue2(Value.get((String)property.getFieldName()));
        }
        qb.setField(fieldName).setFilterOperation(op).setIgnoreCase(this.ignoreCaseToBoolean(part)).setConverter(this.converter);
        this.setNotNullQbValues(qb, var6_8, v2);
        return new AerospikeCriteria(qb);
    }

    private void setNotNullQbValues(Qualifier.QualifierBuilder qb, Object v1, Object v2) {
        if (!qb.hasValue1() && v1 != null) {
            qb.setValue1(Value.get((Object)v1));
        }
        if (!qb.hasValue2() && v2 != null) {
            qb.setValue2(Value.get((Object)v2));
        }
    }

    private void setQbValuesForMapByKey(Qualifier.QualifierBuilder qb, Object key, Object value) {
        qb.setValue1(Value.get((Object)value));
        qb.setValue2(Value.get((Object)key));
    }

    private boolean isPojo(Part part) {
        TypeInformation type = TypeInformation.of((Class)part.getProperty().getType());
        return !this.conversions.isSimpleType(part.getProperty().getType()) && !type.isCollectionLike();
    }

    protected AerospikeCriteria and(Part part, AerospikeCriteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        return new AerospikeCriteria(new Qualifier.QualifierBuilder().setFilterOperation(FilterOperation.AND).setQualifiers(base, this.create(part, property, iterator)));
    }

    protected AerospikeCriteria or(AerospikeCriteria base, AerospikeCriteria criteria) {
        return new AerospikeCriteria(new Qualifier.QualifierBuilder().setFilterOperation(FilterOperation.OR).setQualifiers(base, criteria));
    }

    protected Query complete(AerospikeCriteria criteria, Sort sort) {
        Query query;
        Query query2 = query = criteria == null ? null : new Query(criteria).with(sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created query {}", (Object)query);
        }
        return query;
    }

    private boolean ignoreCaseToBoolean(Part part) {
        switch (part.shouldIgnoreCase()) {
            case WHEN_POSSIBLE: {
                return part.getProperty().getType() == String.class;
            }
            case ALWAYS: {
                return true;
            }
        }
        return false;
    }
}

