/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import org.springframework.data.aerospike.core.ReactiveAerospikeOperations;
import org.springframework.data.aerospike.repository.query.BaseAerospikePartTreeQuery;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import reactor.core.publisher.Flux;

public class ReactiveAerospikePartTreeQuery
extends BaseAerospikePartTreeQuery {
    private final ReactiveAerospikeOperations aerospikeOperations;

    public ReactiveAerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evalContextProvider, ReactiveAerospikeOperations aerospikeOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evalContextProvider, queryCreator);
        this.aerospikeOperations = aerospikeOperations;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Query query = this.prepareQuery(parameters, accessor);
        Class<?> targetClass = this.getTargetClass(accessor);
        return this.findByQuery(query, targetClass);
    }

    private Class<?> getTargetClass(ParametersParameterAccessor accessor) {
        if (accessor.getParameters().hasDynamicProjection()) {
            return accessor.findDynamicProjection();
        }
        if (this.queryMethod.getReturnedObjectType() != this.queryMethod.getEntityInformation().getJavaType()) {
            return this.queryMethod.getReturnedObjectType();
        }
        return this.queryMethod.getEntityInformation().getJavaType();
    }

    private Flux<?> findByQuery(Query query, Class<?> targetClass) {
        if (targetClass != this.queryMethod.getEntityInformation().getJavaType()) {
            return this.aerospikeOperations.find(query, this.queryMethod.getEntityInformation().getJavaType(), targetClass);
        }
        return this.aerospikeOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
    }
}

