/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.aerospike.core.ReactiveAerospikeOperations;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreator;
import org.springframework.data.aerospike.repository.query.ReactiveAerospikePartTreeQuery;
import org.springframework.data.keyvalue.repository.support.QuerydslKeyValuePredicateExecutor;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.util.Assert;
import reactor.util.annotation.Nullable;

public class ReactiveAerospikeRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private static final Class<AerospikeQueryCreator> DEFAULT_QUERY_CREATOR = AerospikeQueryCreator.class;
    private final ReactiveAerospikeOperations aerospikeOperations;
    private final MappingContext<? extends AerospikePersistentEntity<?>, AerospikePersistentProperty> context;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;

    public ReactiveAerospikeRepositoryFactory(ReactiveAerospikeOperations aerospikeOperations) {
        this(aerospikeOperations, DEFAULT_QUERY_CREATOR);
    }

    public ReactiveAerospikeRepositoryFactory(ReactiveAerospikeOperations aerospikeOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        Assert.notNull((Object)aerospikeOperations, (String)"AerospikeOperations must not be null!");
        Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
        this.queryCreator = queryCreator;
        this.aerospikeOperations = aerospikeOperations;
        this.context = aerospikeOperations.getMappingContext();
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.context.getRequiredPersistentEntity(domainClass);
        return new PersistentEntityInformation((PersistentEntity)entity);
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        EntityInformation entityInformation = this.getEntityInformation(repositoryInformation.getDomainType());
        return super.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{entityInformation, this.aerospikeOperations});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return ReactiveAerospikeRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface()) ? QuerydslKeyValuePredicateExecutor.class : SimpleKeyValueRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new ReactiveAerospikeQueryLookupStrategy(key, evaluationContextProvider, this.aerospikeOperations, this.queryCreator));
    }

    private static class ReactiveAerospikeQueryLookupStrategy
    implements QueryLookupStrategy {
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;
        private final ReactiveAerospikeOperations aerospikeOperations;
        private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;

        public ReactiveAerospikeQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider, ReactiveAerospikeOperations aerospikeOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
            Assert.notNull((Object)evaluationContextProvider, (String)"QueryMethodEvaluationContextProvider must not be null!");
            Assert.notNull((Object)aerospikeOperations, (String)"AerospikeOperations must not be null!");
            Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
            this.evaluationContextProvider = evaluationContextProvider;
            this.aerospikeOperations = aerospikeOperations;
            this.queryCreator = queryCreator;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            QueryMethod queryMethod = new QueryMethod(method, metadata, projectionFactory);
            return new ReactiveAerospikePartTreeQuery(queryMethod, this.evaluationContextProvider, this.aerospikeOperations, this.queryCreator);
        }
    }
}

