/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.cache;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.data.aerospike.cache.AerospikeCacheConfiguration;
import org.springframework.data.aerospike.convert.AerospikeConverter;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.core.WritePolicyBuilder;

public class AerospikeCache
implements Cache {
    private static final String VALUE = "value";
    private final String name;
    private final IAerospikeClient client;
    private final AerospikeConverter aerospikeConverter;
    private final AerospikeCacheConfiguration cacheConfiguration;
    private final WritePolicy createOnly;
    private final WritePolicy writePolicyForPut;

    public AerospikeCache(String name, IAerospikeClient client, AerospikeConverter aerospikeConverter, AerospikeCacheConfiguration cacheConfiguration) {
        this.name = name;
        this.client = client;
        this.aerospikeConverter = aerospikeConverter;
        this.cacheConfiguration = cacheConfiguration;
        this.createOnly = WritePolicyBuilder.builder(client.getWritePolicyDefault()).recordExistsAction(RecordExistsAction.CREATE_ONLY).expiration(cacheConfiguration.getExpirationInSeconds()).build();
        this.writePolicyForPut = WritePolicyBuilder.builder(client.getWritePolicyDefault()).expiration(cacheConfiguration.getExpirationInSeconds()).build();
    }

    public void clear() {
        this.client.truncate(null, this.cacheConfiguration.getNamespace(), this.cacheConfiguration.getSet(), null);
    }

    public void evict(Object key) {
        this.client.delete(null, this.getKey(key));
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this.client;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value = this.client.get(null, this.getKey(key)).getValue(VALUE);
        if (Objects.isNull(value)) {
            try {
                value = valueLoader.call();
                if (Objects.nonNull(value)) {
                    this.put(key, value);
                }
            }
            catch (Exception e) {
                throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
            }
        }
        return (T)value;
    }

    public <T> T get(Object key, Class<T> type) {
        Key dbKey = this.getKey(key);
        Record aeroRecord = this.client.get(null, dbKey);
        if (aeroRecord != null) {
            AerospikeReadData data = AerospikeReadData.forRead(dbKey, aeroRecord);
            return (T)this.aerospikeConverter.read(type, data);
        }
        return null;
    }

    public Cache.ValueWrapper get(Object key) {
        Object value = this.get(key, Object.class);
        return value != null ? new SimpleValueWrapper(value) : null;
    }

    public void put(Object key, Object value) {
        this.serializeAndPut(this.writePolicyForPut, key, value);
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Cache.ValueWrapper valueWrapper = this.get(key);
        if (valueWrapper != null) {
            return valueWrapper;
        }
        this.serializeAndPut(this.createOnly, key, value);
        return null;
    }

    private Key getKey(Object key) {
        return new Key(this.cacheConfiguration.getNamespace(), this.cacheConfiguration.getSet(), key.toString());
    }

    private void serializeAndPut(WritePolicy writePolicy, Object key, Object value) {
        AerospikeWriteData data = AerospikeWriteData.forWrite(this.getKey((Object)key).namespace);
        data.setKey(new Key(data.getKey().namespace, data.getKey().setName, Value.get((String)key.toString())));
        this.aerospikeConverter.write(value, data);
        this.client.put(writePolicy, this.getKey(key), data.getBinsAsArray());
    }
}

