/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;

public class AerospikeWriteData {
    private Key key;
    private Collection<Bin> bins;
    private int expiration;
    private Integer version;
    private Collection<String> requestedBins;

    @Deprecated
    public AerospikeWriteData(Key key, Collection<Bin> bins, int expiration) {
        this(key, bins, expiration, null);
    }

    public AerospikeWriteData(Key key, Collection<Bin> bins, int expiration, Integer version) {
        this(key, bins, expiration, version, Collections.emptyList());
    }

    public AerospikeWriteData(Key key, Collection<Bin> bins, int expiration, Integer version, Collection<String> requestedBins) {
        this.key = key;
        this.bins = bins;
        this.expiration = expiration;
        this.version = version;
        this.requestedBins = requestedBins;
    }

    public static AerospikeWriteData forWrite(String namespace) {
        return new AerospikeWriteData(new Key(namespace, "", ""), new ArrayList<Bin>(), 0, null);
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public Collection<Bin> getBins() {
        return Collections.unmodifiableCollection(this.bins);
    }

    public void setBins(Collection<Bin> bins) {
        this.bins = bins;
    }

    public Bin[] getBinsAsArray() {
        return this.bins.toArray(new Bin[0]);
    }

    public void addBin(String key, Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            if (value instanceof SortedMap) {
                SortedMap sortedMap = (SortedMap)value;
                this.add(new Bin(key, sortedMap));
            } else {
                this.add(new Bin(key, map));
            }
        } else {
            this.add(new Bin(key, Value.get((Object)value)));
        }
    }

    public void add(Bin bin) {
        this.bins.add(bin);
    }

    public int getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public Optional<Integer> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Collection<String> getRequestedBins() {
        return this.requestedBins;
    }

    public void setRequestedBins(Collection<String> requestedBins) {
        this.requestedBins = requestedBins;
    }
}

