/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.ClassUtils;

public final class DateConverters {
    private static final boolean JODA_TIME_IS_PRESENT = ClassUtils.isPresent((String)"org.joda.time.LocalDate", null);

    private DateConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        converters.add(DateToLongConverter.INSTANCE);
        converters.add(CalendarToLongConverter.INSTANCE);
        converters.add(NumberToDateConverter.INSTANCE);
        converters.add(NumberToCalendarConverter.INSTANCE);
        converters.add(Java8LocalDateTimeToLongConverter.INSTANCE);
        converters.add(Java8LocalDateToLongConverter.INSTANCE);
        converters.add(NumberToJava8LocalDateTimeConverter.INSTANCE);
        converters.add(NumberToJava8LocalDateConverter.INSTANCE);
        if (JODA_TIME_IS_PRESENT) {
            converters.add(LocalDateToLongConverter.INSTANCE);
            converters.add(LocalDateTimeToLongConverter.INSTANCE);
            converters.add(DateTimeToLongConverter.INSTANCE);
            converters.add(DateMidnightToLongConverter.INSTANCE);
            converters.add(NumberToLocalDateConverter.INSTANCE);
            converters.add(NumberToLocalDateTimeConverter.INSTANCE);
            converters.add(NumberToDateTimeConverter.INSTANCE);
            converters.add(NumberToDateMidnightConverter.INSTANCE);
        }
        return converters;
    }

    @WritingConverter
    public static enum DateToLongConverter implements Converter<Date, Long>
    {
        INSTANCE;


        public Long convert(Date source) {
            return source == null ? null : Long.valueOf(source.getTime());
        }
    }

    @WritingConverter
    public static enum CalendarToLongConverter implements Converter<Calendar, Long>
    {
        INSTANCE;


        public Long convert(Calendar source) {
            return source == null ? null : Long.valueOf(source.getTimeInMillis() / 1000L);
        }
    }

    @ReadingConverter
    public static enum NumberToDateConverter implements Converter<Number, Date>
    {
        INSTANCE;


        public Date convert(Number source) {
            if (source == null) {
                return null;
            }
            Date date = new Date();
            date.setTime(source.longValue());
            return date;
        }
    }

    @ReadingConverter
    public static enum NumberToCalendarConverter implements Converter<Number, Calendar>
    {
        INSTANCE;


        public Calendar convert(Number source) {
            if (source == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(source.longValue() * 1000L);
            return calendar;
        }
    }

    @WritingConverter
    public static enum Java8LocalDateTimeToLongConverter implements Converter<java.time.LocalDateTime, Long>
    {
        INSTANCE;


        public Long convert(java.time.LocalDateTime source) {
            return source == null ? null : Long.valueOf(source.atZone(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
    }

    @WritingConverter
    public static enum Java8LocalDateToLongConverter implements Converter<LocalDate, Long>
    {
        INSTANCE;


        public Long convert(LocalDate source) {
            return source == null ? null : Long.valueOf(source.toEpochDay());
        }
    }

    @ReadingConverter
    public static enum NumberToJava8LocalDateTimeConverter implements Converter<Number, java.time.LocalDateTime>
    {
        INSTANCE;


        public java.time.LocalDateTime convert(Number source) {
            if (source == null) {
                return null;
            }
            return java.time.LocalDateTime.ofInstant(Instant.ofEpochMilli(source.longValue()), ZoneOffset.UTC);
        }
    }

    @ReadingConverter
    public static enum NumberToJava8LocalDateConverter implements Converter<Number, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(Number source) {
            if (source == null) {
                return null;
            }
            return LocalDate.ofEpochDay(source.longValue());
        }
    }

    @WritingConverter
    public static enum LocalDateToLongConverter implements Converter<org.joda.time.LocalDate, Long>
    {
        INSTANCE;


        public Long convert(org.joda.time.LocalDate source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @WritingConverter
    public static enum LocalDateTimeToLongConverter implements Converter<LocalDateTime, Long>
    {
        INSTANCE;


        public Long convert(LocalDateTime source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @WritingConverter
    public static enum DateTimeToLongConverter implements Converter<DateTime, Long>
    {
        INSTANCE;


        public Long convert(DateTime source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @WritingConverter
    public static enum DateMidnightToLongConverter implements Converter<DateMidnight, Long>
    {
        INSTANCE;


        public Long convert(DateMidnight source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @ReadingConverter
    public static enum NumberToLocalDateConverter implements Converter<Number, org.joda.time.LocalDate>
    {
        INSTANCE;


        public org.joda.time.LocalDate convert(Number source) {
            return source == null ? null : new org.joda.time.LocalDate(source.longValue());
        }
    }

    @ReadingConverter
    public static enum NumberToLocalDateTimeConverter implements Converter<Number, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(Number source) {
            return source == null ? null : new LocalDateTime(source.longValue());
        }
    }

    @ReadingConverter
    public static enum NumberToDateTimeConverter implements Converter<Number, DateTime>
    {
        INSTANCE;


        public DateTime convert(Number source) {
            return source == null ? null : new DateTime(source.longValue());
        }
    }

    @ReadingConverter
    public static enum NumberToDateMidnightConverter implements Converter<Number, DateMidnight>
    {
        INSTANCE;


        public DateMidnight convert(Number source) {
            return source == null ? null : new DateMidnight(source.longValue());
        }
    }
}

