/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.IndexTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.AerospikeInternalOperations;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.CoreUtils;
import org.springframework.data.aerospike.core.EntitiesKeys;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.query.KeyRecordIterator;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.query.QueryEngine;
import org.springframework.data.aerospike.query.cache.IndexRefresher;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.utility.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;

public class AerospikeTemplate
extends BaseAerospikeTemplate
implements AerospikeOperations,
AerospikeInternalOperations {
    private static final Logger log = LoggerFactory.getLogger(AerospikeTemplate.class);
    private static final Pattern INDEX_EXISTS_REGEX_PATTERN = Pattern.compile("^FAIL:(-?\\d+).*$");
    private final IAerospikeClient client;
    private final QueryEngine queryEngine;
    private final IndexRefresher indexRefresher;

    public AerospikeTemplate(IAerospikeClient client, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, QueryEngine queryEngine, IndexRefresher indexRefresher) {
        super(namespace, converter, mappingContext, exceptionTranslator, client.getWritePolicyDefault());
        this.client = client;
        this.queryEngine = queryEngine;
        this.indexRefresher = indexRefresher;
    }

    @Override
    public IAerospikeClient getAerospikeClient() {
        return this.client;
    }

    @Override
    public <T> void createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType) {
        this.createIndex(entityClass, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public <T> void createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        this.createIndex(entityClass, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public <T> void createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        Assert.notNull((Object)indexType, (String)"Index type must not be null!");
        Assert.notNull((Object)indexCollectionType, (String)"Index collection type must not be null!");
        Assert.notNull((Object)ctx, (String)"Ctx must not be null!");
        try {
            String setName = this.getSetName((Class)entityClass);
            IndexTask task = this.client.createIndex(null, this.namespace, setName, indexName, binName, indexType, indexCollectionType, ctx);
            if (task != null) {
                task.waitTillComplete();
            }
            this.indexRefresher.refreshIndexes();
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> void deleteIndex(Class<T> entityClass, String indexName) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            String setName = this.getSetName((Class)entityClass);
            IndexTask task = this.client.dropIndex(null, this.namespace, setName, indexName);
            if (task != null) {
                task.waitTillComplete();
            }
            this.indexRefresher.refreshIndexes();
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public boolean indexExists(String indexName) {
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            Node[] nodes;
            for (Node node : nodes = this.client.getNodes()) {
                String response = Info.request((Node)node, (String)("sindex-exists:ns=" + this.namespace + ";indexname=" + indexName));
                if (response == null) {
                    throw new AerospikeException("Null node response");
                }
                if (response.equalsIgnoreCase("true")) {
                    return true;
                }
                if (response.equalsIgnoreCase("false")) {
                    return false;
                }
                Matcher matcher = INDEX_EXISTS_REGEX_PATTERN.matcher(response);
                if (matcher.matches()) {
                    int reason;
                    try {
                        reason = Integer.parseInt(matcher.group(1));
                    }
                    catch (NumberFormatException e) {
                        throw new AerospikeException("Unexpected node response, unable to parse ResultCode: " + response);
                    }
                    if (reason == 20) continue;
                    throw new AerospikeException(reason);
                }
                throw new AerospikeException("Unexpected node response: " + response);
            }
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
        return false;
    }

    @Override
    public <T> void save(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationCasAwareSavePolicy(data);
            this.doPersistWithVersionAndHandleCasError(document, data, policy, true);
        } else {
            WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.UPDATE);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
            this.doPersistAndHandleError(data, policy, operations);
        }
    }

    @Override
    public <T> void persist(T document, WritePolicy policy) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)policy, (String)"Policy must not be null!");
        AerospikeWriteData data = this.writeData(document);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
        this.doPersistAndHandleError(data, policy, operations);
    }

    @Override
    public <T> void insertAll(Collection<? extends T> documents) {
        Assert.notNull(documents, (String)"Documents must not be null!");
        documents.stream().filter(Objects::nonNull).forEach(this::insert);
    }

    @Override
    public <T> void insert(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.CREATE_ONLY);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            this.doPersistWithVersionAndHandleError(document, data, policy);
        } else {
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
            this.doPersistAndHandleError(data, policy, operations);
        }
    }

    @Override
    public <T> void update(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationSavePolicy(data, RecordExistsAction.UPDATE_ONLY);
            this.doPersistWithVersionAndHandleCasError(document, data, policy, true);
        } else {
            WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.UPDATE_ONLY);
            Operation[] operations = (Operation[])Stream.concat(Stream.of(Operation.delete()), data.getBins().stream().map(Operation::put)).toArray(Operation[]::new);
            this.doPersistAndHandleError(data, policy, operations);
        }
    }

    @Override
    public <T> void update(T document, Collection<String> fields) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeDataWithSpecificFields(document, fields);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationSavePolicy(data, RecordExistsAction.UPDATE_ONLY);
            this.doPersistWithVersionAndHandleCasError(document, data, policy, false);
        } else {
            WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.UPDATE_ONLY);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
            this.doPersistAndHandleError(data, policy, operations);
        }
    }

    @Override
    public <T> void delete(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        try {
            String set = this.getSetName((Class)entityClass);
            this.client.truncate(null, this.getNamespace(), set, null);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> boolean delete(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
            Key key = this.getKey(id, entity);
            return this.client.delete(this.ignoreGenerationDeletePolicy(), key);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> boolean delete(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document);
            return this.client.delete(this.ignoreGenerationDeletePolicy(), data.getKey());
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> boolean exists(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
            Key key = this.getKey(id, entity);
            Record aeroRecord = this.client.operate(null, key, new Operation[]{Operation.getHeader()});
            return aeroRecord != null;
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> Stream<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findAllUsingQuery(entityClass, null, null, new Qualifier[0]);
    }

    @Override
    public <T, S> Stream<S> findAll(Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAllUsingQuery(entityClass, targetClass, null, new Qualifier[0]);
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return (T)this.findByIdInternal(id, entityClass, null, new Qualifier[0]);
    }

    @Override
    public <T, S> S findById(Object id, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return (S)this.findByIdInternal(id, entityClass, targetClass, new Qualifier[0]);
    }

    @Override
    public <T, S> Object findByIdInternal(Object id, Class<T> entityClass, Class<S> targetClass, Qualifier ... qualifiers) {
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
            Key key = this.getKey(id, entity);
            if (targetClass != null && targetClass != entityClass) {
                return this.getRecordMapToTargetClass(entity, key, targetClass, qualifiers);
            }
            return this.getRecordMapToEntityClass(entity, key, entityClass, qualifiers);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T, S> List<?> findByIdsInternal(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, Qualifier ... qualifiers) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Class<Object> target;
            Record[] aeroRecords;
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
            Key[] keys = (Key[])ids.stream().map(id -> this.getKey(id, entity)).toArray(Key[]::new);
            BatchPolicy policy = null;
            if (qualifiers != null && qualifiers.length > 0) {
                policy = new BatchPolicy(this.getAerospikeClient().getBatchPolicyDefault());
                policy.filterExp = this.getQueryEngine().getFilterExpressionsBuilder().build(qualifiers);
            }
            if (targetClass != null && targetClass != entityClass) {
                String[] binNames = this.getBinNamesFromTargetClass(targetClass);
                aeroRecords = this.getAerospikeClient().get(policy, keys, binNames);
                target = targetClass;
            } else {
                aeroRecords = this.getAerospikeClient().get(policy, keys);
                target = entityClass;
            }
            return IntStream.range(0, keys.length).filter(index -> aeroRecords[index] != null).mapToObj(index -> this.mapToEntity(keys[index], target, aeroRecords[index])).collect(Collectors.toList());
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    <S> Object getRecordMapToTargetClass(AerospikePersistentEntity<?> entity, Key key, Class<S> targetClass, Qualifier ... qualifiers) {
        Record aeroRecord;
        String[] binNames = this.getBinNamesFromTargetClass(targetClass);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for expiration property");
            aeroRecord = this.getAndTouch(key, entity.getExpiration(), binNames, qualifiers);
        } else {
            Policy policy = null;
            if (qualifiers != null && qualifiers.length > 0) {
                policy = new Policy(this.getAerospikeClient().getReadPolicyDefault());
                policy.filterExp = this.getQueryEngine().getFilterExpressionsBuilder().build(qualifiers);
            }
            aeroRecord = this.getAerospikeClient().get(policy, key, binNames);
        }
        return this.mapToEntity(key, targetClass, aeroRecord);
    }

    <T> Object getRecordMapToEntityClass(AerospikePersistentEntity<?> entity, Key key, Class<T> entityClass, Qualifier ... qualifiers) {
        Record aeroRecord;
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for expiration property");
            aeroRecord = this.getAndTouch(key, entity.getExpiration(), null, new Qualifier[0]);
        } else {
            Policy policy = null;
            if (qualifiers != null && qualifiers.length > 0) {
                policy = new Policy(this.getAerospikeClient().getReadPolicyDefault());
                policy.filterExp = this.getQueryEngine().getFilterExpressionsBuilder().build(qualifiers);
            }
            aeroRecord = this.getAerospikeClient().get(policy, key);
        }
        return this.mapToEntity(key, entityClass, aeroRecord);
    }

    Record getAndTouch(Key key, int expiration, String[] binNames, Qualifier ... qualifiers) {
        WritePolicyBuilder writePolicyBuilder = WritePolicyBuilder.builder(this.client.getWritePolicyDefault()).expiration(expiration);
        if (qualifiers != null && qualifiers.length > 0) {
            writePolicyBuilder.filterExp(this.getQueryEngine().getFilterExpressionsBuilder().build(qualifiers));
        }
        WritePolicy writePolicy = writePolicyBuilder.build();
        try {
            if (binNames == null || binNames.length == 0) {
                return this.client.operate(writePolicy, key, new Operation[]{Operation.touch(), Operation.get()});
            }
            Operation[] operations = new Operation[binNames.length + 1];
            operations[0] = Operation.touch();
            for (int i = 1; i < operations.length; ++i) {
                operations[i] = Operation.get((String)binNames[i - 1]);
            }
            return this.client.operate(writePolicy, key, operations);
        }
        catch (AerospikeException aerospikeException) {
            if (aerospikeException.getResultCode() == 2) {
                return null;
            }
            throw aerospikeException;
        }
    }

    String[] getBinNamesFromTargetClass(Class<?> targetClass) {
        AerospikePersistentEntity targetEntity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(targetClass);
        ArrayList binNamesList = new ArrayList();
        targetEntity.doWithProperties(property -> binNamesList.add(property.getFieldName()));
        return binNamesList.toArray(new String[0]);
    }

    @Override
    public <T> List<T> findByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findByIdsInternal(IterableConverter.toList(ids), entityClass, null, new Qualifier[0]);
    }

    @Override
    public <T, S> List<S> findByIds(Iterable<?> ids, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findByIdsInternal(IterableConverter.toList(ids), entityClass, targetClass, new Qualifier[0]);
    }

    @Override
    public GroupedEntities findByIds(GroupedKeys groupedKeys) {
        Assert.notNull((Object)groupedKeys, (String)"Grouped keys must not be null!");
        if (groupedKeys.getEntitiesKeys().isEmpty()) {
            return GroupedEntities.builder().build();
        }
        return this.findEntitiesByIdsInternal(groupedKeys);
    }

    private GroupedEntities findEntitiesByIdsInternal(GroupedKeys groupedKeys) {
        EntitiesKeys entitiesKeys = EntitiesKeys.of(this.toEntitiesKeyMap(groupedKeys));
        Record[] aeroRecords = this.client.get(null, entitiesKeys.getKeys());
        return this.toGroupedEntities(entitiesKeys, aeroRecords);
    }

    @Override
    public <T> ResultSet aggregate(Filter filter, Class<T> entityClass, String module, String function, List<Value> arguments) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Statement statement = new Statement();
        if (filter != null) {
            statement.setFilter(filter);
        }
        statement.setSetName(entity.getSetName());
        statement.setNamespace(this.namespace);
        ResultSet resultSet = arguments != null && !arguments.isEmpty() ? this.client.queryAggregate(null, statement, module, function, arguments.toArray(new Value[0])) : this.client.queryAggregate(null, statement);
        return resultSet;
    }

    @Override
    public <T> Stream<T> findAll(Sort sort, long offset, long limit, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, null, sort, offset, limit, null, null);
    }

    @Override
    public <T, S> Stream<S> findAll(Sort sort, long offset, long limit, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, targetClass, sort, offset, limit, null, null);
    }

    public <T> boolean exists(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.find(query, entityClass).findAny().isPresent();
    }

    @Override
    public <T> T execute(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null!");
        try {
            return supplier.get();
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> long count(Query query, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Stream<KeyRecord> results = this.findAllRecordsUsingQuery(entityClass, query);
        return results.count();
    }

    @Override
    public <T> Stream<T> find(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, null, query);
    }

    @Override
    public <T, S> Stream<S> find(Query query, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(targetClass, (String)"Target lass must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, targetClass, query);
    }

    @Override
    public <T> Stream<T> findInRange(long offset, long limit, Sort sort, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class for count must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, null, sort, offset, limit, null, null);
    }

    @Override
    public <T, S> Stream<S> findInRange(long offset, long limit, Sort sort, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class for count must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, targetClass, sort, offset, limit, null, null);
    }

    @Override
    public <T> long count(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Type for count must not be null!");
        String setName = this.getSetName((Class)entityClass);
        return this.count(setName);
    }

    @Override
    public long count(String setName) {
        Assert.notNull((Object)setName, (String)"Set for count must not be null!");
        try {
            Node[] nodes = this.client.getNodes();
            int replicationFactor = Utils.getReplicationFactor(nodes, this.namespace);
            long totalObjects = Arrays.stream(nodes).mapToLong(node -> Utils.getObjectsCount(node, this.namespace, setName)).sum();
            return nodes.length > 1 ? totalObjects / (long)replicationFactor : totalObjects;
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T prepend(T document, String fieldName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document);
            Record aeroRecord = this.client.operate(null, data.getKey(), new Operation[]{Operation.prepend((Bin)new Bin(fieldName, value)), Operation.get((String)fieldName)});
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T prepend(T document, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document);
            Operation[] ops = CoreUtils.operations(values, Operation.Type.PREPEND, Operation.get());
            Record aeroRecord = this.client.operate(null, data.getKey(), ops);
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T append(T document, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document);
            Operation[] ops = CoreUtils.operations(values, Operation.Type.APPEND, Operation.get());
            Record aeroRecord = this.client.operate(null, data.getKey(), ops);
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T append(T document, String binName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document);
            Record aeroRecord = this.client.operate(null, data.getKey(), new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)});
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T add(T document, Map<String, Long> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document);
            Operation[] ops = CoreUtils.operations(values, Operation.Type.ADD, Operation.get());
            WritePolicy writePolicy = WritePolicyBuilder.builder(this.client.getWritePolicyDefault()).expiration(data.getExpiration()).build();
            Record aeroRecord = this.client.operate(writePolicy, data.getKey(), ops);
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T add(T document, String binName, long value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document);
            WritePolicy writePolicy = WritePolicyBuilder.builder(this.client.getWritePolicyDefault()).expiration(data.getExpiration()).build();
            Record aeroRecord = this.client.operate(writePolicy, data.getKey(), new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get()});
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    private void doPersistAndHandleError(AerospikeWriteData data, WritePolicy policy, Operation[] operations) {
        try {
            this.client.operate(policy, data.getKey(), operations);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    private <T> void doPersistWithVersionAndHandleCasError(T document, AerospikeWriteData data, WritePolicy policy, boolean firstlyDeleteBins) {
        try {
            Record newAeroRecord = this.putAndGetHeader(data, policy, firstlyDeleteBins);
            this.updateVersion(document, newAeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateCasError(e);
        }
    }

    private <T> void doPersistWithVersionAndHandleError(T document, AerospikeWriteData data, WritePolicy policy) {
        try {
            Record newAeroRecord = this.putAndGetHeader(data, policy, false);
            this.updateVersion(document, newAeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    private Record putAndGetHeader(AerospikeWriteData data, WritePolicy policy, boolean firstlyDeleteBins) {
        Key key = data.getKey();
        Bin[] bins = data.getBinsAsArray();
        if (bins.length == 0) {
            throw new AerospikeException("Cannot put and get header on a document with no bins and \"@_class\" bin disabled.");
        }
        Operation[] operations = firstlyDeleteBins ? CoreUtils.operations(bins, Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}), Operation.array((Operation[])new Operation[]{Operation.getHeader()})) : CoreUtils.operations(bins, Operation::put, null, Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
        return this.client.operate(policy, key, operations);
    }

    <T, S> Stream<?> findAllUsingQueryWithPostProcessing(Class<T> entityClass, Class<S> targetClass, Query query) {
        CoreUtils.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        Stream<?> results = this.findAllUsingQueryWithDistinctPredicate(entityClass, targetClass, CoreUtils.getDistinctPredicate(query), qualifier);
        return this.applyPostProcessingOnResults(results, query);
    }

    <T, S> Stream<?> findAllUsingQueryWithPostProcessing(Class<T> entityClass, Class<S> targetClass, Sort sort, long offset, long limit, Filter filter, Qualifier ... qualifiers) {
        CoreUtils.verifyUnsortedWithOffset(sort, offset);
        Stream<?> results = this.findAllUsingQuery(entityClass, targetClass, filter, qualifiers);
        return this.applyPostProcessingOnResults(results, sort, offset, limit);
    }

    <T, S> Object mapToEntity(KeyRecord keyRecord, Class<T> entityClass, Class<S> targetClass) {
        if (targetClass != null) {
            return this.mapToEntity(keyRecord.key, targetClass, keyRecord.record);
        }
        return this.mapToEntity(keyRecord.key, entityClass, keyRecord.record);
    }

    <T, S> Stream<?> findAllUsingQuery(Class<T> entityClass, Class<S> targetClass, Filter filter, Qualifier ... qualifiers) {
        return this.findAllRecordsUsingQuery(entityClass, targetClass, filter, qualifiers).map(keyRecord -> this.mapToEntity((KeyRecord)keyRecord, entityClass, targetClass));
    }

    <T, S> Stream<?> findAllUsingQueryWithDistinctPredicate(Class<T> entityClass, Class<S> targetClass, Predicate<KeyRecord> distinctPredicate, Qualifier ... qualifiers) {
        return this.findAllRecordsUsingQuery(entityClass, targetClass, null, qualifiers).filter(distinctPredicate).map(keyRecord -> this.mapToEntity((KeyRecord)keyRecord, entityClass, targetClass));
    }

    private <T> Stream<T> applyPostProcessingOnResults(Stream<T> results, Query query) {
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator comparator = this.getComparator(query);
            results = results.sorted(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.limit(query.getRows());
        }
        return results;
    }

    private <T> Stream<T> applyPostProcessingOnResults(Stream<T> results, Sort sort, long offset, long limit) {
        if (sort != null && sort.isSorted()) {
            Comparator comparator = this.getComparator(sort);
            results = results.sorted(comparator);
        }
        if (offset > 0L) {
            results = results.skip(offset);
        }
        if (limit > 0L) {
            results = results.limit(limit);
        }
        return results;
    }

    <T> Stream<KeyRecord> findAllRecordsUsingQuery(Class<T> entityClass, Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        return this.findAllRecordsUsingQuery(entityClass, null, null, qualifier);
    }

    <T, S> Stream<KeyRecord> findAllRecordsUsingQuery(Class<T> entityClass, Class<S> targetClass, Filter filter, Qualifier ... qualifiers) {
        KeyRecordIterator recIterator;
        String setName = this.getSetName((Class)entityClass);
        if (targetClass != null) {
            String[] binNames = this.getBinNamesFromTargetClass(targetClass);
            recIterator = this.queryEngine.select(this.namespace, setName, binNames, filter, qualifiers);
        } else {
            recIterator = this.queryEngine.select(this.namespace, setName, filter, qualifiers);
        }
        return (Stream)StreamUtils.createStreamFromIterator((Iterator)recIterator).onClose(() -> {
            try {
                recIterator.close();
            }
            catch (Exception e) {
                log.error("Caught exception while closing query", (Throwable)e);
            }
        });
    }

    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }
}

