/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.CoreUtils;
import org.springframework.data.aerospike.core.EntitiesKeys;
import org.springframework.data.aerospike.core.ReactiveAerospikeInternalOperations;
import org.springframework.data.aerospike.core.ReactiveAerospikeOperations;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.query.ReactorQueryEngine;
import org.springframework.data.aerospike.query.cache.ReactorIndexRefresher;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.utility.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAerospikeTemplate
extends BaseAerospikeTemplate
implements ReactiveAerospikeOperations,
ReactiveAerospikeInternalOperations {
    private static final Logger log = LoggerFactory.getLogger(ReactiveAerospikeTemplate.class);
    private static final Pattern INDEX_EXISTS_REGEX_PATTERN = Pattern.compile("^FAIL:(-?\\d+).*$");
    private final IAerospikeReactorClient reactorClient;
    private final ReactorQueryEngine queryEngine;
    private final ReactorIndexRefresher reactorIndexRefresher;

    public ReactiveAerospikeTemplate(IAerospikeReactorClient reactorClient, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, ReactorQueryEngine queryEngine, ReactorIndexRefresher reactorIndexRefresher) {
        super(namespace, converter, mappingContext, exceptionTranslator, reactorClient.getWritePolicyDefault());
        Assert.notNull((Object)reactorClient, (String)"Aerospike reactor client must not be null!");
        this.reactorClient = reactorClient;
        this.queryEngine = queryEngine;
        this.reactorIndexRefresher = reactorIndexRefresher;
    }

    @Override
    public <T> Mono<T> save(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationCasAwareSavePolicy(data);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
            return this.doPersistWithVersionAndHandleCasError(document, data, policy, operations);
        }
        WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.UPDATE);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
        return this.doPersistAndHandleError(document, data, policy, operations);
    }

    @Override
    public <T> Flux<T> insertAll(Collection<? extends T> documents) {
        return Flux.fromIterable(documents).flatMap(this::insert);
    }

    @Override
    public <T> Mono<T> insert(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.CREATE_ONLY);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, null, Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return this.doPersistWithVersionAndHandleError(document, data, policy, operations);
        }
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
        return this.doPersistAndHandleError(document, data, policy, operations);
    }

    @Override
    public <T> Mono<T> update(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationSavePolicy(data, RecordExistsAction.UPDATE_ONLY);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}), Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return this.doPersistWithVersionAndHandleCasError(document, data, policy, operations);
        }
        WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.UPDATE_ONLY);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
        return this.doPersistAndHandleError(document, data, policy, operations);
    }

    @Override
    public <T> Mono<T> update(T document, Collection<String> fields) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeDataWithSpecificFields(document, fields);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationSavePolicy(data, RecordExistsAction.UPDATE_ONLY);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, null, Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return this.doPersistWithVersionAndHandleCasError(document, data, policy, operations);
        }
        WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.UPDATE_ONLY);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
        return this.doPersistAndHandleError(document, data, policy, operations);
    }

    @Override
    public <T> Flux<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findAllUsingQuery(entityClass, null, null, null);
    }

    @Override
    public <T, S> Flux<S> findAll(Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAllUsingQuery(entityClass, targetClass, null, null);
    }

    @Override
    public <T> Flux<T> findAll(Sort sort, long offset, long limit, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, null, sort, offset, limit, null, null);
    }

    @Override
    public <T, S> Flux<S> findAll(Sort sort, long offset, long limit, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, targetClass, sort, offset, limit, null, null);
    }

    @Override
    public <T> Mono<T> add(T document, Map<String, Long> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(document);
        Operation[] operations = new Operation[values.size() + 1];
        int x = 0;
        for (Map.Entry<String, Long> entry : values.entrySet()) {
            operations[x] = new Operation(Operation.Type.ADD, entry.getKey(), Value.get((Object)entry.getValue()));
            ++x;
        }
        operations[x] = Operation.get();
        WritePolicy writePolicy = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(data.getExpiration()).build();
        return this.executeOperationsOnValue(document, data, operations, writePolicy);
    }

    @Override
    public <T> Mono<T> add(T document, String binName, long value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        AerospikeWriteData data = this.writeData(document);
        WritePolicy writePolicy = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(data.getExpiration()).build();
        Operation[] operations = new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return this.executeOperationsOnValue(document, data, operations, writePolicy);
    }

    @Override
    public <T> Mono<T> append(T document, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(document);
        Operation[] operations = CoreUtils.operations(values, Operation.Type.APPEND, Operation.get());
        return this.executeOperationsOnValue(document, data, operations, null);
    }

    @Override
    public <T> Mono<T> append(T document, String binName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        Operation[] operations = new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return this.executeOperationsOnValue(document, data, operations, null);
    }

    @Override
    public <T> Mono<T> prepend(T document, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(document);
        Operation[] operations = CoreUtils.operations(values, Operation.Type.PREPEND, Operation.get());
        return this.executeOperationsOnValue(document, data, operations, null);
    }

    @Override
    public <T> Mono<T> prepend(T document, String binName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        Operation[] operations = new Operation[]{Operation.prepend((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return this.executeOperationsOnValue(document, data, operations, null);
    }

    private <T> Mono<T> executeOperationsOnValue(T document, AerospikeWriteData data, Operation[] operations, WritePolicy writePolicy) {
        return this.reactorClient.operate(writePolicy, data.getKey(), operations).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, this.getEntityClass(document), keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, entity);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return this.getAndTouch(key, entity.getExpiration(), null, new Qualifier[0]).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, entityClass, keyRecord.record)).onErrorResume(th -> th instanceof AerospikeException && ((AerospikeException)th).getResultCode() == 2, th -> Mono.empty()).onErrorMap(this::translateError);
        }
        return this.reactorClient.get(key).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, entityClass, keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T, S> Mono<S> findById(Object id, Class<T> entityClass, Class<S> targetClass) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, entity);
        String[] binNames = this.getBinNamesFromTargetClass(targetClass);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return this.getAndTouch(key, entity.getExpiration(), binNames, new Qualifier[0]).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, targetClass, keyRecord.record)).onErrorResume(th -> th instanceof AerospikeException && ((AerospikeException)th).getResultCode() == 2, th -> Mono.empty()).onErrorMap(this::translateError);
        }
        return this.reactorClient.get(null, key, binNames).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, targetClass, keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T, S> Mono<?> findByIdInternal(Object id, Class<T> entityClass, Class<S> targetClass, Qualifier ... qualifiers) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, entity);
        String[] binNames = this.getBinNamesFromTargetClass(targetClass);
        Class<Object> target = targetClass != null && targetClass != entityClass ? targetClass : entityClass;
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return this.getAndTouch(key, entity.getExpiration(), binNames, qualifiers).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, target, keyRecord.record)).onErrorResume(th -> th instanceof AerospikeException && ((AerospikeException)th).getResultCode() == 2, th -> Mono.empty()).onErrorMap(this::translateError);
        }
        Policy policy = null;
        if (qualifiers != null && qualifiers.length > 0) {
            policy = new Policy(this.reactorClient.getReadPolicyDefault());
            policy.filterExp = this.queryEngine.getFilterExpressionsBuilder().build(qualifiers);
        }
        return this.reactorClient.get(policy, key, binNames).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, target, keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T> Flux<T> findByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        return Flux.fromIterable(ids).map(id -> this.getKey(id, entity)).flatMap(arg_0 -> ((IAerospikeReactorClient)this.reactorClient).get(arg_0)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, entityClass, keyRecord.record));
    }

    @Override
    public <T, S> Flux<S> findByIds(Iterable<?> ids, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        String[] binNames = this.getBinNamesFromTargetClass(targetClass);
        return Flux.fromIterable(ids).map(id -> this.getKey(id, entity)).flatMap(key -> this.reactorClient.get(null, key, binNames)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, targetClass, keyRecord.record));
    }

    @Override
    public <T, S> Flux<?> findByIdsInternal(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, Qualifier ... qualifiers) {
        BatchPolicy policy;
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        if (ids.isEmpty()) {
            return Flux.empty();
        }
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        if (qualifiers != null && qualifiers.length > 0) {
            policy = new BatchPolicy(this.reactorClient.getBatchPolicyDefault());
            policy.filterExp = this.queryEngine.getFilterExpressionsBuilder().build(qualifiers);
        } else {
            policy = null;
        }
        Class<Object> target = targetClass != null && targetClass != entityClass ? targetClass : entityClass;
        return Flux.fromIterable(ids).map(id -> this.getKey(id, entity)).flatMap(key -> this.getFromClient(policy, (Key)key, entityClass, targetClass)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, target, keyRecord.record));
    }

    private Mono<KeyRecord> getFromClient(BatchPolicy finalPolicy, Key key, Class<?> entityClass, Class<?> targetClass) {
        if (targetClass != null && targetClass != entityClass) {
            String[] binNames = this.getBinNamesFromTargetClass(targetClass);
            return this.reactorClient.get((Policy)finalPolicy, key, binNames);
        }
        return this.reactorClient.get((Policy)finalPolicy, key);
    }

    @Override
    public Mono<GroupedEntities> findByIds(GroupedKeys groupedKeys) {
        Assert.notNull((Object)groupedKeys, (String)"Grouped keys must not be null!");
        if (groupedKeys.getEntitiesKeys().isEmpty()) {
            return Mono.just((Object)GroupedEntities.builder().build());
        }
        return this.findEntitiesByIdsInternal(groupedKeys);
    }

    private Mono<GroupedEntities> findEntitiesByIdsInternal(GroupedKeys groupedKeys) {
        EntitiesKeys entitiesKeys = EntitiesKeys.of(this.toEntitiesKeyMap(groupedKeys));
        return this.reactorClient.get(null, entitiesKeys.getKeys()).map(item -> this.toGroupedEntities(entitiesKeys, item.records)).onErrorMap(this::translateError);
    }

    @Override
    public <T> Flux<T> find(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, null, query);
    }

    @Override
    public <T, S> Flux<S> find(Query query, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, targetClass, query);
    }

    @Override
    public <T> Flux<T> findInRange(long offset, long limit, Sort sort, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class for count must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, null, sort, offset, limit, null, null);
    }

    @Override
    public <T, S> Flux<S> findInRange(long offset, long limit, Sort sort, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class for count must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAllUsingQueryWithPostProcessing(entityClass, targetClass, sort, offset, limit, null, null);
    }

    @Override
    public <T> Mono<Long> count(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findAllRecordsUsingQuery(entityClass, query).count();
    }

    @Override
    public Mono<Long> count(String setName) {
        Assert.notNull((Object)setName, (String)"Set for count must not be null!");
        try {
            return Mono.fromCallable(() -> this.countSet(setName));
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> Mono<Long> count(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        String setName = this.getSetName((Class)entityClass);
        return this.count(setName);
    }

    private long countSet(String setName) {
        Node[] nodes = this.reactorClient.getAerospikeClient().getNodes();
        int replicationFactor = Utils.getReplicationFactor(nodes, this.namespace);
        long totalObjects = Arrays.stream(nodes).mapToLong(node -> Utils.getObjectsCount(node, this.namespace, setName)).sum();
        return nodes.length > 1 ? totalObjects / (long)replicationFactor : totalObjects;
    }

    @Override
    public <T> Mono<T> execute(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null!");
        return Mono.fromSupplier(supplier).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Boolean> exists(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, entity);
        return this.reactorClient.exists(key).map(Objects::nonNull).defaultIfEmpty((Object)false).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Void> delete(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        try {
            String set = this.getSetName((Class)entityClass);
            return Mono.fromRunnable(() -> this.reactorClient.getAerospikeClient().truncate(null, this.namespace, set, null));
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> Mono<Boolean> delete(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        return this.reactorClient.delete(this.ignoreGenerationDeletePolicy(), this.getKey(id, entity)).map(k -> true).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Boolean> delete(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        return this.reactorClient.delete(this.ignoreGenerationDeletePolicy(), data.getKey()).map(key -> true).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType) {
        return this.createIndex(entityClass, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        return this.createIndex(entityClass, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        Assert.notNull((Object)indexType, (String)"Index type must not be null!");
        Assert.notNull((Object)indexCollectionType, (String)"Index collection type must not be null!");
        Assert.notNull((Object)ctx, (String)"Ctx must not be null!");
        String setName = this.getSetName((Class)entityClass);
        return this.reactorClient.createIndex(null, this.namespace, setName, indexName, binName, indexType, indexCollectionType, ctx).then(this.reactorIndexRefresher.refreshIndexes()).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Void> deleteIndex(Class<T> entityClass, String indexName) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        String setName = this.getSetName((Class)entityClass);
        return this.reactorClient.dropIndex(null, this.namespace, setName, indexName).then(this.reactorIndexRefresher.refreshIndexes()).onErrorMap(this::translateError);
    }

    @Override
    public Mono<Boolean> indexExists(String indexName) {
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            Node[] nodes;
            for (Node node : nodes = this.reactorClient.getAerospikeClient().getNodes()) {
                String response = Info.request((Node)node, (String)("sindex-exists:ns=" + this.namespace + ";indexname=" + indexName));
                if (response == null) {
                    throw new AerospikeException("Null node response");
                }
                if (response.equalsIgnoreCase("true")) {
                    return Mono.just((Object)true);
                }
                if (response.equalsIgnoreCase("false")) {
                    return Mono.just((Object)false);
                }
                Matcher matcher = INDEX_EXISTS_REGEX_PATTERN.matcher(response);
                if (matcher.matches()) {
                    int reason;
                    try {
                        reason = Integer.parseInt(matcher.group(1));
                    }
                    catch (NumberFormatException e) {
                        throw new AerospikeException("Unexpected node response, unable to parse ResultCode: " + response);
                    }
                    if (reason == 20) continue;
                    throw new AerospikeException(reason);
                }
                throw new AerospikeException("Unexpected node response: " + response);
            }
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
        return Mono.just((Object)false);
    }

    @Override
    public IAerospikeReactorClient getAerospikeReactorClient() {
        return this.reactorClient;
    }

    private <T> Mono<T> doPersistAndHandleError(T document, AerospikeWriteData data, WritePolicy policy, Operation[] operations) {
        return this.reactorClient.operate(policy, data.getKey(), operations).map(docKey -> document).onErrorMap(this::translateError);
    }

    private <T> Mono<T> doPersistWithVersionAndHandleCasError(T document, AerospikeWriteData data, WritePolicy policy, Operation[] operations) {
        return this.putAndGetHeader(data, policy, operations).map(newRecord -> this.updateVersion(document, (Record)newRecord)).onErrorMap(AerospikeException.class, this::translateCasError);
    }

    private <T> Mono<T> doPersistWithVersionAndHandleError(T document, AerospikeWriteData data, WritePolicy policy, Operation[] operations) {
        return this.putAndGetHeader(data, policy, operations).map(newRecord -> this.updateVersion(document, (Record)newRecord)).onErrorMap(AerospikeException.class, this::translateError);
    }

    private Mono<Record> putAndGetHeader(AerospikeWriteData data, WritePolicy policy, Operation[] operations) {
        return this.reactorClient.operate(policy, data.getKey(), operations).map(keyRecord -> keyRecord.record);
    }

    private Mono<KeyRecord> getAndTouch(Key key, int expiration, String[] binNames, Qualifier ... qualifiers) {
        WritePolicyBuilder writePolicyBuilder = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(expiration);
        if (qualifiers != null && qualifiers.length > 0) {
            writePolicyBuilder.filterExp(this.queryEngine.getFilterExpressionsBuilder().build(qualifiers));
        }
        WritePolicy writePolicy = writePolicyBuilder.build();
        if (binNames == null || binNames.length == 0) {
            return this.reactorClient.operate(writePolicy, key, new Operation[]{Operation.touch(), Operation.get()});
        }
        Operation[] operations = new Operation[binNames.length + 1];
        operations[0] = Operation.touch();
        for (int i = 1; i < operations.length; ++i) {
            operations[i] = Operation.get((String)binNames[i - 1]);
        }
        return this.reactorClient.operate(writePolicy, key, operations);
    }

    private String[] getBinNamesFromTargetClass(Class<?> targetClass) {
        AerospikePersistentEntity targetEntity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(targetClass);
        ArrayList binNamesList = new ArrayList();
        targetEntity.doWithProperties(property -> binNamesList.add(property.getFieldName()));
        return binNamesList.toArray(new String[0]);
    }

    private Throwable translateError(Throwable e) {
        if (e instanceof AerospikeException) {
            return this.translateError((AerospikeException)e);
        }
        return e;
    }

    <T, S> Flux<?> findAllUsingQueryWithPostProcessing(Class<T> entityClass, Class<S> targetClass, Query query) {
        this.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        Flux<?> results = this.findAllUsingQueryWithDistinctPredicate(entityClass, targetClass, CoreUtils.getDistinctPredicate(query), qualifier);
        results = this.applyPostProcessingOnResults(results, query);
        return results;
    }

    <T, S> Flux<?> findAllUsingQueryWithPostProcessing(Class<T> entityClass, Class<S> targetClass, Sort sort, long offset, long limit, Filter filter, Qualifier ... qualifiers) {
        this.verifyUnsortedWithOffset(sort, offset);
        Flux<?> results = this.findAllUsingQuery(entityClass, targetClass, filter, qualifiers);
        results = this.applyPostProcessingOnResults(results, sort, offset, limit);
        return results;
    }

    private void verifyUnsortedWithOffset(Sort sort, long offset) {
        if ((sort == null || sort.isUnsorted()) && offset > 0L) {
            throw new IllegalArgumentException("Unsorted query must not have offset value. For retrieving paged results use sorted query.");
        }
    }

    private <T> Flux<T> applyPostProcessingOnResults(Flux<T> results, Query query) {
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator comparator = this.getComparator(query);
            results = results.sort(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.take((long)query.getRows());
        }
        return results;
    }

    private <T> Flux<T> applyPostProcessingOnResults(Flux<T> results, Sort sort, long offset, long limit) {
        if (sort != null && sort.isSorted()) {
            Comparator comparator = this.getComparator(sort);
            results = results.sort(comparator);
        }
        if (offset > 0L) {
            results = results.skip(offset);
        }
        if (limit > 0L) {
            results = results.take(limit);
        }
        return results;
    }

    <T, S> Object mapToEntity(KeyRecord keyRecord, Class<T> entityClass, Class<S> targetClass) {
        if (targetClass != null) {
            return this.mapToEntity(keyRecord.key, targetClass, keyRecord.record);
        }
        return this.mapToEntity(keyRecord.key, entityClass, keyRecord.record);
    }

    <T, S> Flux<?> findAllUsingQuery(Class<T> entityClass, Class<S> targetClass, Filter filter, Qualifier ... qualifiers) {
        return this.findAllRecordsUsingQuery(entityClass, targetClass, filter, qualifiers).map(keyRecord -> this.mapToEntity((KeyRecord)keyRecord, entityClass, targetClass));
    }

    <T, S> Flux<?> findAllUsingQueryWithDistinctPredicate(Class<T> entityClass, Class<S> targetClass, Predicate<KeyRecord> distinctPredicate, Qualifier ... qualifiers) {
        return this.findAllRecordsUsingQuery(entityClass, targetClass, null, qualifiers).filter(distinctPredicate).map(keyRecord -> this.mapToEntity((KeyRecord)keyRecord, entityClass, targetClass));
    }

    <T> Flux<KeyRecord> findAllRecordsUsingQuery(Class<T> entityClass, Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        return this.findAllRecordsUsingQuery(entityClass, null, null, qualifier);
    }

    <T, S> Flux<KeyRecord> findAllRecordsUsingQuery(Class<T> entityClass, Class<S> targetClass, Filter filter, Qualifier ... qualifiers) {
        String setName = this.getSetName((Class)entityClass);
        if (targetClass != null) {
            String[] binNames = this.getBinNamesFromTargetClass(targetClass);
            return this.queryEngine.select(this.namespace, setName, binNames, filter, qualifiers);
        }
        return this.queryEngine.select(this.namespace, setName, filter, qualifiers);
    }
}

