/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import com.aerospike.client.cdt.CTX;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import java.util.Arrays;
import lombok.NonNull;

public final class AerospikeIndexDefinition {
    @NonNull
    private final String name;
    @NonNull
    private final String bin;
    @NonNull
    private final IndexType type;
    @NonNull
    private final IndexCollectionType collectionType;
    @NonNull
    private final Class<?> entityClass;
    private final CTX[] ctx;

    AerospikeIndexDefinition(@NonNull String name, @NonNull String bin, @NonNull IndexType type, @NonNull IndexCollectionType collectionType, @NonNull Class<?> entityClass, CTX[] ctx) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (bin == null) {
            throw new NullPointerException("bin is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (collectionType == null) {
            throw new NullPointerException("collectionType is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        this.name = name;
        this.bin = bin;
        this.type = type;
        this.collectionType = collectionType;
        this.entityClass = entityClass;
        this.ctx = ctx;
    }

    public static AerospikeIndexDefinitionBuilder builder() {
        return new AerospikeIndexDefinitionBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getBin() {
        return this.bin;
    }

    @NonNull
    public IndexType getType() {
        return this.type;
    }

    @NonNull
    public IndexCollectionType getCollectionType() {
        return this.collectionType;
    }

    @NonNull
    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public CTX[] getCtx() {
        return this.ctx;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AerospikeIndexDefinition)) {
            return false;
        }
        AerospikeIndexDefinition other = (AerospikeIndexDefinition)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$bin = this.getBin();
        String other$bin = other.getBin();
        if (this$bin == null ? other$bin != null : !this$bin.equals(other$bin)) {
            return false;
        }
        IndexType this$type = this.getType();
        IndexType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        IndexCollectionType this$collectionType = this.getCollectionType();
        IndexCollectionType other$collectionType = other.getCollectionType();
        if (this$collectionType == null ? other$collectionType != null : !this$collectionType.equals(other$collectionType)) {
            return false;
        }
        Class<?> this$entityClass = this.getEntityClass();
        Class<?> other$entityClass = other.getEntityClass();
        if (this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass)) {
            return false;
        }
        return Arrays.deepEquals(this.getCtx(), other.getCtx());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $bin = this.getBin();
        result = result * 59 + ($bin == null ? 43 : $bin.hashCode());
        IndexType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        IndexCollectionType $collectionType = this.getCollectionType();
        result = result * 59 + ($collectionType == null ? 43 : $collectionType.hashCode());
        Class<?> $entityClass = this.getEntityClass();
        result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCtx());
        return result;
    }

    public String toString() {
        return "AerospikeIndexDefinition(name=" + this.getName() + ", bin=" + this.getBin() + ", type=" + this.getType() + ", collectionType=" + this.getCollectionType() + ", entityClass=" + this.getEntityClass() + ", ctx=" + Arrays.deepToString(this.getCtx()) + ")";
    }

    public static class AerospikeIndexDefinitionBuilder {
        private String name;
        private String bin;
        private IndexType type;
        private IndexCollectionType collectionType;
        private Class<?> entityClass;
        private CTX[] ctx;

        AerospikeIndexDefinitionBuilder() {
        }

        public AerospikeIndexDefinitionBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public AerospikeIndexDefinitionBuilder bin(@NonNull String bin) {
            if (bin == null) {
                throw new NullPointerException("bin is marked non-null but is null");
            }
            this.bin = bin;
            return this;
        }

        public AerospikeIndexDefinitionBuilder type(@NonNull IndexType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public AerospikeIndexDefinitionBuilder collectionType(@NonNull IndexCollectionType collectionType) {
            if (collectionType == null) {
                throw new NullPointerException("collectionType is marked non-null but is null");
            }
            this.collectionType = collectionType;
            return this;
        }

        public AerospikeIndexDefinitionBuilder entityClass(@NonNull Class<?> entityClass) {
            if (entityClass == null) {
                throw new NullPointerException("entityClass is marked non-null but is null");
            }
            this.entityClass = entityClass;
            return this;
        }

        public AerospikeIndexDefinitionBuilder ctx(CTX[] ctx) {
            this.ctx = ctx;
            return this;
        }

        public AerospikeIndexDefinition build() {
            return new AerospikeIndexDefinition(this.name, this.bin, this.type, this.collectionType, this.entityClass, this.ctx);
        }

        public String toString() {
            return "AerospikeIndexDefinition.AerospikeIndexDefinitionBuilder(name=" + this.name + ", bin=" + this.bin + ", type=" + this.type + ", collectionType=" + this.collectionType + ", entityClass=" + this.entityClass + ", ctx=" + Arrays.deepToString(this.ctx) + ")";
        }
    }
}

