/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.exp.Exp;
import com.aerospike.client.exp.Expression;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.Qualifier;

public class FilterExpressionsBuilder {
    public Expression build(Qualifier[] qualifiers) {
        if (qualifiers != null && qualifiers.length != 0) {
            List<Qualifier> relevantQualifiers = Arrays.stream(qualifiers).filter(Objects::nonNull).filter(this::excludeIrrelevantFilters).toList();
            if (relevantQualifiers.size() > 1) {
                Exp[] exps = (Exp[])relevantQualifiers.stream().map(Qualifier::toFilterExp).toArray(Exp[]::new);
                Exp finalExp = Exp.and((Exp[])exps);
                return Exp.build((Exp)finalExp);
            }
            if (relevantQualifiers.size() == 1) {
                return Exp.build((Exp)relevantQualifiers.get(0).toFilterExp());
            }
        }
        return null;
    }

    private boolean excludeIrrelevantFilters(Qualifier qualifier) {
        return qualifier.queryAsFilter() == false || qualifier.queryAsFilter() != false && FilterOperation.dualFilterOperations.contains((Object)qualifier.getOperation());
    }
}

