/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.exp.ListExp;
import com.aerospike.client.exp.MapExp;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.util.Pair;
import org.springframework.util.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FilterOperation {
    AND{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Qualifier[] qs = (Qualifier[])qualifierMap.get("qualifiers");
            Exp[] childrenExp = new Exp[qs.length];
            for (int i = 0; i < qs.length; ++i) {
                childrenExp[i] = qs[i].toFilterExp();
            }
            return Exp.and((Exp[])childrenExp);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    OR{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Qualifier[] qs = (Qualifier[])qualifierMap.get("qualifiers");
            Exp[] childrenExp = new Exp[qs.length];
            for (int i = 0; i < qs.length; ++i) {
                childrenExp[i] = qs[i].toFilterExp();
            }
            return Exp.or((Exp[])childrenExp);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    IN{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Value val = 3.getValue1(qualifierMap);
            String errMsg = "FilterOperation.IN expects argument with type Collection, instead got: " + val.getObject().getClass().getSimpleName();
            if (val.getType() != 20) {
                throw new IllegalArgumentException(errMsg);
            }
            if (!(val.getObject() instanceof Collection)) {
                throw new IllegalArgumentException(errMsg);
            }
            Collection collection = (Collection)val.getObject();
            Exp[] listElementsExp = (Exp[])collection.stream().map(item -> new Qualifier(new Qualifier.QualifierBuilder().setField(3.getField(qualifierMap)).setFilterOperation(EQ).setValue1(Value.get((Object)item))).toFilterExp()).toArray(Exp[]::new);
            return Exp.or((Exp[])listElementsExp);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    NOT_IN{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Value val = 4.getValue1(qualifierMap);
            String errMsg = "FilterOperation.NOT_IN expects argument with type Collection, instead got: " + val.getObject().getClass().getSimpleName();
            if (val.getType() != 20) {
                throw new IllegalArgumentException(errMsg);
            }
            if (!(val.getObject() instanceof Collection)) {
                throw new IllegalArgumentException(errMsg);
            }
            Collection collection = (Collection)val.getObject();
            Exp[] listElementsExp = (Exp[])collection.stream().map(item -> new Qualifier(new Qualifier.QualifierBuilder().setField(4.getField(qualifierMap)).setFilterOperation(NOTEQ).setValue1(Value.get((Object)item))).toFilterExp()).toArray(Exp[]::new);
            return Exp.and((Exp[])listElementsExp);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    EQ{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Value value = 5.getValue1(qualifierMap);
            return switch (value.getType()) {
                case 1 -> Exp.eq((Exp)Exp.intBin((String)5.getField(qualifierMap)), (Exp)Exp.val((long)value.toLong()));
                case 3 -> {
                    if (5.ignoreCase(qualifierMap).booleanValue()) {
                        String equalsRegexp = Qualifier.QualifierRegexpBuilder.getStringEquals(5.getValue1(qualifierMap).toString());
                        yield Exp.regexCompare((String)equalsRegexp, (int)2, (Exp)Exp.stringBin((String)5.getField(qualifierMap)));
                    }
                    yield Exp.eq((Exp)Exp.stringBin((String)5.getField(qualifierMap)), (Exp)Exp.val((String)value.toString()));
                }
                case 17 -> Exp.eq((Exp)Exp.boolBin((String)5.getField(qualifierMap)), (Exp)Exp.val((boolean)((Boolean)value.getObject())));
                case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 5.getField(qualifierMap), Exp::eq, Exp::mapBin);
                case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 5.getField(qualifierMap), Exp::eq, Exp::listBin);
                default -> throw new IllegalArgumentException("EQ FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (5.getValue1(qualifierMap).getType() == 1) {
                return Filter.equal((String)5.getField(qualifierMap), (long)5.getValue1(qualifierMap).toLong(), (CTX[])new CTX[0]);
            }
            if (5.ignoreCase(qualifierMap).booleanValue()) {
                return null;
            }
            return Filter.equal((String)5.getField(qualifierMap), (String)5.getValue1(qualifierMap).toString(), (CTX[])new CTX[0]);
        }
    }
    ,
    NOTEQ{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Value value = 6.getValue1(qualifierMap);
            return switch (value.getType()) {
                case 1 -> {
                    Exp ne = Exp.ne((Exp)Exp.intBin((String)6.getField(qualifierMap)), (Exp)Exp.val((long)value.toLong()));
                    yield Exp.or((Exp[])new Exp[]{Exp.not((Exp)Exp.binExists((String)6.getField(qualifierMap))), ne});
                }
                case 3 -> {
                    if (6.ignoreCase(qualifierMap).booleanValue()) {
                        String equalsRegexp = Qualifier.QualifierRegexpBuilder.getStringEquals(6.getValue1(qualifierMap).toString());
                        Exp regexCompare = Exp.not((Exp)Exp.regexCompare((String)equalsRegexp, (int)2, (Exp)Exp.stringBin((String)6.getField(qualifierMap))));
                        yield Exp.or((Exp[])new Exp[]{Exp.not((Exp)Exp.binExists((String)6.getField(qualifierMap))), regexCompare});
                    }
                    Exp ne = Exp.ne((Exp)Exp.stringBin((String)6.getField(qualifierMap)), (Exp)Exp.val((String)value.toString()));
                    yield Exp.or((Exp[])new Exp[]{Exp.not((Exp)Exp.binExists((String)6.getField(qualifierMap))), ne});
                }
                case 17 -> {
                    Exp ne = Exp.ne((Exp)Exp.boolBin((String)6.getField(qualifierMap)), (Exp)Exp.val((boolean)((Boolean)value.getObject())));
                    yield Exp.or((Exp[])new Exp[]{Exp.not((Exp)Exp.binExists((String)6.getField(qualifierMap))), ne});
                }
                case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 6.getField(qualifierMap), Exp::ne, Exp::mapBin);
                case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 6.getField(qualifierMap), Exp::ne, Exp::listBin);
                default -> throw new IllegalArgumentException("NOTEQ FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    GT{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Value value = 7.getValue1(qualifierMap);
            return switch (value.getType()) {
                case 1 -> Exp.gt((Exp)Exp.intBin((String)7.getField(qualifierMap)), (Exp)Exp.val((long)7.getValue1(qualifierMap).toLong()));
                case 3 -> Exp.gt((Exp)Exp.stringBin((String)7.getField(qualifierMap)), (Exp)Exp.val((String)7.getValue1(qualifierMap).toString()));
                case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 7.getField(qualifierMap), Exp::gt, Exp::mapBin);
                case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 7.getField(qualifierMap), Exp::gt, Exp::listBin);
                default -> throw new IllegalArgumentException("GT FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (7.getValue1(qualifierMap).getType() != 1 || 7.getValue1(qualifierMap).toLong() == Long.MAX_VALUE) {
                return null;
            }
            return Filter.range((String)7.getField(qualifierMap), (long)(7.getValue1(qualifierMap).toLong() + 1L), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    GTEQ{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Value value = 8.getValue1(qualifierMap);
            return switch (value.getType()) {
                case 1 -> Exp.ge((Exp)Exp.intBin((String)8.getField(qualifierMap)), (Exp)Exp.val((long)8.getValue1(qualifierMap).toLong()));
                case 3 -> Exp.ge((Exp)Exp.stringBin((String)8.getField(qualifierMap)), (Exp)Exp.val((String)8.getValue1(qualifierMap).toString()));
                case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 8.getField(qualifierMap), Exp::ge, Exp::mapBin);
                case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 8.getField(qualifierMap), Exp::ge, Exp::listBin);
                default -> throw new IllegalArgumentException("GTEQ FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (8.getValue1(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)8.getField(qualifierMap), (long)8.getValue1(qualifierMap).toLong(), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    LT{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Value value = 9.getValue1(qualifierMap);
            return switch (value.getType()) {
                case 1 -> Exp.lt((Exp)Exp.intBin((String)9.getField(qualifierMap)), (Exp)Exp.val((long)9.getValue1(qualifierMap).toLong()));
                case 3 -> Exp.lt((Exp)Exp.stringBin((String)9.getField(qualifierMap)), (Exp)Exp.val((String)9.getValue1(qualifierMap).toString()));
                case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 9.getField(qualifierMap), Exp::lt, Exp::mapBin);
                case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 9.getField(qualifierMap), Exp::lt, Exp::listBin);
                default -> throw new IllegalArgumentException("LT FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (9.getValue1(qualifierMap).getType() != 1 || 9.getValue1(qualifierMap).toLong() == Long.MIN_VALUE) {
                return null;
            }
            return Filter.range((String)9.getField(qualifierMap), (long)Long.MIN_VALUE, (long)(9.getValue1(qualifierMap).toLong() - 1L), (CTX[])new CTX[0]);
        }
    }
    ,
    LTEQ{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Value value = 10.getValue1(qualifierMap);
            return switch (value.getType()) {
                case 1 -> Exp.le((Exp)Exp.intBin((String)10.getField(qualifierMap)), (Exp)Exp.val((long)10.getValue1(qualifierMap).toLong()));
                case 3 -> Exp.le((Exp)Exp.stringBin((String)10.getField(qualifierMap)), (Exp)Exp.val((String)10.getValue1(qualifierMap).toString()));
                case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 10.getField(qualifierMap), Exp::le, Exp::mapBin);
                case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 10.getField(qualifierMap), Exp::le, Exp::listBin);
                default -> throw new IllegalArgumentException("LTEQ FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (10.getValue1(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)10.getField(qualifierMap), (long)Long.MIN_VALUE, (long)10.getValue1(qualifierMap).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    BETWEEN{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            FilterOperation.validateEquality(11.getValue1(qualifierMap).getType(), 11.getValue2(qualifierMap).getType(), qualifierMap, "BETWEEN");
            return switch (11.getValue1(qualifierMap).getType()) {
                case 1 -> Exp.and((Exp[])new Exp[]{Exp.ge((Exp)Exp.intBin((String)11.getField(qualifierMap)), (Exp)Exp.val((long)11.getValue1(qualifierMap).toLong())), Exp.lt((Exp)Exp.intBin((String)11.getField(qualifierMap)), (Exp)Exp.val((long)11.getValue2(qualifierMap).toLong()))});
                case 3 -> Exp.and((Exp[])new Exp[]{Exp.ge((Exp)Exp.stringBin((String)11.getField(qualifierMap)), (Exp)Exp.val((String)11.getValue1(qualifierMap).toString())), Exp.lt((Exp)Exp.stringBin((String)11.getField(qualifierMap)), (Exp)Exp.val((String)11.getValue2(qualifierMap).toString()))});
                case 19 -> Exp.and((Exp[])new Exp[]{FilterOperation.getFilterExp(Exp.val((Map)((Map)11.getValue1(qualifierMap).getObject())), 11.getField(qualifierMap), Exp::ge, Exp::mapBin), FilterOperation.getFilterExp(Exp.val((Map)((Map)11.getValue2(qualifierMap).getObject())), 11.getField(qualifierMap), Exp::lt, Exp::mapBin)});
                case 20 -> Exp.and((Exp[])new Exp[]{FilterOperation.getFilterExp(Exp.val((List)((List)11.getValue1(qualifierMap).getObject())), 11.getField(qualifierMap), Exp::ge, Exp::listBin), FilterOperation.getFilterExp(Exp.val((List)((List)11.getValue2(qualifierMap).getObject())), 11.getField(qualifierMap), Exp::lt, Exp::listBin)});
                default -> throw new IllegalArgumentException("BETWEEN: unexpected value of type " + 11.getValue1(qualifierMap).getClass().getSimpleName());
            };
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (11.getValue1(qualifierMap).getType() != 1 || 11.getValue2(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)11.getField(qualifierMap), (long)11.getValue1(qualifierMap).toLong(), (long)11.getValue2(qualifierMap).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    STARTS_WITH{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            String startWithRegexp = Qualifier.QualifierRegexpBuilder.getStartsWith(12.getValue1(qualifierMap).toString());
            return Exp.regexCompare((String)startWithRegexp, (int)12.regexFlags(qualifierMap), (Exp)Exp.stringBin((String)12.getField(qualifierMap)));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    ENDS_WITH{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            String endWithRegexp = Qualifier.QualifierRegexpBuilder.getEndsWith(13.getValue1(qualifierMap).toString());
            return Exp.regexCompare((String)endWithRegexp, (int)13.regexFlags(qualifierMap), (Exp)Exp.stringBin((String)13.getField(qualifierMap)));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    CONTAINING{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            String containingRegexp = Qualifier.QualifierRegexpBuilder.getContaining(14.getValue1(qualifierMap).toString());
            return Exp.regexCompare((String)containingRegexp, (int)14.regexFlags(qualifierMap), (Exp)Exp.stringBin((String)14.getField(qualifierMap)));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    NOT_CONTAINING{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            String notContainingRegexp = Qualifier.QualifierRegexpBuilder.getNotContaining(15.getValue1(qualifierMap).toString());
            return Exp.or((Exp[])new Exp[]{Exp.not((Exp)Exp.binExists((String)15.getField(qualifierMap))), Exp.not((Exp)Exp.regexCompare((String)notContainingRegexp, (int)15.regexFlags(qualifierMap), (Exp)Exp.stringBin((String)15.getField(qualifierMap))))});
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    LIKE{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            int flags = 1;
            if (16.ignoreCase(qualifierMap).booleanValue()) {
                flags = 3;
            }
            return Exp.regexCompare((String)16.getValue1(qualifierMap).toString(), (int)flags, (Exp)Exp.stringBin((String)16.getField(qualifierMap)));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_EQ_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.getFilterExpMapValEqOrFail(qualifierMap, Exp::eq);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            String[] dotPathArr = FilterOperation.getDotPathArray(17.getDotPath(qualifierMap), "MAP_VAL_EQ_BY_KEY secondary index filter: dotPath has not been set");
            boolean useCtx = dotPathArr.length > 2;
            return switch (17.getValue1(qualifierMap).getType()) {
                case 3 -> {
                    if (17.ignoreCase(qualifierMap).booleanValue()) {
                        yield null;
                    }
                    if (useCtx) {
                        yield null;
                    }
                    yield Filter.contains((String)17.getField(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (String)17.getValue1(qualifierMap).toString(), (CTX[])new CTX[0]);
                }
                case 1 -> {
                    if (useCtx) {
                        yield null;
                    }
                    yield Filter.range((String)17.getField(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)17.getValue1(qualifierMap).toLong(), (long)17.getValue1(qualifierMap).toLong(), (CTX[])new CTX[0]);
                }
                default -> null;
            };
        }
    }
    ,
    MAP_VAL_NOTEQ_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.getFilterExpMapValNotEqOrFail(qualifierMap, Exp::ne);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_GT_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.getFilterExpMapValOrFail(qualifierMap, Exp::gt, "MAP_VAL_GT_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (19.getValue1(qualifierMap).getType() != 1 || 19.getValue1(qualifierMap).toLong() == Long.MAX_VALUE) {
                return null;
            }
            String[] dotPathArr = FilterOperation.getDotPathArray(19.getDotPath(qualifierMap), "MAP_VAL_GT_BY_KEY secondary index filter: dotPath has not been set");
            if (dotPathArr.length > 2) {
                return null;
            }
            return Filter.range((String)19.getField(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)(19.getValue1(qualifierMap).toLong() + 1L), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    MAP_VAL_GTEQ_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.getFilterExpMapValOrFail(qualifierMap, Exp::ge, "MAP_VAL_GTEQ_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (20.getValue1(qualifierMap).getType() != 1) {
                return null;
            }
            String[] dotPathArr = FilterOperation.getDotPathArray(20.getDotPath(qualifierMap), "MAP_VAL_GTEQ_BY_KEY secondary index filter: dotPath has not been set");
            if (dotPathArr.length > 2) {
                return null;
            }
            return Filter.range((String)20.getField(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)20.getValue1(qualifierMap).toLong(), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    MAP_VAL_LT_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.getFilterExpMapValOrFail(qualifierMap, Exp::lt, "MAP_VAL_LT_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (21.getValue1(qualifierMap).getType() != 1 || 21.getValue1(qualifierMap).toLong() == Long.MIN_VALUE) {
                return null;
            }
            String[] dotPathArr = FilterOperation.getDotPathArray(21.getDotPath(qualifierMap), "MAP_VAL_LT_BY_KEY secondary index filter: dotPath has not been set");
            if (dotPathArr.length > 2) {
                return null;
            }
            return Filter.range((String)21.getField(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)Long.MIN_VALUE, (long)(21.getValue1(qualifierMap).toLong() - 1L), (CTX[])new CTX[0]);
        }
    }
    ,
    MAP_VAL_LTEQ_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.getFilterExpMapValOrFail(qualifierMap, Exp::le, "MAP_VAL_LTEQ_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (22.getValue1(qualifierMap).getType() != 1) {
                return null;
            }
            String[] dotPathArr = FilterOperation.getDotPathArray(22.getDotPath(qualifierMap), "MAP_VAL_LTEQ_BY_KEY secondary index filter: dotPath has not been set");
            if (dotPathArr.length > 2) {
                return null;
            }
            return Filter.range((String)22.getField(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)Long.MIN_VALUE, (long)22.getValue1(qualifierMap).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    MAP_VAL_BETWEEN_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Exp value2;
            Exp value1;
            String[] dotPathArr = FilterOperation.getDotPathArray(23.getDotPath(qualifierMap), "MAP_VAL_BETWEEN_BY_KEY filter expression: dotPath has not been set");
            FilterOperation.validateEquality(23.getValue1(qualifierMap).getType(), 23.getValue3(qualifierMap).getType(), qualifierMap, "MAP_VAL_BETWEEN_BY_KEY");
            return 23.mapValBetweenByKey(qualifierMap, dotPathArr, switch (23.getValue1(qualifierMap).getType()) {
                case 1 -> {
                    value1 = Exp.val((long)23.getValue1(qualifierMap).toLong());
                    value2 = Exp.val((long)23.getValue3(qualifierMap).toLong());
                    yield Exp.Type.INT;
                }
                case 3 -> {
                    value1 = Exp.val((String)23.getValue1(qualifierMap).toString());
                    value2 = Exp.val((String)23.getValue3(qualifierMap).toString());
                    yield Exp.Type.STRING;
                }
                case 20 -> {
                    value1 = Exp.val((List)((List)23.getValue1(qualifierMap).getObject()));
                    value2 = Exp.val((List)((List)23.getValue3(qualifierMap).getObject()));
                    yield Exp.Type.LIST;
                }
                case 19 -> {
                    value1 = Exp.val((Map)((Map)23.getValue1(qualifierMap).getObject()));
                    value2 = Exp.val((Map)((Map)23.getValue3(qualifierMap).getObject()));
                    yield Exp.Type.MAP;
                }
                default -> throw new IllegalArgumentException("MAP_VAL_BETWEEN_BY_KEY FilterExpression unsupported type: got " + 23.getValue1(qualifierMap).getClass().getSimpleName());
            }, value1, value2);
        }

        private static Exp mapValBetweenByKey(Map<String, Object> qualifierMap, String[] dotPathArr, Exp.Type type, Exp lowerLimit, Exp upperLimit) {
            Exp mapExp = dotPathArr.length > 2 ? MapExp.getByKey((int)7, (Exp.Type)type, (Exp)Exp.val((String)23.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)23.getField(qualifierMap)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr)) : MapExp.getByKey((int)7, (Exp.Type)type, (Exp)Exp.val((String)23.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)23.getField(qualifierMap)), (CTX[])new CTX[0]);
            return Exp.and((Exp[])new Exp[]{Exp.ge((Exp)mapExp, (Exp)lowerLimit), Exp.lt((Exp)mapExp, (Exp)upperLimit)});
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (23.getValue1(qualifierMap).getType() != 1 || 23.getValue3(qualifierMap).getType() != 1) {
                return null;
            }
            String[] dotPathArr = FilterOperation.getDotPathArray(23.getDotPath(qualifierMap), "MAP_VAL_BETWEEN_BY_KEY secondary index filter: dotPath has not been set");
            if (dotPathArr.length > 2) {
                return null;
            }
            return Filter.range((String)23.getField(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)23.getValue1(qualifierMap).toLong(), (long)23.getValue3(qualifierMap).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    MAP_VAL_STARTS_WITH_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            String startWithRegexp = Qualifier.QualifierRegexpBuilder.getStartsWith(24.getValue1(qualifierMap).toString());
            return Exp.regexCompare((String)startWithRegexp, (int)24.regexFlags(qualifierMap), (Exp)MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)24.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)24.getField(qualifierMap)), (CTX[])new CTX[0]));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_LIKE_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            int flags = 1;
            if (25.ignoreCase(qualifierMap).booleanValue()) {
                flags = 3;
            }
            return Exp.regexCompare((String)25.getValue1(qualifierMap).toString(), (int)flags, (Exp)MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)25.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)25.getField(qualifierMap)), (CTX[])new CTX[0]));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_ENDS_WITH_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            String endWithRegexp = Qualifier.QualifierRegexpBuilder.getEndsWith(26.getValue1(qualifierMap).toString());
            return Exp.regexCompare((String)endWithRegexp, (int)26.regexFlags(qualifierMap), (Exp)MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)26.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)26.getField(qualifierMap)), (CTX[])new CTX[0]));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_CONTAINING_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            String containingRegexp = Qualifier.QualifierRegexpBuilder.getContaining(27.getValue1(qualifierMap).toString());
            Exp bin = MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)27.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)27.getField(qualifierMap)), (CTX[])new CTX[0]);
            return Exp.regexCompare((String)containingRegexp, (int)27.regexFlags(qualifierMap), (Exp)bin);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_NOT_CONTAINING_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            String containingRegexp = Qualifier.QualifierRegexpBuilder.getContaining(28.getValue1(qualifierMap).toString());
            Exp mapIsNull = Exp.not((Exp)Exp.binExists((String)28.getField(qualifierMap)));
            Exp mapKeysNotContaining = Exp.eq((Exp)MapExp.getByKey((int)5, (Exp.Type)Exp.Type.INT, (Exp)Exp.val((String)28.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)28.getField(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
            Exp binValue = MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)28.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)28.getField(qualifierMap)), (CTX[])new CTX[0]);
            return Exp.or((Exp[])new Exp[]{mapIsNull, mapKeysNotContaining, Exp.not((Exp)Exp.regexCompare((String)containingRegexp, (int)28.regexFlags(qualifierMap), (Exp)binValue))});
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_EXISTS_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.mapKeysContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_NOT_EXISTS_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.mapKeysNotContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_IS_NOT_NULL_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            String[] dotPathArray = FilterOperation.getDotPathArray(31.getDotPath(qualifierMap), "MAP_VAL_IS_NULL_BY_KEY: dotPath was not set");
            if (dotPathArray.length > 1) {
                return FilterOperation.mapKeysContain(qualifierMap);
            }
            return FilterOperation.getMapValEqOrFail(qualifierMap, Exp::eq, "MAP_VAL_IS_NULL_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_IS_NULL_BY_KEY{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            String[] dotPathArray = FilterOperation.getDotPathArray(32.getDotPath(qualifierMap), "MAP_VAL_IS_NULL_BY_KEY: dotPath was not set");
            if (dotPathArray.length > 1) {
                return FilterOperation.mapKeysNotContain(qualifierMap);
            }
            return FilterOperation.getMapValEqOrFail(qualifierMap, Exp::eq, "MAP_VAL_IS_NULL_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_KEYS_CONTAIN{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.mapKeysContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return this.collectionContains(IndexCollectionType.MAPKEYS, qualifierMap);
        }
    }
    ,
    MAP_KEYS_NOT_CONTAIN{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.mapKeysNotContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return this.collectionContains(IndexCollectionType.MAPKEYS, qualifierMap);
        }
    }
    ,
    MAP_VALUES_CONTAIN{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.mapValuesContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return this.collectionContains(IndexCollectionType.MAPVALUES, qualifierMap);
        }
    }
    ,
    MAP_VALUES_NOT_CONTAIN{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return FilterOperation.mapValuesNotContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return this.collectionContains(IndexCollectionType.MAPVALUES, qualifierMap);
        }
    }
    ,
    MAP_KEYS_BETWEEN{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            FilterOperation.validateEquality(37.getValue1(qualifierMap).getType(), 37.getValue2(qualifierMap).getType(), qualifierMap, "MAP_KEYS_BETWEEN");
            Pair twoValues = switch (37.getValue1(qualifierMap).getType()) {
                case 1 -> Pair.of((Object)Exp.val((long)37.getValue1(qualifierMap).toLong()), (Object)Exp.val((long)37.getValue2(qualifierMap).toLong()));
                case 3 -> Pair.of((Object)Exp.val((String)37.getValue1(qualifierMap).toString()), (Object)Exp.val((String)37.getValue2(qualifierMap).toString()));
                case 20 -> Pair.of((Object)Exp.val((List)((List)37.getValue1(qualifierMap).getObject())), (Object)Exp.val((List)((List)37.getValue2(qualifierMap).getObject())));
                case 19 -> Pair.of((Object)Exp.val((Map)((Map)37.getValue1(qualifierMap).getObject())), (Object)Exp.val((Map)((Map)37.getValue2(qualifierMap).getObject())));
                default -> throw new UnsupportedOperationException("MAP_KEYS_BETWEEN FilterExpression unsupported type: got " + 37.getValue1(qualifierMap).getClass().getSimpleName());
            };
            return Exp.gt((Exp)MapExp.getByKeyRange((int)5, (Exp)((Exp)twoValues.getFirst()), (Exp)((Exp)twoValues.getSecond()), (Exp)Exp.mapBin((String)37.getField(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return this.collectionRange(IndexCollectionType.MAPKEYS, qualifierMap);
        }
    }
    ,
    MAP_VAL_BETWEEN{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            FilterOperation.validateEquality(38.getValue1(qualifierMap).getType(), 38.getValue2(qualifierMap).getType(), qualifierMap, "MAP_VAL_BETWEEN");
            Pair twoValues = switch (38.getValue1(qualifierMap).getType()) {
                case 1 -> Pair.of((Object)Exp.val((long)38.getValue1(qualifierMap).toLong()), (Object)Exp.val((long)38.getValue2(qualifierMap).toLong()));
                case 3 -> Pair.of((Object)Exp.val((String)38.getValue1(qualifierMap).toString()), (Object)Exp.val((String)38.getValue2(qualifierMap).toString()));
                case 20 -> Pair.of((Object)Exp.val((List)((List)38.getValue1(qualifierMap).getObject())), (Object)Exp.val((List)((List)38.getValue2(qualifierMap).getObject())));
                case 19 -> Pair.of((Object)Exp.val((Map)((Map)38.getValue1(qualifierMap).getObject())), (Object)Exp.val((Map)((Map)38.getValue2(qualifierMap).getObject())));
                default -> throw new UnsupportedOperationException("MAP_VAL_BETWEEN FilterExpression unsupported type: got " + 38.getValue1(qualifierMap).getClass().getSimpleName());
            };
            return Exp.gt((Exp)MapExp.getByValueRange((int)5, (Exp)((Exp)twoValues.getFirst()), (Exp)((Exp)twoValues.getSecond()), (Exp)Exp.mapBin((String)38.getField(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (38.getValue1(qualifierMap).getType() != 1 || 38.getValue2(qualifierMap).getType() != 1) {
                return null;
            }
            return this.collectionRange(IndexCollectionType.MAPVALUES, qualifierMap);
        }
    }
    ,
    GEO_WITHIN{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return Exp.geoCompare((Exp)Exp.geoBin((String)39.getField(qualifierMap)), (Exp)Exp.geo((String)39.getValue1(qualifierMap).toString()));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return this.geoWithinRadius(IndexCollectionType.DEFAULT, qualifierMap);
        }
    }
    ,
    LIST_VAL_CONTAINING{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            if (40.getValue1(qualifierMap) instanceof Value.BoolIntValue) {
                qualifierMap.put("value1", new Value.BooleanValue(((Boolean)40.getValue1(qualifierMap).getObject()).booleanValue()));
            }
            Exp value = switch (40.getValue1(qualifierMap).getType()) {
                case 1 -> Exp.val((long)40.getValue1(qualifierMap).toLong());
                case 3 -> Exp.val((String)40.getValue1(qualifierMap).toString());
                case 17 -> Exp.val((boolean)((Boolean)40.getValue1(qualifierMap).getObject()));
                case 20 -> Exp.val((List)((List)40.getValue1(qualifierMap).getObject()));
                case 19 -> Exp.val((Map)((Map)40.getValue1(qualifierMap).getObject()));
                case 0 -> Exp.nil();
                default -> throw new UnsupportedOperationException("LIST_VAL_CONTAINING FilterExpression unsupported type: got " + 40.getValue1(qualifierMap).getClass().getSimpleName());
            };
            return Exp.gt((Exp)ListExp.getByValue((int)5, (Exp)value, (Exp)Exp.listBin((String)40.getField(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (40.getValue1(qualifierMap).getType() != 3 && 40.getValue1(qualifierMap).getType() != 1) {
                return null;
            }
            return this.collectionContains(IndexCollectionType.LIST, qualifierMap);
        }
    }
    ,
    LIST_VAL_NOT_CONTAINING{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            if (41.getValue1(qualifierMap) instanceof Value.BoolIntValue) {
                qualifierMap.put("value1", new Value.BooleanValue(((Boolean)41.getValue1(qualifierMap).getObject()).booleanValue()));
            }
            Exp value = switch (41.getValue1(qualifierMap).getType()) {
                case 1 -> Exp.val((long)41.getValue1(qualifierMap).toLong());
                case 3 -> Exp.val((String)41.getValue1(qualifierMap).toString());
                case 17 -> Exp.val((boolean)((Boolean)41.getValue1(qualifierMap).getObject()));
                case 20 -> Exp.val((List)((List)41.getValue1(qualifierMap).getObject()));
                case 19 -> Exp.val((Map)((Map)41.getValue1(qualifierMap).getObject()));
                case 0 -> Exp.nil();
                default -> throw new UnsupportedOperationException("LIST_VAL_CONTAINING FilterExpression unsupported type: got " + 41.getValue1(qualifierMap).getClass().getSimpleName());
            };
            Exp binIsNull = Exp.not((Exp)Exp.binExists((String)41.getField(qualifierMap)));
            Exp listNotContaining = Exp.eq((Exp)ListExp.getByValue((int)5, (Exp)value, (Exp)Exp.listBin((String)41.getField(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
            return Exp.or((Exp[])new Exp[]{binIsNull, listNotContaining});
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    LIST_VAL_BETWEEN{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            FilterOperation.validateEquality(42.getValue1(qualifierMap).getType(), 42.getValue2(qualifierMap).getType(), qualifierMap, "LIST_VAL_BETWEEN");
            Pair twoValues = switch (42.getValue1(qualifierMap).getType()) {
                case 1 -> Pair.of((Object)Exp.val((long)42.getValue1(qualifierMap).toLong()), (Object)Exp.val((long)42.getValue2(qualifierMap).toLong()));
                case 3 -> Pair.of((Object)Exp.val((String)42.getValue1(qualifierMap).toString()), (Object)Exp.val((String)42.getValue2(qualifierMap).toString()));
                case 20 -> Pair.of((Object)Exp.val((List)((List)42.getValue1(qualifierMap).getObject())), (Object)Exp.val((List)((List)42.getValue2(qualifierMap).getObject())));
                case 19 -> Pair.of((Object)Exp.val((Map)((Map)42.getValue1(qualifierMap).getObject())), (Object)Exp.val((Map)((Map)42.getValue2(qualifierMap).getObject())));
                default -> throw new UnsupportedOperationException("LIST_VAL_BETWEEN FilterExpression unsupported type: got " + 42.getValue1(qualifierMap).getClass().getSimpleName());
            };
            return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)((Exp)twoValues.getFirst()), (Exp)((Exp)twoValues.getSecond()), (Exp)Exp.listBin((String)42.getField(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (42.getValue1(qualifierMap).getType() != 1 || 42.getValue2(qualifierMap).getType() != 1) {
                return null;
            }
            return this.collectionRange(IndexCollectionType.LIST, qualifierMap);
        }
    }
    ,
    LIST_VAL_GT{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            if (43.getValue1(qualifierMap).getType() == 1) {
                if (43.getValue1(qualifierMap).toLong() == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("LIST_VAL_GT FilterExpression unsupported value: expected [Long.MIN_VALUE..Long.MAX_VALUE-1]");
                }
                return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)Exp.val((long)(43.getValue1(qualifierMap).toLong() + 1L)), null, (Exp)Exp.listBin((String)43.getField(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
            }
            Exp value = switch (43.getValue1(qualifierMap).getType()) {
                case 3 -> Exp.val((String)43.getValue1(qualifierMap).toString());
                case 20 -> Exp.val((List)((List)43.getValue1(qualifierMap).getObject()));
                case 19 -> Exp.val((Map)((Map)43.getValue1(qualifierMap).getObject()));
                default -> throw new UnsupportedOperationException("LIST_VAL_GT FilterExpression unsupported type: got " + 43.getValue1(qualifierMap).getClass().getSimpleName());
            };
            Exp rangeIncludingValue = ListExp.getByValueRange((int)5, (Exp)value, null, (Exp)Exp.listBin((String)43.getField(qualifierMap)), (CTX[])new CTX[0]);
            Exp valueOnly = ListExp.getByValue((int)5, (Exp)value, (Exp)Exp.listBin((String)43.getField(qualifierMap)), (CTX[])new CTX[0]);
            return Exp.gt((Exp)Exp.sub((Exp[])new Exp[]{rangeIncludingValue, valueOnly}), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (43.getValue1(qualifierMap).getType() != 1 || 43.getValue1(qualifierMap).toLong() == Long.MAX_VALUE) {
                return null;
            }
            return Filter.range((String)43.getField(qualifierMap), (IndexCollectionType)IndexCollectionType.LIST, (long)(43.getValue1(qualifierMap).toLong() + 1L), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    LIST_VAL_GTEQ{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Exp value = switch (44.getValue1(qualifierMap).getType()) {
                case 1 -> Exp.val((long)44.getValue1(qualifierMap).toLong());
                case 3 -> Exp.val((String)44.getValue1(qualifierMap).toString());
                case 20 -> Exp.val((List)((List)44.getValue1(qualifierMap).getObject()));
                case 19 -> Exp.val((Map)((Map)44.getValue1(qualifierMap).getObject()));
                default -> throw new UnsupportedOperationException("LIST_VAL_GTEQ FilterExpression unsupported type: got " + 44.getValue1(qualifierMap).getClass().getSimpleName());
            };
            return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)value, null, (Exp)Exp.listBin((String)44.getField(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (44.getValue1(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)44.getField(qualifierMap), (IndexCollectionType)IndexCollectionType.LIST, (long)44.getValue1(qualifierMap).toLong(), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    LIST_VAL_LT{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            Exp value = switch (45.getValue1(qualifierMap).getType()) {
                case 1 -> {
                    if (45.getValue1(qualifierMap).toLong() == Long.MIN_VALUE) {
                        throw new UnsupportedOperationException("LIST_VAL_LT FilterExpression unsupported value: expected [Long.MIN_VALUE+1..Long.MAX_VALUE]");
                    }
                    yield Exp.val((long)45.getValue1(qualifierMap).toLong());
                }
                case 3 -> Exp.val((String)45.getValue1(qualifierMap).toString());
                case 20 -> Exp.val((List)((List)45.getValue1(qualifierMap).getObject()));
                case 19 -> Exp.val((Map)((Map)45.getValue1(qualifierMap).getObject()));
                default -> throw new UnsupportedOperationException("LIST_VAL_GTEQ FilterExpression unsupported type: got " + 45.getValue1(qualifierMap).getClass().getSimpleName());
            };
            return Exp.gt((Exp)ListExp.getByValueRange((int)5, null, (Exp)value, (Exp)Exp.listBin((String)45.getField(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (45.getValue1(qualifierMap).getType() != 1 || 45.getValue1(qualifierMap).toLong() == Long.MIN_VALUE) {
                return null;
            }
            return Filter.range((String)45.getField(qualifierMap), (IndexCollectionType)IndexCollectionType.LIST, (long)Long.MIN_VALUE, (long)(45.getValue1(qualifierMap).toLong() - 1L), (CTX[])new CTX[0]);
        }
    }
    ,
    LIST_VAL_LTEQ{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            if (46.getValue1(qualifierMap).getType() == 1) {
                Exp upperLimit = 46.getValue1(qualifierMap).toLong() == Long.MAX_VALUE ? Exp.inf() : Exp.val((long)(46.getValue1(qualifierMap).toLong() + 1L));
                return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)Exp.val((long)Long.MIN_VALUE), (Exp)upperLimit, (Exp)Exp.listBin((String)46.getField(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
            }
            Exp value = switch (46.getValue1(qualifierMap).getType()) {
                case 3 -> Exp.val((String)46.getValue1(qualifierMap).toString());
                case 20 -> Exp.val((List)((List)46.getValue1(qualifierMap).getObject()));
                case 19 -> Exp.val((Map)((Map)46.getValue1(qualifierMap).getObject()));
                default -> throw new UnsupportedOperationException("LIST_VAL_LTEQ FilterExpression unsupported type: got " + 46.getValue1(qualifierMap).getClass().getSimpleName());
            };
            Exp rangeIncludingValue = ListExp.getByValueRange((int)5, null, (Exp)value, (Exp)Exp.listBin((String)46.getField(qualifierMap)), (CTX[])new CTX[0]);
            Exp valueOnly = ListExp.getByValue((int)5, (Exp)value, (Exp)Exp.listBin((String)46.getField(qualifierMap)), (CTX[])new CTX[0]);
            return Exp.gt((Exp)Exp.add((Exp[])new Exp[]{rangeIncludingValue, valueOnly}), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            if (46.getValue1(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)46.getField(qualifierMap), (IndexCollectionType)IndexCollectionType.LIST, (long)Long.MIN_VALUE, (long)46.getValue1(qualifierMap).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    IS_NOT_NULL{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return Exp.binExists((String)47.getField(qualifierMap));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    IS_NULL{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return Exp.not((Exp)Exp.binExists((String)48.getField(qualifierMap)));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    }
    ,
    NOT_NULL{

        @Override
        public Exp filterExp(Map<String, Object> qualifierMap) {
            return Exp.binExists((String)49.getField(qualifierMap));
        }

        @Override
        public Filter sIndexFilter(Map<String, Object> qualifierMap) {
            return null;
        }
    };

    public static final List<FilterOperation> dualFilterOperations;

    private static Exp mapKeysNotContain(Map<String, Object> qualifierMap) {
        String errMsg = "MAP_KEYS_NOT_CONTAIN FilterExpression unsupported type: got " + FilterOperation.getValue1(qualifierMap).getClass().getSimpleName();
        Exp mapKeysNotContain = FilterOperation.mapKeysCount(qualifierMap, Exp::eq, errMsg);
        Exp binDoesNotExist = Exp.not((Exp)Exp.binExists((String)FilterOperation.getField(qualifierMap)));
        return Exp.or((Exp[])new Exp[]{binDoesNotExist, mapKeysNotContain});
    }

    private static Exp mapKeysContain(Map<String, Object> qualifierMap) {
        String errMsg = "MAP_KEYS_CONTAIN FilterExpression unsupported type: got " + FilterOperation.getValue1(qualifierMap).getClass().getSimpleName();
        return FilterOperation.mapKeysCount(qualifierMap, Exp::gt, errMsg);
    }

    private static Exp mapValuesNotContain(Map<String, Object> qualifierMap) {
        String errMsg = "MAP_VALUES_NOT_CONTAIN FilterExpression unsupported type: got " + FilterOperation.getValue1(qualifierMap).getClass().getSimpleName();
        Exp binDoesNotExist = Exp.not((Exp)Exp.binExists((String)FilterOperation.getField(qualifierMap)));
        Exp mapValuesNotContain = FilterOperation.mapValuesCount(qualifierMap, Exp::eq, errMsg);
        return Exp.or((Exp[])new Exp[]{binDoesNotExist, mapValuesNotContain});
    }

    private static Exp mapValuesContain(Map<String, Object> qualifierMap) {
        String errMsg = "MAP_VALUES_CONTAIN FilterExpression unsupported type: got " + FilterOperation.getValue1(qualifierMap).getClass().getSimpleName();
        return FilterOperation.mapValuesCount(qualifierMap, Exp::gt, errMsg);
    }

    private static Exp getValue1Exp(Map<String, Object> qualifierMap, String errMsg) {
        return switch (FilterOperation.getValue1(qualifierMap).getType()) {
            case 1 -> Exp.val((long)FilterOperation.getValue1(qualifierMap).toLong());
            case 3 -> Exp.val((String)FilterOperation.getValue1(qualifierMap).toString());
            case 20 -> Exp.val((List)((List)FilterOperation.getValue1(qualifierMap).getObject()));
            case 19 -> Exp.val((Map)((Map)FilterOperation.getValue1(qualifierMap).getObject()));
            case 0 -> Exp.nil();
            default -> throw new UnsupportedOperationException(errMsg);
        };
    }

    private static Exp mapKeysCount(Map<String, Object> qualifierMap, BinaryOperator<Exp> operator, String errMsg) {
        Exp value = FilterOperation.getValue1Exp(qualifierMap, errMsg);
        return (Exp)operator.apply(MapExp.getByKey((int)5, (Exp.Type)Exp.Type.INT, (Exp)value, (Exp)Exp.mapBin((String)FilterOperation.getField(qualifierMap)), (CTX[])new CTX[0]), Exp.val((long)0L));
    }

    private static Exp mapValuesCount(Map<String, Object> qualifierMap, BinaryOperator<Exp> operator, String errMsg) {
        Exp value = FilterOperation.getValue1Exp(qualifierMap, errMsg);
        return (Exp)operator.apply(MapExp.getByValue((int)5, (Exp)value, (Exp)Exp.mapBin((String)FilterOperation.getField(qualifierMap)), (CTX[])new CTX[0]), Exp.val((long)0L));
    }

    private static void validateEquality(int type1, int type2, Map<String, Object> qualifierMap, String opName) {
        if (type1 != type2) {
            throw new IllegalArgumentException(opName + ": expected both parameters to have the same type, instead got " + FilterOperation.getValue1(qualifierMap).getClass().getSimpleName() + " and " + FilterOperation.getValue2(qualifierMap).getClass().getSimpleName());
        }
    }

    private static Exp getFilterExpMapValOrFail(Map<String, Object> qualifierMap, BinaryOperator<Exp> operator, String opName) {
        String[] dotPathArr = FilterOperation.getDotPathArray(FilterOperation.getDotPath(qualifierMap), opName + " filter expression: dotPath has not been set");
        return switch (FilterOperation.getValue1(qualifierMap).getType()) {
            case 1 -> (Exp)operator.apply(FilterOperation.getMapExp(qualifierMap, dotPathArr, Exp.Type.INT), Exp.val((long)FilterOperation.getValue1(qualifierMap).toLong()));
            case 3 -> (Exp)operator.apply(FilterOperation.getMapExp(qualifierMap, dotPathArr, Exp.Type.STRING), Exp.val((String)FilterOperation.getValue1(qualifierMap).toString()));
            case 20 -> (Exp)operator.apply(FilterOperation.getMapExp(qualifierMap, dotPathArr, Exp.Type.LIST), Exp.val((List)((List)FilterOperation.getValue1(qualifierMap).getObject())));
            case 19 -> (Exp)operator.apply(FilterOperation.getMapExp(qualifierMap, dotPathArr, Exp.Type.MAP), Exp.val((Map)((Map)FilterOperation.getValue1(qualifierMap).getObject())));
            default -> throw new UnsupportedOperationException(opName + " FilterExpression unsupported type: " + FilterOperation.getValue1(qualifierMap).getClass().getSimpleName());
        };
    }

    private static Exp getMapExp(Map<String, Object> qualifierMap, String[] dotPathArr, Exp.Type expType) {
        if (dotPathArr.length > 2) {
            return MapExp.getByKey((int)7, (Exp.Type)expType, (Exp)Exp.val((String)FilterOperation.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)FilterOperation.getField(qualifierMap)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr));
        }
        return MapExp.getByKey((int)7, (Exp.Type)expType, (Exp)Exp.val((String)FilterOperation.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)FilterOperation.getField(qualifierMap)), (CTX[])new CTX[0]);
    }

    private static Exp getFilterExpMapValEqOrFail(Map<String, Object> qualifierMap, BinaryOperator<Exp> operator) {
        return FilterOperation.getMapValEqOrFail(qualifierMap, operator, "MAP_VAL_EQ_BY_KEY");
    }

    private static Exp getFilterExpMapValNotEqOrFail(Map<String, Object> qualifierMap, BinaryOperator<Exp> operator) {
        return FilterOperation.getMapValEqOrFail(qualifierMap, operator, "MAP_VAL_NOTEQ_BY_KEY");
    }

    private static Exp getMapValEqOrFail(Map<String, Object> qualifierMap, BinaryOperator<Exp> operator, String opName) {
        boolean useCtx;
        String[] dotPathArr = FilterOperation.getDotPathArray(FilterOperation.getDotPath(qualifierMap), opName + " filter expression: dotPath has not been set");
        boolean bl = useCtx = dotPathArr.length > 2;
        if (FilterOperation.getValue1(qualifierMap) instanceof Value.BoolIntValue) {
            qualifierMap.put("value1", new Value.BooleanValue(((Boolean)FilterOperation.getValue1(qualifierMap).getObject()).booleanValue()));
        }
        Value value1 = FilterOperation.getValue1(qualifierMap);
        return switch (value1.getType()) {
            case 1 -> FilterOperation.getMapValEqExp(qualifierMap, Exp.Type.INT, value1.toLong(), dotPathArr, operator, useCtx);
            case 3 -> {
                if (FilterOperation.ignoreCase(qualifierMap).booleanValue()) {
                    throw new UnsupportedOperationException(opName + " FilterExpression: case insensitive comparison is not supported");
                }
                yield FilterOperation.getMapValEqExp(qualifierMap, Exp.Type.STRING, value1.toString(), dotPathArr, operator, useCtx);
            }
            case 17 -> FilterOperation.getMapValEqExp(qualifierMap, Exp.Type.BOOL, value1.getObject(), dotPathArr, operator, useCtx);
            case 20 -> FilterOperation.getMapValEqExp(qualifierMap, Exp.Type.LIST, value1.getObject(), dotPathArr, operator, useCtx);
            case 19 -> FilterOperation.getMapValEqExp(qualifierMap, Exp.Type.MAP, value1.getObject(), dotPathArr, operator, useCtx);
            default -> throw new UnsupportedOperationException(opName + " FilterExpression unsupported type: " + value1.getClass().getSimpleName());
        };
    }

    private static Exp getMapValEqExp(Map<String, Object> qualifierMap, Exp.Type expType, Object value, String[] dotPathArr, BinaryOperator<Exp> operator, boolean useCtx) {
        Exp mapExp = FilterOperation.getMapValEq(qualifierMap, expType, dotPathArr, useCtx);
        return (Exp)operator.apply(mapExp, FilterOperation.toExp(value));
    }

    private static Exp getMapValEq(Map<String, Object> qualifierMap, Exp.Type expType, String[] dotPathArr, boolean useCtx) {
        if (useCtx) {
            return MapExp.getByKey((int)7, (Exp.Type)expType, (Exp)Exp.val((String)FilterOperation.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)FilterOperation.getField(qualifierMap)), (CTX[])FilterOperation.dotPathToCtxMapKeys(dotPathArr));
        }
        return MapExp.getByKey((int)7, (Exp.Type)expType, (Exp)Exp.val((String)FilterOperation.getValue2(qualifierMap).toString()), (Exp)Exp.mapBin((String)FilterOperation.getField(qualifierMap)), (CTX[])new CTX[0]);
    }

    private static Exp getFilterExp(Exp exp, String field, BinaryOperator<Exp> operator, Function<String, Exp> binExp) {
        return (Exp)operator.apply(binExp.apply(field), exp);
    }

    private static String[] getDotPathArray(String dotPath, String errMsg) {
        if (StringUtils.hasLength((String)dotPath)) {
            return dotPath.split("\\.");
        }
        throw new IllegalStateException(errMsg);
    }

    private static CTX[] dotPathToCtxMapKeys(String[] dotPathArray) {
        return (CTX[])Arrays.stream(dotPathArray).map(str -> CTX.mapKey((Value)Value.get((String)str))).skip(1L).limit((long)dotPathArray.length - 2L).toArray(CTX[]::new);
    }

    private static Exp toExp(Object value) {
        Exp res;
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            res = Exp.val((long)((Number)value).longValue());
        } else if (value instanceof Float || value instanceof Double) {
            res = Exp.val((double)((Number)value).doubleValue());
        } else if (value instanceof String) {
            res = Exp.val((String)((String)value));
        } else if (value instanceof Boolean) {
            res = Exp.val((boolean)((Boolean)value));
        } else if (value instanceof Map) {
            res = Exp.val((Map)((Map)value));
        } else if (value instanceof List) {
            res = Exp.val((List)((List)value));
        } else if (value instanceof byte[]) {
            res = Exp.val((byte[])((byte[])value));
        } else if (value instanceof Calendar) {
            res = Exp.val((Calendar)((Calendar)value));
        } else if (value instanceof Value.NullValue) {
            res = Exp.nil();
        } else {
            throw new UnsupportedOperationException("Unsupported type for converting: " + value.getClass().getCanonicalName());
        }
        return res;
    }

    protected static String getField(Map<String, Object> qualifierMap) {
        return (String)qualifierMap.get("field");
    }

    protected static Boolean ignoreCase(Map<String, Object> qualifierMap) {
        return (Boolean)qualifierMap.getOrDefault("ignoreCase", false);
    }

    protected static int regexFlags(Map<String, Object> qualifierMap) {
        return FilterOperation.ignoreCase(qualifierMap) != false ? 2 : 0;
    }

    protected static Value getValue1(Map<String, Object> qualifierMap) {
        return Value.get((Object)qualifierMap.get("value1"));
    }

    protected static Value getValue2(Map<String, Object> qualifierMap) {
        return Value.get((Object)qualifierMap.get("value2"));
    }

    protected static Value getValue3(Map<String, Object> qualifierMap) {
        return (Value)qualifierMap.get("value3");
    }

    protected static String getDotPath(Map<String, Object> qualifierMap) {
        return (String)qualifierMap.get("dotPath");
    }

    protected static MappingAerospikeConverter getConverter(Map<String, Object> qualifierMap) {
        return (MappingAerospikeConverter)qualifierMap.get("converter");
    }

    public abstract Exp filterExp(Map<String, Object> var1);

    public abstract Filter sIndexFilter(Map<String, Object> var1);

    protected Filter collectionContains(IndexCollectionType collectionType, Map<String, Object> qualifierMap) {
        Value val = FilterOperation.getValue1(qualifierMap);
        int valType = val.getType();
        return switch (valType) {
            case 1 -> Filter.contains((String)FilterOperation.getField(qualifierMap), (IndexCollectionType)collectionType, (long)val.toLong(), (CTX[])new CTX[0]);
            case 3 -> Filter.contains((String)FilterOperation.getField(qualifierMap), (IndexCollectionType)collectionType, (String)val.toString(), (CTX[])new CTX[0]);
            default -> null;
        };
    }

    protected Filter collectionRange(IndexCollectionType collectionType, Map<String, Object> qualifierMap) {
        return Filter.range((String)FilterOperation.getField(qualifierMap), (IndexCollectionType)collectionType, (long)FilterOperation.getValue1(qualifierMap).toLong(), (long)FilterOperation.getValue2(qualifierMap).toLong(), (CTX[])new CTX[0]);
    }

    protected Filter geoWithinRadius(IndexCollectionType collectionType, Map<String, Object> qualifierMap) {
        return Filter.geoContains((String)FilterOperation.getField(qualifierMap), (String)FilterOperation.getValue1(qualifierMap).toString(), (CTX[])new CTX[0]);
    }

    static {
        dualFilterOperations = Arrays.asList(MAP_VAL_EQ_BY_KEY, MAP_VAL_GT_BY_KEY, MAP_VAL_GTEQ_BY_KEY, MAP_VAL_LT_BY_KEY, MAP_VAL_LTEQ_BY_KEY, MAP_VAL_BETWEEN_BY_KEY);
    }
}

