/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.ResultSet;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRecordIterator
implements Iterator<KeyRecord>,
Closeable {
    private static final String META_DATA = "meta_data";
    private static final String SET_NAME = "set_name";
    private static final String DIGEST = "digest";
    private static final String EXPIRY = "expiry";
    private static final String GENERATION = "generation";
    private static final Logger log = LoggerFactory.getLogger(KeyRecordIterator.class);
    private final String namespace;
    private final Integer closeLock = 0;
    private RecordSet recordSet;
    private ResultSet resultSet;
    private Iterator<KeyRecord> recordSetIterator;
    private Iterator<Object> resultSetIterator;
    private KeyRecord singleRecord;

    public KeyRecordIterator(String namespace) {
        this.namespace = namespace;
    }

    public KeyRecordIterator(String namespace, KeyRecord singleRecord) {
        this(namespace);
        this.singleRecord = singleRecord;
    }

    public KeyRecordIterator(String namespace, RecordSet recordSet) {
        this(namespace);
        this.recordSet = recordSet;
        this.recordSetIterator = recordSet.iterator();
    }

    public KeyRecordIterator(String namespace, ResultSet resultSet) {
        this(namespace);
        this.resultSet = resultSet;
        this.resultSetIterator = resultSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Integer n = this.closeLock;
        synchronized (n) {
            if (this.recordSet != null) {
                this.recordSet.close();
            }
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.singleRecord != null) {
                this.singleRecord = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.recordSetIterator != null) {
            return this.recordSetIterator.hasNext();
        }
        if (this.resultSetIterator != null) {
            return this.resultSetIterator.hasNext();
        }
        return this.singleRecord != null;
    }

    @Override
    public KeyRecord next() {
        KeyRecord keyRecord = null;
        if (this.recordSetIterator != null) {
            keyRecord = this.recordSetIterator.next();
        } else if (this.resultSetIterator != null) {
            Map map = (Map)this.resultSetIterator.next();
            Map meta = (Map)map.get(META_DATA);
            map.remove(META_DATA);
            HashMap binMap = new HashMap(map);
            if (log.isDebugEnabled()) {
                for (Map.Entry entry : map.entrySet()) {
                    log.debug("{} = {}", entry.getKey(), entry.getValue());
                }
            }
            Long generation = (Long)meta.get(GENERATION);
            Long ttl = (Long)meta.get(EXPIRY);
            Record record = new Record(binMap, generation.intValue(), ttl.intValue());
            Key key = new Key(this.namespace, (byte[])meta.get(DIGEST), (String)meta.get(SET_NAME), null);
            keyRecord = new KeyRecord(key, record);
        } else if (this.singleRecord != null) {
            keyRecord = this.singleRecord;
            this.singleRecord = null;
        }
        return keyRecord;
    }

    @Override
    public void remove() {
    }

    public String toString() {
        return this.namespace;
    }
}

