/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.Key;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.Statement;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import java.util.Objects;
import org.springframework.data.aerospike.query.FilterExpressionsBuilder;
import org.springframework.data.aerospike.query.KeyQualifier;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.query.StatementBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorQueryEngine {
    private final IAerospikeReactorClient client;
    private final StatementBuilder statementBuilder;
    private final FilterExpressionsBuilder filterExpressionsBuilder;
    private final QueryPolicy queryPolicy;
    private boolean scansEnabled = false;

    public ReactorQueryEngine(IAerospikeReactorClient client, StatementBuilder statementBuilder, FilterExpressionsBuilder filterExpressionsBuilder, QueryPolicy queryPolicy) {
        this.client = client;
        this.statementBuilder = statementBuilder;
        this.filterExpressionsBuilder = filterExpressionsBuilder;
        this.queryPolicy = queryPolicy;
    }

    public Flux<KeyRecord> select(String namespace, String set, Filter filter, Qualifier ... qualifiers) {
        return this.select(namespace, set, null, filter, qualifiers);
    }

    public Flux<KeyRecord> select(String namespace, String set, String[] binNames, Filter filter, Qualifier ... qualifiers) {
        Qualifier qualifier;
        if (qualifiers != null && qualifiers.length == 1 && (qualifier = qualifiers[0]) instanceof KeyQualifier) {
            KeyQualifier kq = (KeyQualifier)qualifier;
            Key key = kq.makeKey(namespace, set);
            return Flux.from(this.getRecord(null, key, binNames)).filter(keyRecord -> Objects.nonNull(keyRecord.record));
        }
        Statement statement = this.statementBuilder.build(namespace, set, filter, qualifiers, binNames);
        QueryPolicy localQueryPolicy = new QueryPolicy(this.queryPolicy);
        localQueryPolicy.filterExp = this.filterExpressionsBuilder.build(qualifiers);
        if (!this.scansEnabled && statement.getFilter() == null) {
            return Flux.error((Throwable)new IllegalStateException("Query without a filter will initiate a scan. Since scans are potentially dangerous operations, they are disabled by default in spring-data-aerospike. If you still need to use them, enable them via `scansEnabled` property in `org.springframework.data.aerospike.config.AerospikeDataSettings`."));
        }
        return this.client.query(localQueryPolicy, statement);
    }

    private Mono<KeyRecord> getRecord(Policy policy, Key key, String[] binNames) {
        if (binNames == null || binNames.length == 0) {
            return this.client.get(policy, key);
        }
        return this.client.get(policy, key, binNames);
    }

    public void setScansEnabled(boolean scansEnabled) {
        this.scansEnabled = scansEnabled;
    }

    public FilterExpressionsBuilder getFilterExpressionsBuilder() {
        return this.filterExpressionsBuilder;
    }
}

