/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.query.Filter;
import com.aerospike.client.query.Statement;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.query.cache.IndexesCache;
import org.springframework.data.aerospike.query.model.IndexedField;

public class StatementBuilder {
    private final IndexesCache indexesCache;

    public StatementBuilder(IndexesCache indexesCache) {
        this.indexesCache = indexesCache;
    }

    public Statement build(String namespace, String set, Filter filter, Qualifier[] qualifiers) {
        return this.build(namespace, set, filter, qualifiers, null);
    }

    public Statement build(String namespace, String set, Filter filter, Qualifier[] qualifiers, String[] binNames) {
        Statement stmt = new Statement();
        stmt.setNamespace(namespace);
        stmt.setSetName(set);
        if (binNames != null && binNames.length != 0) {
            stmt.setBinNames(binNames);
        }
        if (filter != null) {
            stmt.setFilter(filter);
        }
        if (qualifiers != null && qualifiers.length != 0) {
            this.updateStatement(stmt, qualifiers);
        }
        return stmt;
    }

    private void updateStatement(Statement stmt, Qualifier[] qualifiers) {
        block0: for (Qualifier qualifier : qualifiers) {
            Filter filter;
            if (qualifier == null) continue;
            if (qualifier.getOperation() == FilterOperation.AND) {
                for (Qualifier q : qualifier.getQualifiers()) {
                    Filter filter2;
                    if (q == null || !this.isIndexedBin(stmt, q) || (filter2 = q.asFilter()) == null) continue;
                    stmt.setFilter(filter2);
                    q.asFilter(true);
                    continue block0;
                }
                continue;
            }
            if (!this.isIndexedBin(stmt, qualifier) || (filter = qualifier.asFilter()) == null) continue;
            stmt.setFilter(filter);
            qualifier.asFilter(true);
            if (qualifiers.length != 1) break;
            return;
        }
    }

    private boolean isIndexedBin(Statement stmt, Qualifier qualifier) {
        if (qualifier.getField() == null) {
            return false;
        }
        return this.indexesCache.hasIndexFor(new IndexedField(stmt.getNamespace(), stmt.getSetName(), qualifier.getField()));
    }
}

