/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import org.springframework.data.aerospike.query.cache.IndexInfoParser;
import org.springframework.data.aerospike.query.model.Index;
import org.springframework.data.aerospike.query.model.IndexKey;
import org.springframework.data.aerospike.query.model.IndexesInfo;

public class InternalIndexOperations {
    private static final String SINDEX_WITH_BASE64 = "sindex-list:;b64=true";
    private final IndexInfoParser indexInfoParser;

    public InternalIndexOperations(IndexInfoParser indexInfoParser) {
        this.indexInfoParser = indexInfoParser;
    }

    private static IndexKey getIndexKey(Index index) {
        return new IndexKey(index.getNamespace(), index.getSet(), index.getBin(), index.getType(), index.getCollectionType(), index.getCTX());
    }

    public IndexesInfo parseIndexesInfo(String infoResponse) {
        if (infoResponse.isEmpty()) {
            return IndexesInfo.empty();
        }
        return IndexesInfo.of(Arrays.stream(infoResponse.split(";")).map(this.indexInfoParser::parse).collect(Collectors.collectingAndThen(Collectors.toMap(InternalIndexOperations::getIndexKey, index -> index), Collections::unmodifiableMap)));
    }

    public String buildGetIndexesCommand() {
        return SINDEX_WITH_BASE64;
    }
}

