/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.aerospike.core.AerospikeInternalOperations;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.core.AerospikeTemplate;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeCriteria;
import org.springframework.data.aerospike.repository.query.BaseAerospikePartTreeQuery;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;

public class AerospikePartTreeQuery
extends BaseAerospikePartTreeQuery {
    private final AerospikeOperations operations;
    private final AerospikeInternalOperations internalOperations;

    public AerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evalContextProvider, AerospikeTemplate aerospikeTemplate, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evalContextProvider, queryCreator);
        this.operations = aerospikeTemplate;
        this.internalOperations = aerospikeTemplate;
    }

    public Object execute(Object[] parameters) {
        Stream<?> result;
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Query query = this.prepareQuery(parameters, accessor);
        Class<?> targetClass = this.getTargetClass(accessor);
        if (parameters != null && parameters.length > 0) {
            AerospikeCriteria criteria = query.getAerospikeCriteria();
            Qualifier[] qualifiers = AerospikePartTreeQuery.getQualifiers(criteria);
            if (AerospikePartTreeQuery.isIdQuery(criteria)) {
                return this.runIdQuery(this.entityClass, targetClass, AerospikePartTreeQuery.getIdValue(qualifiers), new Qualifier[0]);
            }
            if (AerospikePartTreeQuery.hasIdQualifier(criteria)) {
                return this.runIdQuery(this.entityClass, targetClass, AerospikePartTreeQuery.getIdValue(AerospikePartTreeQuery.getIdQualifier(qualifiers)), AerospikePartTreeQuery.excludeIdQualifier(qualifiers));
            }
        }
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            result = this.findByQuery(query, targetClass);
            List<?> results = result.toList();
            Pageable pageable = accessor.getPageable();
            long numberOfAllResults = this.operations.count(query, this.entityClass);
            if (this.queryMethod.isSliceQuery()) {
                boolean hasNext = numberOfAllResults > (long)pageable.getPageSize() * (pageable.getOffset() + 1L);
                return new SliceImpl(results, pageable, hasNext);
            }
            return new PageImpl(results, pageable, numberOfAllResults);
        }
        if (this.queryMethod.isStreamQuery()) {
            return this.findByQuery(query, targetClass);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.findByQuery(query, targetClass).collect(Collectors.toList());
        }
        if (this.queryMethod.isQueryForEntity()) {
            result = this.findByQuery(query, targetClass);
            return result.findFirst().orElse(null);
        }
        throw new UnsupportedOperationException("Query method " + this.queryMethod.getNamedQueryName() + " is not supported");
    }

    @Override
    protected Object findById(Object obj, Class<?> entityClass, Class<?> targetClass, Qualifier ... qualifiers) {
        return this.internalOperations.findByIdInternal(obj, entityClass, targetClass, qualifiers);
    }

    @Override
    protected Object findByIds(Iterable<?> iterable, Class<?> entityClass, Class<?> targetClass, Qualifier ... qualifiers) {
        return this.internalOperations.findByIdsInternal(IterableConverter.toList(iterable), entityClass, targetClass, qualifiers);
    }

    private Stream<?> findByQuery(Query query, Class<?> targetClass) {
        if (targetClass != null && targetClass != this.entityClass) {
            return this.operations.find(query, this.entityClass, targetClass);
        }
        return this.operations.find(query, this.entityClass);
    }
}

