/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.AerospikeCustomConversions;
import org.springframework.data.aerospike.convert.AerospikeTypeAliasAccessor;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeCriteria;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.TypeInformation;

public class AerospikeQueryCreator
extends AbstractQueryCreator<Query, AerospikeCriteria> {
    private static final Logger LOG = LoggerFactory.getLogger(AerospikeQueryCreator.class);
    private final AerospikeMappingContext context;
    private final AerospikeCustomConversions conversions = new AerospikeCustomConversions(Collections.emptyList());
    private final MappingAerospikeConverter converter = this.getMappingAerospikeConverter(this.conversions);

    public AerospikeQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
        this.context = new AerospikeMappingContext();
    }

    public AerospikeQueryCreator(PartTree tree, ParameterAccessor parameters, AerospikeMappingContext context) {
        super(tree, parameters);
        this.context = context;
    }

    private MappingAerospikeConverter getMappingAerospikeConverter(AerospikeCustomConversions conversions) {
        MappingAerospikeConverter converter = new MappingAerospikeConverter(new AerospikeMappingContext(), conversions, new AerospikeTypeAliasAccessor());
        converter.afterPropertiesSet();
        return converter;
    }

    protected AerospikeCriteria create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        return this.create(part, property, iterator);
    }

    private AerospikeCriteria create(Part part, AerospikePersistentProperty property, Iterator<?> parameters) {
        Object v1 = null;
        if (parameters.hasNext()) {
            v1 = parameters.next();
        }
        v1 = this.convertIfNecessary(v1);
        return switch (part.getType()) {
            case Part.Type.AFTER, Part.Type.GREATER_THAN -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.GT);
            case Part.Type.GREATER_THAN_EQUAL -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.GTEQ);
            case Part.Type.BEFORE, Part.Type.LESS_THAN -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.LT);
            case Part.Type.LESS_THAN_EQUAL -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.LTEQ);
            case Part.Type.BETWEEN -> this.getCriteria(part, property, v1, this.convertIfNecessary(parameters.next()), parameters, FilterOperation.BETWEEN);
            case Part.Type.LIKE, Part.Type.REGEX -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.LIKE);
            case Part.Type.STARTING_WITH -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.STARTS_WITH);
            case Part.Type.ENDING_WITH -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.ENDS_WITH);
            case Part.Type.CONTAINING -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.CONTAINING);
            case Part.Type.NOT_CONTAINING -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.NOT_CONTAINING);
            case Part.Type.WITHIN -> {
                v1 = Value.get((String)String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", v1, parameters.next(), parameters.next()));
                yield this.getCriteria(part, property, v1, parameters.next(), parameters, FilterOperation.GEO_WITHIN);
            }
            case Part.Type.SIMPLE_PROPERTY -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.EQ);
            case Part.Type.NEGATING_SIMPLE_PROPERTY -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.NOTEQ);
            case Part.Type.IN -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.IN);
            case Part.Type.NOT_IN -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.NOT_IN);
            case Part.Type.TRUE -> this.getCriteria(part, property, true, null, parameters, FilterOperation.EQ);
            case Part.Type.FALSE -> this.getCriteria(part, property, false, null, parameters, FilterOperation.EQ);
            case Part.Type.EXISTS, Part.Type.IS_NOT_NULL -> this.getCriteria(part, property, null, null, parameters, FilterOperation.IS_NOT_NULL);
            case Part.Type.IS_NULL -> this.getCriteria(part, property, null, null, parameters, FilterOperation.IS_NULL);
            default -> throw new IllegalArgumentException("Unsupported keyword '" + part.getType() + "'");
        };
    }

    private Object convertIfNecessary(Object obj) {
        if (obj == null || obj instanceof CriteriaDefinition.AerospikeMapCriteria) {
            return obj;
        }
        Object value = obj;
        TypeInformation valueType = TypeInformation.of(value.getClass());
        return this.converter.toWritableValue(value, valueType);
    }

    /*
     * Enabled aggressive block sorting
     */
    public AerospikeCriteria getCriteria(Part part, AerospikePersistentProperty property, Object value1, Object value2, Iterator<?> parameters, FilterOperation op) {
        Qualifier.QualifierBuilder qb = new Qualifier.QualifierBuilder();
        String fieldName = part.getProperty().getSegment();
        Object dotPath = null;
        Value value3 = null;
        if (property.isCollectionLike()) {
            ArrayList<Object> params = new ArrayList<Object>();
            parameters.forEachRemaining(params::add);
            if (!params.isEmpty()) {
                Object nextParam = params.get(params.size() - 1);
                if (op != FilterOperation.CONTAINING) return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
                if (nextParam instanceof CriteriaDefinition.AerospikeMapCriteria) return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
                op = FilterOperation.LIST_VAL_CONTAINING;
                params.add(0, value1);
                return this.aerospikeCriteriaAndConcatenated(params, qb, part, fieldName, op, (String)dotPath);
            }
            if (value1 instanceof Collection) return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
            op = this.getCorrespondingListFilterOperationOrFail(op);
            return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
        }
        if (property.isMap()) {
            List<Object> params = new ArrayList<Object>();
            parameters.forEachRemaining(params::add);
            if (params.size() == 1) {
                Object nextParam = this.convertIfNecessary(params.get(0));
                if (op == FilterOperation.CONTAINING) {
                    if (!(nextParam instanceof CriteriaDefinition.AerospikeMapCriteria)) {
                        op = FilterOperation.MAP_VAL_EQ_BY_KEY;
                        dotPath = part.getProperty().toDotPath() + "." + Value.get((Object)value1);
                        this.setQbValuesForMapByKey(qb, value1, nextParam);
                        return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
                    }
                    CriteriaDefinition.AerospikeMapCriteria onMap = (CriteriaDefinition.AerospikeMapCriteria)((Object)nextParam);
                    switch (onMap) {
                        case KEY: {
                            op = FilterOperation.MAP_KEYS_CONTAIN;
                            return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
                        }
                        case VALUE: {
                            op = FilterOperation.MAP_VALUES_CONTAIN;
                            return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
                        }
                    }
                    return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
                }
                if (op == FilterOperation.NOT_CONTAINING) {
                    if (!(nextParam instanceof CriteriaDefinition.AerospikeMapCriteria)) {
                        op = FilterOperation.MAP_VAL_NOTEQ_BY_KEY;
                        dotPath = part.getProperty().toDotPath() + "." + Value.get((Object)value1);
                        this.setQbValuesForMapByKey(qb, value1, nextParam);
                        return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
                    }
                    CriteriaDefinition.AerospikeMapCriteria onMap = (CriteriaDefinition.AerospikeMapCriteria)((Object)nextParam);
                    switch (onMap) {
                        case KEY: {
                            op = FilterOperation.MAP_KEYS_NOT_CONTAIN;
                            return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
                        }
                        case VALUE: {
                            op = FilterOperation.MAP_VALUES_NOT_CONTAIN;
                            return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
                        }
                    }
                    return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
                }
                if (op == FilterOperation.BETWEEN) {
                    op = this.getCorrespondingMapValueFilterOperationOrFail(op);
                    qb.setValue2(Value.get((Object)value1));
                    qb.setValue1(Value.get((Object)value2));
                    qb.setValue3(Value.get((Object)nextParam));
                } else {
                    if (op == FilterOperation.EQ) {
                        throw new IllegalArgumentException("Unsupported arguments '" + value1 + "' and '" + nextParam + "', expecting Map argument in findByMapEquals queries");
                    }
                    op = this.getCorrespondingMapValueFilterOperationOrFail(op);
                    this.setQbValuesForMapByKey(qb, value1, nextParam);
                }
                dotPath = part.getProperty().toDotPath() + "." + Value.get((Object)value1);
                return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
            }
            if (params.isEmpty()) {
                if (op == FilterOperation.BETWEEN) return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
                value2 = Value.get((String)property.getFieldName());
                return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
            }
            if (op != FilterOperation.CONTAINING) {
                String paramsString = params.stream().map(Object::toString).collect(Collectors.joining(", "));
                throw new IllegalArgumentException("Expected not more than 2 arguments (propertyType: Map, filterOperation: " + op + "),  got " + (params.size() + 1) + " instead: '" + value1 + ", " + paramsString + "'");
            }
            Object e = params.get(params.size() - 1);
            if (e instanceof CriteriaDefinition.AerospikeMapCriteria) {
                CriteriaDefinition.AerospikeMapCriteria onMap = (CriteriaDefinition.AerospikeMapCriteria)((Object)e);
                switch (onMap) {
                    case KEY: {
                        op = FilterOperation.MAP_KEYS_CONTAIN;
                        break;
                    }
                    case VALUE: {
                        op = FilterOperation.MAP_VALUES_CONTAIN;
                        break;
                    }
                    case VALUE_CONTAINING: {
                        op = FilterOperation.MAP_VAL_CONTAINING_BY_KEY;
                        break;
                    }
                }
                params = params.stream().limit(params.size() - 1).collect(Collectors.toList());
            } else {
                op = FilterOperation.MAP_VAL_EQ_BY_KEY;
                dotPath = part.getProperty().toDotPath() + "." + Value.get((Object)value1);
            }
            params.add(0, value1);
            if (op != FilterOperation.MAP_VAL_CONTAINING_BY_KEY) {
                if (op != FilterOperation.MAP_VAL_EQ_BY_KEY) return this.aerospikeCriteriaAndConcatenated(params, qb, part, fieldName, op, (String)dotPath);
            }
            if (params.size() > 2) {
                if ((params.size() & 1) == 0) return this.aerospikeCriteriaAndConcatenated(params, qb, part, fieldName, op, (String)dotPath, true);
                throw new IllegalArgumentException("FindByMapContaining: expected either 1, 2 or even number of key/value arguments, instead got " + params.size());
            }
            if (params.size() != 2) return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
            this.setQbValuesForMapByKey(qb, params.get(0), params.get(1));
            return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
        }
        if (!part.getProperty().hasNext()) {
            if (!this.isPojo(part)) return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
            if (op == FilterOperation.BETWEEN) return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
            value2 = Value.get((String)property.getFieldName());
            return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
        }
        if (op == FilterOperation.BETWEEN) {
            value3 = Value.get((Object)value2);
        } else if (op == FilterOperation.IS_NOT_NULL || op == FilterOperation.IS_NULL) {
            value1 = Value.get((String)property.getFieldName());
        }
        op = this.getCorrespondingMapValueFilterOperationOrFail(op);
        value2 = Value.get((String)property.getFieldName());
        dotPath = part.getProperty().toDotPath();
        return new AerospikeCriteria(this.setQualifierBuilderValues(qb, fieldName, op, part, value1, value2, value3, (String)dotPath));
    }

    private AerospikeCriteria aerospikeCriteriaAndConcatenated(List<Object> params, Qualifier.QualifierBuilder qb, Part part, String fieldName, FilterOperation op, String dotPath) {
        return this.aerospikeCriteriaAndConcatenated(params, qb, part, fieldName, op, dotPath, false);
    }

    private AerospikeCriteria aerospikeCriteriaAndConcatenated(List<Object> params, Qualifier.QualifierBuilder qb, Part part, String fieldName, FilterOperation op, String dotPath, boolean containingMapKeyValuePairs) {
        if (containingMapKeyValuePairs) {
            Qualifier[] qualifiers = new Qualifier[params.size() / 2];
            int j = 0;
            for (int i = 0; i < params.size(); i += 2) {
                this.setQbValuesForMapByKey(qb, params.get(i), params.get(i + 1));
                Qualifier qualifier = this.setQualifierBuilderValues(qb, fieldName, op, part, params.get(i), null, null, dotPath).build();
                qualifiers[j++] = qualifier;
            }
            return new AerospikeCriteria(new Qualifier.QualifierBuilder().setQualifiers(qualifiers).setFilterOperation(FilterOperation.AND));
        }
        Qualifier[] qualifiers = new Qualifier[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            Qualifier qualifier;
            this.setQbValuesForMapByKey(qb, params.get(i), params.get(i));
            qualifiers[i] = qualifier = this.setQualifierBuilderValues(qb, fieldName, op, part, params.get(i), null, null, dotPath).build();
        }
        return new AerospikeCriteria(new Qualifier.QualifierBuilder().setQualifiers(qualifiers).setFilterOperation(FilterOperation.AND));
    }

    private Qualifier.QualifierBuilder setQualifierBuilderValues(Qualifier.QualifierBuilder qb, String fieldName, FilterOperation op, Part part, Object value1, Object value2, Object value3, String dotPath) {
        qb.setField(fieldName).setFilterOperation(op).setIgnoreCase(this.ignoreCaseToBoolean(part)).setConverter(this.converter);
        this.setNotNullQbValues(qb, value1, value2, value3, dotPath);
        return qb;
    }

    private FilterOperation getCorrespondingMapValueFilterOperationOrFail(FilterOperation op) {
        try {
            return FilterOperation.valueOf("MAP_VAL_" + op + "_BY_KEY");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot find corresponding MAP_VAL_..._BY_KEY FilterOperation for '" + op + "'");
        }
    }

    private FilterOperation getCorrespondingListFilterOperationOrFail(FilterOperation op) {
        try {
            return FilterOperation.valueOf("LIST_VAL_" + op);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot find corresponding LIST_VAL_... FilterOperation for '" + op + "'");
        }
    }

    private void setNotNullQbValues(Qualifier.QualifierBuilder qb, Object v1, Object v2, Object v3, String dotPath) {
        if (v1 != null && !qb.hasValue1()) {
            qb.setValue1(Value.get((Object)v1));
        }
        if (v2 != null && !qb.hasValue2()) {
            qb.setValue2(Value.get((Object)v2));
        }
        if (v3 != null && !qb.hasValue3()) {
            qb.setValue3(Value.get((Object)v3));
        }
        if (dotPath != null && !qb.hasDotPath()) {
            qb.setDotPath(dotPath);
        }
    }

    private void setQbValuesForMapByKey(Qualifier.QualifierBuilder qb, Object key, Object value) {
        qb.setValue1(Value.get((Object)value));
        qb.setValue2(Value.get((Object)key));
    }

    private boolean isPojo(Part part) {
        TypeInformation type = TypeInformation.of((Class)part.getProperty().getType());
        return !this.conversions.isSimpleType(part.getProperty().getType()) && !type.isCollectionLike();
    }

    protected AerospikeCriteria and(Part part, AerospikeCriteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        return new AerospikeCriteria(new Qualifier.QualifierBuilder().setFilterOperation(FilterOperation.AND).setQualifiers(base, this.create(part, property, iterator)));
    }

    protected AerospikeCriteria or(AerospikeCriteria base, AerospikeCriteria criteria) {
        return new AerospikeCriteria(new Qualifier.QualifierBuilder().setFilterOperation(FilterOperation.OR).setQualifiers(base, criteria));
    }

    protected Query complete(AerospikeCriteria criteria, Sort sort) {
        Query query;
        Query query2 = query = criteria == null ? null : new Query(criteria).with(sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created query {}", (Object)query);
        }
        return query;
    }

    private boolean ignoreCaseToBoolean(Part part) {
        return switch (part.shouldIgnoreCase()) {
            case Part.IgnoreCaseType.WHEN_POSSIBLE -> {
                if (part.getProperty().getType() == String.class) {
                    yield true;
                }
                yield false;
            }
            case Part.IgnoreCaseType.ALWAYS -> true;
            default -> false;
        };
    }
}

