/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeCriteria;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.util.ClassUtils;

public abstract class BaseAerospikePartTreeQuery
implements RepositoryQuery {
    protected final QueryMethod queryMethod;
    protected final Class<?> entityClass;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;

    protected BaseAerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evalContextProvider, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        this.queryMethod = queryMethod;
        this.evaluationContextProvider = evalContextProvider;
        this.queryCreator = queryCreator;
        this.entityClass = queryMethod.getEntityInformation().getJavaType();
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected Query prepareQuery(Object[] parameters, ParametersParameterAccessor accessor) {
        PartTree tree = new PartTree(this.queryMethod.getName(), this.entityClass);
        Query baseQuery = this.createQuery(accessor, tree);
        AerospikeCriteria criteria = baseQuery.getAerospikeCriteria();
        Query query = new Query(criteria);
        if (accessor.getPageable().isPaged()) {
            query.setOffset(accessor.getPageable().getOffset());
            query.setRows(accessor.getPageable().getPageSize());
        } else if (tree.isLimiting()) {
            query.limit(tree.getMaxResults());
        } else {
            query.setOffset(-1L);
            query.setRows(-1);
        }
        query.setDistinct(tree.isDistinct());
        if (accessor.getSort().isSorted()) {
            query.setSort(accessor.getSort());
        } else {
            query.setSort(baseQuery.getSort());
        }
        CriteriaDefinition criteriaDefinition = query.getCriteria();
        if (criteriaDefinition instanceof SpelExpression) {
            SpelExpression spelExpression = (SpelExpression)criteriaDefinition;
            EvaluationContext context = this.evaluationContextProvider.getEvaluationContext(this.queryMethod.getParameters(), parameters);
            spelExpression.setEvaluationContext(context);
        }
        return query;
    }

    Class<?> getTargetClass(ParametersParameterAccessor accessor) {
        if (accessor.getParameters().hasDynamicProjection()) {
            return accessor.findDynamicProjection();
        }
        if (this.queryMethod.getReturnedObjectType() != this.queryMethod.getEntityInformation().getJavaType()) {
            return this.queryMethod.getReturnedObjectType();
        }
        return this.queryMethod.getEntityInformation().getJavaType();
    }

    public Query createQuery(ParametersParameterAccessor accessor, PartTree tree) {
        Constructor constructor = ClassUtils.getConstructorIfAvailable(this.queryCreator, (Class[])new Class[]{PartTree.class, ParameterAccessor.class});
        return (Query)((AbstractQueryCreator)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{tree, accessor})).createQuery();
    }

    protected static boolean isIdQuery(AerospikeCriteria criteria) {
        return Objects.equals(criteria.getField(), "id");
    }

    protected static boolean hasIdQualifier(AerospikeCriteria criteria) {
        Object qualifiers = criteria.get("qualifiers");
        return qualifiers != null && qualifiers.getClass().isArray() && Arrays.stream((Qualifier[])qualifiers).anyMatch(qualifier -> qualifier.getField().equals("id"));
    }

    protected static Qualifier[] excludeIdQualifier(Qualifier[] qualifiers) {
        return (Qualifier[])Arrays.stream(qualifiers).filter(qualifier -> !qualifier.getField().equals("id")).toArray(Qualifier[]::new);
    }

    protected static Qualifier[] getQualifiers(AerospikeCriteria criteria) {
        if (criteria == null) {
            return null;
        }
        if (criteria.getQualifiers() == null) {
            return new Qualifier[]{criteria};
        }
        return criteria.getQualifiers();
    }

    protected static Qualifier getIdQualifier(Qualifier[] qualifiers) {
        return Arrays.stream(qualifiers).filter(qualifier -> qualifier.getField().equals("id")).findFirst().orElseThrow(() -> new IllegalArgumentException("Qualifier with 'id' field was not found"));
    }

    protected static Object getIdValue(Qualifier ... qualifiers) {
        return Arrays.stream(qualifiers).filter(qualifier -> qualifier.getField().equals("id")).map(qualifier -> qualifier.getValue1().getObject()).findFirst().orElseThrow(() -> new IllegalStateException("Value of 'id' field in a Qualifier was not found"));
    }

    protected Object runIdQuery(Class<?> sourceClass, Class<?> targetClass, Object ids, Qualifier ... qualifiers) {
        if (ids == null) {
            throw new IllegalStateException("Parameters accessor value is null while parameters quantity is > 0");
        }
        Object result = ids.getClass().isArray() ? this.findByIds(Arrays.stream((Object[])ids).toList(), sourceClass, targetClass, qualifiers) : (ids instanceof Iterable ? this.findByIds((Iterable)ids, sourceClass, targetClass, qualifiers) : this.findById(ids, sourceClass, targetClass, qualifiers));
        return result;
    }

    abstract Object findById(Object var1, Class<?> var2, Class<?> var3, Qualifier ... var4);

    abstract Object findByIds(Iterable<?> var1, Class<?> var2, Class<?> var3, Qualifier ... var4);
}

