/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import org.springframework.data.aerospike.core.ReactiveAerospikeInternalOperations;
import org.springframework.data.aerospike.core.ReactiveAerospikeOperations;
import org.springframework.data.aerospike.core.ReactiveAerospikeTemplate;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeCriteria;
import org.springframework.data.aerospike.repository.query.BaseAerospikePartTreeQuery;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import reactor.core.publisher.Flux;

public class ReactiveAerospikePartTreeQuery
extends BaseAerospikePartTreeQuery {
    private final ReactiveAerospikeOperations operations;
    private final ReactiveAerospikeInternalOperations internalOperations;

    public ReactiveAerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evalContextProvider, ReactiveAerospikeTemplate aerospikeTemplate, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evalContextProvider, queryCreator);
        this.operations = aerospikeTemplate;
        this.internalOperations = aerospikeTemplate;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Query query = this.prepareQuery(parameters, accessor);
        Class<?> targetClass = this.getTargetClass(accessor);
        if (parameters != null && parameters.length > 0) {
            AerospikeCriteria criteria = query.getAerospikeCriteria();
            Qualifier[] qualifiers = ReactiveAerospikePartTreeQuery.getQualifiers(criteria);
            if (ReactiveAerospikePartTreeQuery.isIdQuery(criteria)) {
                return this.runIdQuery(this.entityClass, targetClass, ReactiveAerospikePartTreeQuery.getIdValue(qualifiers), new Qualifier[0]);
            }
            if (ReactiveAerospikePartTreeQuery.hasIdQualifier(criteria)) {
                return this.runIdQuery(this.entityClass, targetClass, ReactiveAerospikePartTreeQuery.getIdValue(ReactiveAerospikePartTreeQuery.getIdQualifier(qualifiers)), ReactiveAerospikePartTreeQuery.excludeIdQualifier(qualifiers));
            }
        }
        return this.findByQuery(query, targetClass);
    }

    private Flux<?> findByQuery(Query query, Class<?> targetClass) {
        if (targetClass != this.entityClass) {
            return this.operations.find(query, this.entityClass, targetClass);
        }
        return this.operations.find(query, this.entityClass);
    }

    @Override
    protected Object findById(Object obj, Class<?> sourceClass, Class<?> targetClass, Qualifier ... qualifiers) {
        return this.internalOperations.findByIdInternal(obj, sourceClass, targetClass, qualifiers);
    }

    @Override
    protected Object findByIds(Iterable<?> iterable, Class<?> sourceClass, Class<?> targetClass, Qualifier ... qualifiers) {
        return this.internalOperations.findByIdsInternal(IterableConverter.toList(iterable), sourceClass, targetClass, qualifiers);
    }
}

