/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.config;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.reactor.AerospikeReactorClient;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.aerospike.config.AerospikeDataConfigurationSupport;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.ReactiveAerospikeTemplate;
import org.springframework.data.aerospike.index.AerospikeIndexResolver;
import org.springframework.data.aerospike.index.ReactiveAerospikePersistenceEntityIndexCreator;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.query.FilterExpressionsBuilder;
import org.springframework.data.aerospike.query.ReactorQueryEngine;
import org.springframework.data.aerospike.query.StatementBuilder;
import org.springframework.data.aerospike.query.cache.IndexInfoParser;
import org.springframework.data.aerospike.query.cache.IndexesCacheUpdater;
import org.springframework.data.aerospike.query.cache.InternalIndexOperations;
import org.springframework.data.aerospike.query.cache.ReactorIndexRefresher;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;

@Configuration
public abstract class AbstractReactiveAerospikeDataConfiguration
extends AerospikeDataConfigurationSupport {
    private static final Logger log = LoggerFactory.getLogger(AbstractReactiveAerospikeDataConfiguration.class);

    @Bean(name={"reactiveAerospikeTemplate"})
    public ReactiveAerospikeTemplate reactiveAerospikeTemplate(MappingAerospikeConverter mappingAerospikeConverter, AerospikeMappingContext aerospikeMappingContext, AerospikeExceptionTranslator aerospikeExceptionTranslator, IAerospikeReactorClient aerospikeReactorClient, ReactorQueryEngine reactorQueryEngine, ReactorIndexRefresher reactorIndexRefresher, ServerVersionSupport serverVersionSupport) {
        return new ReactiveAerospikeTemplate(aerospikeReactorClient, this.nameSpace(), mappingAerospikeConverter, aerospikeMappingContext, aerospikeExceptionTranslator, reactorQueryEngine, reactorIndexRefresher, serverVersionSupport);
    }

    @Bean(name={"reactiveAerospikeQueryEngine"})
    public ReactorQueryEngine reactorQueryEngine(IAerospikeReactorClient aerospikeReactorClient, StatementBuilder statementBuilder, FilterExpressionsBuilder filterExpressionsBuilder) {
        ReactorQueryEngine queryEngine = new ReactorQueryEngine(aerospikeReactorClient, statementBuilder, filterExpressionsBuilder);
        boolean scansEnabled = this.aerospikeDataSettings().isScansEnabled();
        queryEngine.setScansEnabled(scansEnabled);
        log.debug("AerospikeDataSettings.scansEnabled: {}", (Object)scansEnabled);
        long queryMaxRecords = this.aerospikeDataSettings().getQueryMaxRecords();
        log.debug("AerospikeDataSettings.queryMaxRecords: {}", (Object)queryMaxRecords);
        queryEngine.setQueryMaxRecords(queryMaxRecords);
        return queryEngine;
    }

    @Bean(name={"reactiveAerospikeIndexRefresher"})
    public ReactorIndexRefresher reactorIndexRefresher(IAerospikeReactorClient aerospikeReactorClient, IndexesCacheUpdater indexesCacheUpdater, ServerVersionSupport serverVersionSupport) {
        ReactorIndexRefresher refresher = new ReactorIndexRefresher(aerospikeReactorClient, aerospikeReactorClient.getInfoPolicyDefault(), new InternalIndexOperations(new IndexInfoParser()), indexesCacheUpdater, serverVersionSupport);
        refresher.refreshIndexes().block();
        return refresher;
    }

    @Bean(name={"aerospikeReactorClient"})
    public IAerospikeReactorClient aerospikeReactorClient(IAerospikeClient aerospikeClient) {
        return new AerospikeReactorClient(aerospikeClient);
    }

    @Bean
    protected abstract EventLoops eventLoops();

    @Override
    protected ClientPolicy getClientPolicy() {
        ClientPolicy clientPolicy = super.getClientPolicy();
        clientPolicy.eventLoops = this.eventLoops();
        return clientPolicy;
    }

    @Bean
    public ReactiveAerospikePersistenceEntityIndexCreator aerospikePersistenceEntityIndexCreator(ObjectProvider<AerospikeMappingContext> aerospikeMappingContext, AerospikeIndexResolver aerospikeIndexResolver, ObjectProvider<ReactiveAerospikeTemplate> template) {
        boolean indexesOnStartup = this.aerospikeDataSettings().isCreateIndexesOnStartup();
        log.debug("AerospikeDataSettings.indexesOnStartup: {}", (Object)indexesOnStartup);
        return new ReactiveAerospikePersistenceEntityIndexCreator(aerospikeMappingContext, indexesOnStartup, aerospikeIndexResolver, template);
    }
}

