/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.config;

public final class AerospikeDataSettings {
    private final boolean scansEnabled;
    private final boolean sendKey;
    private final boolean createIndexesOnStartup;
    private final int indexCacheRefreshSeconds;
    private final int serverVersionRefreshSeconds;
    private final long queryMaxRecords;
    private final int batchWriteSize;
    private final boolean keepOriginalKeyTypes;

    private static boolean $default$scansEnabled() {
        return false;
    }

    private static boolean $default$sendKey() {
        return true;
    }

    private static boolean $default$createIndexesOnStartup() {
        return true;
    }

    private static int $default$indexCacheRefreshSeconds() {
        return 3600;
    }

    private static int $default$serverVersionRefreshSeconds() {
        return 3600;
    }

    private static long $default$queryMaxRecords() {
        return 10000L;
    }

    private static int $default$batchWriteSize() {
        return 100;
    }

    private static boolean $default$keepOriginalKeyTypes() {
        return false;
    }

    AerospikeDataSettings(boolean scansEnabled, boolean sendKey, boolean createIndexesOnStartup, int indexCacheRefreshSeconds, int serverVersionRefreshSeconds, long queryMaxRecords, int batchWriteSize, boolean keepOriginalKeyTypes) {
        this.scansEnabled = scansEnabled;
        this.sendKey = sendKey;
        this.createIndexesOnStartup = createIndexesOnStartup;
        this.indexCacheRefreshSeconds = indexCacheRefreshSeconds;
        this.serverVersionRefreshSeconds = serverVersionRefreshSeconds;
        this.queryMaxRecords = queryMaxRecords;
        this.batchWriteSize = batchWriteSize;
        this.keepOriginalKeyTypes = keepOriginalKeyTypes;
    }

    public static AerospikeDataSettingsBuilder builder() {
        return new AerospikeDataSettingsBuilder();
    }

    public boolean isScansEnabled() {
        return this.scansEnabled;
    }

    public boolean isSendKey() {
        return this.sendKey;
    }

    public boolean isCreateIndexesOnStartup() {
        return this.createIndexesOnStartup;
    }

    public int getIndexCacheRefreshSeconds() {
        return this.indexCacheRefreshSeconds;
    }

    public int getServerVersionRefreshSeconds() {
        return this.serverVersionRefreshSeconds;
    }

    public long getQueryMaxRecords() {
        return this.queryMaxRecords;
    }

    public int getBatchWriteSize() {
        return this.batchWriteSize;
    }

    public boolean isKeepOriginalKeyTypes() {
        return this.keepOriginalKeyTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AerospikeDataSettings)) {
            return false;
        }
        AerospikeDataSettings other = (AerospikeDataSettings)o;
        if (this.isScansEnabled() != other.isScansEnabled()) {
            return false;
        }
        if (this.isSendKey() != other.isSendKey()) {
            return false;
        }
        if (this.isCreateIndexesOnStartup() != other.isCreateIndexesOnStartup()) {
            return false;
        }
        if (this.getIndexCacheRefreshSeconds() != other.getIndexCacheRefreshSeconds()) {
            return false;
        }
        if (this.getServerVersionRefreshSeconds() != other.getServerVersionRefreshSeconds()) {
            return false;
        }
        if (this.getQueryMaxRecords() != other.getQueryMaxRecords()) {
            return false;
        }
        if (this.getBatchWriteSize() != other.getBatchWriteSize()) {
            return false;
        }
        return this.isKeepOriginalKeyTypes() == other.isKeepOriginalKeyTypes();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isScansEnabled() ? 79 : 97);
        result = result * 59 + (this.isSendKey() ? 79 : 97);
        result = result * 59 + (this.isCreateIndexesOnStartup() ? 79 : 97);
        result = result * 59 + this.getIndexCacheRefreshSeconds();
        result = result * 59 + this.getServerVersionRefreshSeconds();
        long $queryMaxRecords = this.getQueryMaxRecords();
        result = result * 59 + (int)($queryMaxRecords >>> 32 ^ $queryMaxRecords);
        result = result * 59 + this.getBatchWriteSize();
        result = result * 59 + (this.isKeepOriginalKeyTypes() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AerospikeDataSettings(scansEnabled=" + this.isScansEnabled() + ", sendKey=" + this.isSendKey() + ", createIndexesOnStartup=" + this.isCreateIndexesOnStartup() + ", indexCacheRefreshSeconds=" + this.getIndexCacheRefreshSeconds() + ", serverVersionRefreshSeconds=" + this.getServerVersionRefreshSeconds() + ", queryMaxRecords=" + this.getQueryMaxRecords() + ", batchWriteSize=" + this.getBatchWriteSize() + ", keepOriginalKeyTypes=" + this.isKeepOriginalKeyTypes() + ")";
    }

    public static class AerospikeDataSettingsBuilder {
        private boolean scansEnabled$set;
        private boolean scansEnabled$value;
        private boolean sendKey$set;
        private boolean sendKey$value;
        private boolean createIndexesOnStartup$set;
        private boolean createIndexesOnStartup$value;
        private boolean indexCacheRefreshSeconds$set;
        private int indexCacheRefreshSeconds$value;
        private boolean serverVersionRefreshSeconds$set;
        private int serverVersionRefreshSeconds$value;
        private boolean queryMaxRecords$set;
        private long queryMaxRecords$value;
        private boolean batchWriteSize$set;
        private int batchWriteSize$value;
        private boolean keepOriginalKeyTypes$set;
        private boolean keepOriginalKeyTypes$value;

        AerospikeDataSettingsBuilder() {
        }

        public AerospikeDataSettingsBuilder scansEnabled(boolean scansEnabled) {
            this.scansEnabled$value = scansEnabled;
            this.scansEnabled$set = true;
            return this;
        }

        public AerospikeDataSettingsBuilder sendKey(boolean sendKey) {
            this.sendKey$value = sendKey;
            this.sendKey$set = true;
            return this;
        }

        public AerospikeDataSettingsBuilder createIndexesOnStartup(boolean createIndexesOnStartup) {
            this.createIndexesOnStartup$value = createIndexesOnStartup;
            this.createIndexesOnStartup$set = true;
            return this;
        }

        public AerospikeDataSettingsBuilder indexCacheRefreshSeconds(int indexCacheRefreshSeconds) {
            this.indexCacheRefreshSeconds$value = indexCacheRefreshSeconds;
            this.indexCacheRefreshSeconds$set = true;
            return this;
        }

        public AerospikeDataSettingsBuilder serverVersionRefreshSeconds(int serverVersionRefreshSeconds) {
            this.serverVersionRefreshSeconds$value = serverVersionRefreshSeconds;
            this.serverVersionRefreshSeconds$set = true;
            return this;
        }

        public AerospikeDataSettingsBuilder queryMaxRecords(long queryMaxRecords) {
            this.queryMaxRecords$value = queryMaxRecords;
            this.queryMaxRecords$set = true;
            return this;
        }

        public AerospikeDataSettingsBuilder batchWriteSize(int batchWriteSize) {
            this.batchWriteSize$value = batchWriteSize;
            this.batchWriteSize$set = true;
            return this;
        }

        public AerospikeDataSettingsBuilder keepOriginalKeyTypes(boolean keepOriginalKeyTypes) {
            this.keepOriginalKeyTypes$value = keepOriginalKeyTypes;
            this.keepOriginalKeyTypes$set = true;
            return this;
        }

        public AerospikeDataSettings build() {
            boolean scansEnabled$value = this.scansEnabled$value;
            if (!this.scansEnabled$set) {
                scansEnabled$value = AerospikeDataSettings.$default$scansEnabled();
            }
            boolean sendKey$value = this.sendKey$value;
            if (!this.sendKey$set) {
                sendKey$value = AerospikeDataSettings.$default$sendKey();
            }
            boolean createIndexesOnStartup$value = this.createIndexesOnStartup$value;
            if (!this.createIndexesOnStartup$set) {
                createIndexesOnStartup$value = AerospikeDataSettings.$default$createIndexesOnStartup();
            }
            int indexCacheRefreshSeconds$value = this.indexCacheRefreshSeconds$value;
            if (!this.indexCacheRefreshSeconds$set) {
                indexCacheRefreshSeconds$value = AerospikeDataSettings.$default$indexCacheRefreshSeconds();
            }
            int serverVersionRefreshSeconds$value = this.serverVersionRefreshSeconds$value;
            if (!this.serverVersionRefreshSeconds$set) {
                serverVersionRefreshSeconds$value = AerospikeDataSettings.$default$serverVersionRefreshSeconds();
            }
            long queryMaxRecords$value = this.queryMaxRecords$value;
            if (!this.queryMaxRecords$set) {
                queryMaxRecords$value = AerospikeDataSettings.$default$queryMaxRecords();
            }
            int batchWriteSize$value = this.batchWriteSize$value;
            if (!this.batchWriteSize$set) {
                batchWriteSize$value = AerospikeDataSettings.$default$batchWriteSize();
            }
            boolean keepOriginalKeyTypes$value = this.keepOriginalKeyTypes$value;
            if (!this.keepOriginalKeyTypes$set) {
                keepOriginalKeyTypes$value = AerospikeDataSettings.$default$keepOriginalKeyTypes();
            }
            return new AerospikeDataSettings(scansEnabled$value, sendKey$value, createIndexesOnStartup$value, indexCacheRefreshSeconds$value, serverVersionRefreshSeconds$value, queryMaxRecords$value, batchWriteSize$value, keepOriginalKeyTypes$value);
        }

        public String toString() {
            return "AerospikeDataSettings.AerospikeDataSettingsBuilder(scansEnabled$value=" + this.scansEnabled$value + ", sendKey$value=" + this.sendKey$value + ", createIndexesOnStartup$value=" + this.createIndexesOnStartup$value + ", indexCacheRefreshSeconds$value=" + this.indexCacheRefreshSeconds$value + ", serverVersionRefreshSeconds$value=" + this.serverVersionRefreshSeconds$value + ", queryMaxRecords$value=" + this.queryMaxRecords$value + ", batchWriteSize$value=" + this.batchWriteSize$value + ", keepOriginalKeyTypes$value=" + this.keepOriginalKeyTypes$value + ")";
        }
    }
}

