/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.ClassUtils;

public final class DateConverters {
    private static final String MILLIS = "millis";
    private static final String TIMEZONE = "timezone";
    private static final boolean JODA_TIME_IS_PRESENT = ClassUtils.isPresent((String)"org.joda.time.LocalDate", null);

    private DateConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        converters.add(DateToLongConverter.INSTANCE);
        converters.add(LongToDateConverter.INSTANCE);
        converters.add(CalendarToMapConverter.INSTANCE);
        converters.add(MapToCalendarConverter.INSTANCE);
        converters.add(Java8LocalDateTimeToLongConverter.INSTANCE);
        converters.add(Java8LocalDateToLongConverter.INSTANCE);
        converters.add(LongToJava8LocalDateTimeConverter.INSTANCE);
        converters.add(LongToJava8LocalDateConverter.INSTANCE);
        converters.add(DurationToStringConverter.INSTANCE);
        converters.add(StringToDurationConverter.INSTANCE);
        if (JODA_TIME_IS_PRESENT) {
            converters.add(LocalDateToLongConverter.INSTANCE);
            converters.add(LongToLocalDateConverter.INSTANCE);
            converters.add(LocalDateTimeToLongConverter.INSTANCE);
            converters.add(LongToLocalDateTimeConverter.INSTANCE);
            converters.add(DateTimeToLongConverter.INSTANCE);
            converters.add(LongToDateTimeConverter.INSTANCE);
            converters.add(DateMidnightToLongConverter.INSTANCE);
            converters.add(LongToDateMidnightConverter.INSTANCE);
        }
        return converters;
    }

    @WritingConverter
    public static enum DateToLongConverter implements Converter<Date, Long>
    {
        INSTANCE;


        public Long convert(Date source) {
            return source == null ? null : Long.valueOf(source.getTime());
        }
    }

    @ReadingConverter
    public static enum LongToDateConverter implements Converter<Long, Date>
    {
        INSTANCE;


        public Date convert(Long source) {
            if (source == null) {
                return null;
            }
            Date date = new Date();
            date.setTime(source);
            return date;
        }
    }

    @WritingConverter
    public static enum CalendarToMapConverter implements Converter<Calendar, Map<String, String>>
    {
        INSTANCE;


        public Map<String, String> convert(Calendar source) {
            if (source == null) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(DateConverters.MILLIS, String.valueOf(source.getTimeInMillis()));
            map.put(DateConverters.TIMEZONE, source.getTimeZone().getID());
            return map;
        }
    }

    @ReadingConverter
    public static enum MapToCalendarConverter implements Converter<Map<String, String>, Calendar>
    {
        INSTANCE;


        public Calendar convert(Map<String, String> source) {
            if (source == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(TimeZone.getTimeZone(source.get(DateConverters.TIMEZONE)));
            calendar.setTimeInMillis(Long.parseLong(source.get(DateConverters.MILLIS)));
            return calendar;
        }
    }

    @WritingConverter
    public static enum Java8LocalDateTimeToLongConverter implements Converter<java.time.LocalDateTime, Long>
    {
        INSTANCE;


        public Long convert(java.time.LocalDateTime source) {
            return source == null ? null : Long.valueOf(source.atZone(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
    }

    @WritingConverter
    public static enum Java8LocalDateToLongConverter implements Converter<LocalDate, Long>
    {
        INSTANCE;


        public Long convert(LocalDate source) {
            return source == null ? null : Long.valueOf(source.toEpochDay());
        }
    }

    @ReadingConverter
    public static enum LongToJava8LocalDateTimeConverter implements Converter<Long, java.time.LocalDateTime>
    {
        INSTANCE;


        public java.time.LocalDateTime convert(Long source) {
            if (source == null) {
                return null;
            }
            return java.time.LocalDateTime.ofInstant(Instant.ofEpochMilli(source), ZoneOffset.UTC);
        }
    }

    @ReadingConverter
    public static enum LongToJava8LocalDateConverter implements Converter<Long, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(Long source) {
            if (source == null) {
                return null;
            }
            return LocalDate.ofEpochDay(source);
        }
    }

    @WritingConverter
    public static enum DurationToStringConverter implements Converter<Duration, String>
    {
        INSTANCE;


        public String convert(Duration source) {
            if (source == null) {
                return null;
            }
            return source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToDurationConverter implements Converter<String, Duration>
    {
        INSTANCE;


        public Duration convert(String source) {
            if (source == null) {
                return null;
            }
            return Duration.parse(source);
        }
    }

    @WritingConverter
    public static enum LocalDateToLongConverter implements Converter<org.joda.time.LocalDate, Long>
    {
        INSTANCE;


        public Long convert(org.joda.time.LocalDate source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @ReadingConverter
    public static enum LongToLocalDateConverter implements Converter<Long, org.joda.time.LocalDate>
    {
        INSTANCE;


        public org.joda.time.LocalDate convert(Long source) {
            return source == null ? null : new org.joda.time.LocalDate((Object)source);
        }
    }

    @WritingConverter
    public static enum LocalDateTimeToLongConverter implements Converter<LocalDateTime, Long>
    {
        INSTANCE;


        public Long convert(LocalDateTime source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @ReadingConverter
    public static enum LongToLocalDateTimeConverter implements Converter<Long, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(Long source) {
            return source == null ? null : new LocalDateTime((Object)source);
        }
    }

    @WritingConverter
    public static enum DateTimeToLongConverter implements Converter<DateTime, Long>
    {
        INSTANCE;


        public Long convert(DateTime source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @ReadingConverter
    public static enum LongToDateTimeConverter implements Converter<Long, DateTime>
    {
        INSTANCE;


        public DateTime convert(Long source) {
            return source == null ? null : new DateTime((Object)source);
        }
    }

    @WritingConverter
    public static enum DateMidnightToLongConverter implements Converter<DateMidnight, Long>
    {
        INSTANCE;


        public Long convert(DateMidnight source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @ReadingConverter
    public static enum LongToDateMidnightConverter implements Converter<Long, DateMidnight>
    {
        INSTANCE;


        public DateMidnight convert(Long source) {
            return source == null ? null : new DateMidnight((Object)source);
        }
    }
}

