/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.aerospike.config.AerospikeDataSettings;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.utility.TimeUtils;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MappingAerospikeWriteConverter
implements EntityWriter<Object, AerospikeWriteData> {
    private static final Logger log = LoggerFactory.getLogger(MappingAerospikeWriteConverter.class);
    private final TypeMapper<Map<String, Object>> typeMapper;
    private final AerospikeMappingContext mappingContext;
    private final CustomConversions conversions;
    private final GenericConversionService conversionService;
    private final AerospikeDataSettings aerospikeDataSettings;

    public MappingAerospikeWriteConverter(TypeMapper<Map<String, Object>> typeMapper, AerospikeMappingContext mappingContext, CustomConversions conversions, GenericConversionService conversionService, AerospikeDataSettings aerospikeDataSettings) {
        this.typeMapper = typeMapper;
        this.mappingContext = mappingContext;
        this.conversions = conversions;
        this.conversionService = conversionService;
        this.aerospikeDataSettings = aerospikeDataSettings;
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    public void write(Object source, AerospikeWriteData data) {
        if (source == null) {
            return;
        }
        boolean hasCustomConverter = this.conversions.hasCustomWriteTarget(source.getClass(), AerospikeWriteData.class);
        if (hasCustomConverter) {
            this.convertToAerospikeWriteData(source, data);
            return;
        }
        TypeInformation type = TypeInformation.of(source.getClass());
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass());
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(source), (ConversionService)this.conversionService);
        data.setKeyForWrite(this.getNewKey(data, accessor, entity));
        AerospikePersistentProperty versionProperty = (AerospikePersistentProperty)entity.getVersionProperty();
        if (versionProperty != null) {
            Integer version = (Integer)accessor.getProperty((PersistentProperty)versionProperty, Integer.class);
            data.setVersion(version);
        }
        data.setExpiration(this.getExpiration(entity, accessor));
        Map<String, Object> convertedProperties = this.convertProperties(type, entity, accessor, false);
        if (!data.hasRequestedBins()) {
            convertedProperties.forEach(data::addBin);
        } else {
            convertedProperties.forEach((key, value) -> {
                if (data.getRequestedBins().contains(key)) {
                    data.addBin((String)key, value);
                }
            });
        }
    }

    public Optional<Key> getNewKey(AerospikeWriteData data, ConvertingPropertyAccessor<?> accessor, AerospikePersistentEntity<?> entity) {
        Key key = data.getKey();
        if (key == null || key.userKey.getObject() == null || key.userKey.getObject().toString().isEmpty() || key.setName == null || key.namespace == null) {
            AerospikePersistentProperty idProperty = (AerospikePersistentProperty)entity.getIdProperty();
            if (idProperty != null) {
                String setName = Optional.ofNullable(data.getSetName()).orElse(entity.getSetName());
                if (this.aerospikeDataSettings.isKeepOriginalKeyTypes() && this.isValidAerospikeRecordKeyType(idProperty.getType())) {
                    log.debug("Attempt to construct record key with original key type");
                    Object nativeTypeId = accessor.getProperty((PersistentProperty)idProperty, idProperty.getType());
                    Assert.notNull((Object)nativeTypeId, (String)"Id must not be null!");
                    Key aerospikeRecordKey = this.constructAerospikeRecordKey(data.getNamespace(), setName, nativeTypeId);
                    if (aerospikeRecordKey != null) {
                        return Optional.of(aerospikeRecordKey);
                    }
                }
                String stringId = (String)accessor.getProperty((PersistentProperty)idProperty, String.class);
                Assert.notNull((Object)stringId, (String)"Id must not be null!");
                log.debug("Attempt to construct record key as String");
                return Optional.of(new Key(data.getNamespace(), setName, stringId));
            }
            throw new AerospikeException(26, "Id has not been provided");
        }
        return Optional.empty();
    }

    private void convertToAerospikeWriteData(Object source, AerospikeWriteData data) {
        AerospikeWriteData converted = (AerospikeWriteData)this.conversionService.convert(source, AerospikeWriteData.class);
        Assert.notNull((Object)converted, (String)"Converted AerospikeWriteData cannot be null");
        data.setBins(new ArrayList<Bin>(converted.getBins()));
        data.setKey(converted.getKey());
        data.setExpiration(converted.getExpiration());
    }

    private Map<String, Object> convertProperties(TypeInformation<?> type, AerospikePersistentEntity<?> entity, ConvertingPropertyAccessor<?> accessor, boolean isCustomType) {
        TreeMap<String, Object> target = new TreeMap<String, Object>();
        this.typeMapper.writeType(type, target);
        entity.doWithProperties(property -> {
            Object value = accessor.getProperty(property);
            if (this.isNotWritable((AerospikePersistentProperty)property) && !isCustomType) {
                return;
            }
            Object valueToWrite = this.getValueToWrite(value, property.getTypeInformation());
            if (valueToWrite != null) {
                target.put(property.getFieldName(), valueToWrite);
            }
        });
        return target;
    }

    private boolean isNotWritable(AerospikePersistentProperty property) {
        return property.isIdProperty() || property.isExpirationProperty() || property.isVersionProperty() || !property.isWritable();
    }

    Object getValueToWrite(Object value, TypeInformation<?> type) {
        if (value == null) {
            return null;
        }
        if (type == null || this.isSimpleValue(value.getClass())) {
            return this.getSimpleValueToWrite(value);
        }
        return this.getNonSimpleValueToWrite(value, type);
    }

    private boolean isSimpleValue(Class<?> clazz) {
        return this.conversions.isSimpleType(clazz) && (!clazz.isArray() || clazz == byte[].class);
    }

    private Object getSimpleValueToWrite(Object value) {
        Optional customTarget = this.conversions.getCustomWriteTarget(value.getClass());
        return customTarget.map(aClass -> this.conversionService.convert(value, aClass)).orElse(value);
    }

    private Object getNonSimpleValueToWrite(Object value, TypeInformation<?> type) {
        TypeInformation valueType = TypeInformation.of(value.getClass());
        if (valueType.isCollectionLike()) {
            return this.convertCollection(MappingAerospikeWriteConverter.asCollection(value), type);
        }
        if (valueType.isMap()) {
            return this.convertMap(this.asMap(value), type);
        }
        Optional basicTargetType = this.conversions.getCustomWriteTarget(value.getClass());
        return basicTargetType.map(aClass -> this.conversionService.convert(value, aClass)).orElseGet(() -> this.convertCustomType(value, valueType));
    }

    protected List<Object> convertCollection(Collection<?> source, TypeInformation<?> type) {
        Assert.notNull(source, (String)"Given collection must not be null!");
        Assert.notNull(type, (String)"Given type must not be null!");
        TypeInformation componentType = type.getComponentType();
        return source.stream().map(element -> this.getValueToWrite(element, componentType)).collect(Collectors.toList());
    }

    protected Map<Object, Object> convertMap(Map<Object, Object> source, TypeInformation<?> type) {
        Assert.notNull(source, (String)"Given map must not be null!");
        Assert.notNull(type, (String)"Given type must not be null!");
        return source.entrySet().stream().collect(TreeMap::new, (m, e) -> {
            Object key = e.getKey();
            Object value = e.getValue();
            if (key == null) {
                throw new UnsupportedOperationException("Key of a map cannot be null");
            }
            if (!this.conversions.isSimpleType(key.getClass())) {
                throw new MappingException("Cannot use a complex object as a map key");
            }
            Object simpleKey = this.aerospikeDataSettings.isKeepOriginalKeyTypes() && this.isValidAerospikeMapKeyType(key.getClass()) ? key : (this.conversionService.canConvert(key.getClass(), String.class) ? this.conversionService.convert(key, String.class) : key.toString());
            Object convertedValue = this.getValueToWrite(value, type.getMapValueType());
            if (simpleKey instanceof byte[]) {
                simpleKey = ByteBuffer.wrap((byte[])simpleKey);
            }
            m.put(simpleKey, convertedValue);
        }, TreeMap::putAll);
    }

    private Map<String, Object> convertCustomType(Object source, TypeInformation<?> type) {
        AerospikePersistentEntity entity;
        Assert.notNull((Object)source, (String)"Given map must not be null!");
        Assert.notNull(type, (String)"Given type must not be null!");
        try {
            entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass());
        }
        catch (Exception e) {
            throw new AerospikeException("Exception while getting persistent entity", (Throwable)e);
        }
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(source), (ConversionService)this.conversionService);
        return this.convertProperties(type, entity, accessor, true);
    }

    private Map<Object, Object> asMap(Object value) {
        return (Map)value;
    }

    private int getExpiration(AerospikePersistentEntity<?> entity, ConvertingPropertyAccessor<?> accessor) {
        AerospikePersistentProperty expirationProperty = entity.getExpirationProperty();
        if (expirationProperty != null) {
            return this.getExpirationFromProperty(accessor, expirationProperty);
        }
        return entity.getExpiration();
    }

    private int getExpirationFromProperty(ConvertingPropertyAccessor<?> accessor, AerospikePersistentProperty expirationProperty) {
        if (expirationProperty.isExpirationSpecifiedAsUnixTime()) {
            Long unixTime = (Long)accessor.getProperty((PersistentProperty)expirationProperty, Long.class);
            Assert.notNull((Object)unixTime, (String)"Expiration must not be null!");
            int inSeconds = TimeUtils.unixTimeToOffsetInSeconds(unixTime);
            Assert.isTrue((inSeconds > 0 ? 1 : 0) != 0, (String)("Expiration value must be greater than zero, but was: " + inSeconds + " seconds (unix time: " + unixTime + ")"));
            return inSeconds;
        }
        Integer expirationInSeconds = (Integer)accessor.getProperty((PersistentProperty)expirationProperty, Integer.class);
        Assert.notNull((Object)expirationInSeconds, (String)"Expiration must not be null!");
        return expirationInSeconds;
    }

    private boolean isValidAerospikeRecordKeyType(Class<?> type) {
        return type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.class || type == Integer.class || type == Long.class || type == Byte.class || type == Character.class || type == String.class || type == byte[].class;
    }

    private Key constructAerospikeRecordKey(String namespace, String set, Object userKey) {
        if (userKey.getClass() == String.class) {
            return new Key(namespace, set, (String)userKey);
        }
        if (userKey.getClass() == Short.class) {
            return new Key(namespace, set, (int)((Short)userKey).shortValue());
        }
        if (userKey.getClass() == Integer.class) {
            return new Key(namespace, set, ((Integer)userKey).intValue());
        }
        if (userKey.getClass() == Long.class) {
            return new Key(namespace, set, ((Long)userKey).longValue());
        }
        if (userKey.getClass() == Character.class) {
            return new Key(namespace, set, (int)((Character)userKey).charValue());
        }
        if (userKey.getClass() == Byte.class) {
            return new Key(namespace, set, (int)((Byte)userKey).byteValue());
        }
        if (userKey.getClass() == byte[].class) {
            return new Key(namespace, set, (byte[])userKey);
        }
        return null;
    }

    private boolean isValidAerospikeMapKeyType(Class<?> type) {
        return this.isValidAerospikeRecordKeyType(type) || type == Double.TYPE || type == Double.class;
    }
}

