/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.BatchWrite;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.policy.BatchWritePolicy;
import com.aerospike.client.policy.GenerationPolicy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.KeyRecord;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.CoreUtils;
import org.springframework.data.aerospike.core.EntitiesKeys;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.Field;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;

abstract class BaseAerospikeTemplate {
    private static final Logger log = LoggerFactory.getLogger(BaseAerospikeTemplate.class);
    protected final MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty> mappingContext;
    protected final MappingAerospikeConverter converter;
    protected final String namespace;
    protected final AerospikeExceptionTranslator exceptionTranslator;
    protected final WritePolicy writePolicyDefault;
    protected final BatchWritePolicy batchWritePolicyDefault;
    protected final ServerVersionSupport serverVersionSupport;

    BaseAerospikeTemplate(String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, WritePolicy writePolicyDefault, ServerVersionSupport serverVersionSupport) {
        Assert.notNull((Object)writePolicyDefault, (String)"Write policy must not be null!");
        Assert.notNull((Object)namespace, (String)"Namespace cannot be null");
        Assert.hasLength((String)namespace, (String)"Namespace cannot be empty");
        this.converter = converter;
        this.exceptionTranslator = exceptionTranslator;
        this.namespace = namespace;
        this.mappingContext = mappingContext;
        this.writePolicyDefault = writePolicyDefault;
        this.batchWritePolicyDefault = this.getFromWritePolicy(writePolicyDefault);
        this.serverVersionSupport = serverVersionSupport;
        this.loggerSetup();
    }

    private BatchWritePolicy getFromWritePolicy(WritePolicy writePolicy) {
        BatchWritePolicy batchWritePolicy = new BatchWritePolicy();
        batchWritePolicy.commitLevel = writePolicy.commitLevel;
        batchWritePolicy.durableDelete = writePolicy.durableDelete;
        batchWritePolicy.generationPolicy = writePolicy.generationPolicy;
        batchWritePolicy.expiration = writePolicy.expiration;
        batchWritePolicy.sendKey = writePolicy.sendKey;
        batchWritePolicy.recordExistsAction = writePolicy.recordExistsAction;
        batchWritePolicy.filterExp = writePolicy.filterExp;
        return batchWritePolicy;
    }

    private void loggerSetup() {
        Logger log = LoggerFactory.getLogger((String)"com.aerospike.client");
        Log.setCallback((level, message) -> {
            switch (level) {
                case INFO: {
                    log.info("{}", (Object)message);
                    break;
                }
                case DEBUG: {
                    log.debug("{}", (Object)message);
                    break;
                }
                case ERROR: {
                    log.error("{}", (Object)message);
                    break;
                }
                case WARN: {
                    log.warn("{}", (Object)message);
                }
            }
        });
    }

    public <T> String getSetName(Class<T> entityClass) {
        return ((BasicAerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass)).getSetName();
    }

    public <T> String getSetName(T document) {
        return ((BasicAerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass())).getSetName();
    }

    public MappingContext<?, ?> getMappingContext() {
        return this.mappingContext;
    }

    public MappingAerospikeConverter getAerospikeConverter() {
        return this.converter;
    }

    public String getNamespace() {
        return this.namespace;
    }

    <T> Class<T> getEntityClass(T entity) {
        return entity.getClass();
    }

    <T> T mapToEntity(KeyRecord keyRecord, Class<T> targetClass) {
        return this.mapToEntity(keyRecord.key, targetClass, keyRecord.record);
    }

    <T> T mapToEntity(Key key, Class<T> clazz, Record aeroRecord) {
        if (aeroRecord == null) {
            return null;
        }
        AerospikeReadData data = AerospikeReadData.forRead(key, aeroRecord);
        return this.converter.read(clazz, data);
    }

    protected <T> Comparator<T> getComparator(Query query) {
        return query.getSort().stream().map(this::getPropertyComparator).reduce(Comparator::thenComparing).orElseThrow(() -> new IllegalStateException("Comparator can not be created if sort orders are empty"));
    }

    protected <T> Comparator<T> getComparator(Sort sort) {
        return sort.stream().map(this::getPropertyComparator).reduce(Comparator::thenComparing).orElseThrow(() -> new IllegalStateException("Comparator can not be created if sort orders are empty"));
    }

    private <T> Comparator<T> getPropertyComparator(Sort.Order order) {
        boolean ignoreCase = true;
        boolean ascending = order.getDirection().isAscending();
        return new PropertyComparator(order.getProperty(), ignoreCase, ascending);
    }

    <T> ConvertingPropertyAccessor<T> getPropertyAccessor(AerospikePersistentEntity<?> entity, T source) {
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, (ConversionService)this.converter.getConversionService());
    }

    <T> T updateVersion(T document, Record newAeroRecord) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        ConvertingPropertyAccessor<T> propertyAccessor = this.getPropertyAccessor(entity, document);
        AerospikePersistentProperty versionProperty = (AerospikePersistentProperty)entity.getRequiredVersionProperty();
        propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)newAeroRecord.generation);
        return document;
    }

    RuntimeException translateCasError(AerospikeException e) {
        int code = e.getResultCode();
        if (code == 5 || code == 3) {
            return new OptimisticLockingFailureException("Save document with version value failed", (Throwable)e);
        }
        return this.translateError(e);
    }

    RuntimeException translateError(AerospikeException e) {
        DataAccessException translated = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)e);
        return translated == null ? e : translated;
    }

    <T> AerospikeWriteData writeData(T document, String setName) {
        AerospikeWriteData data = AerospikeWriteData.forWrite(this.getNamespace());
        data.setSetName(setName);
        this.converter.write(document, data);
        return data;
    }

    <T> AerospikeWriteData writeDataWithSpecificFields(T document, String setName, Collection<String> fields) {
        AerospikeWriteData data = AerospikeWriteData.forWrite(this.getNamespace());
        data.setSetName(setName);
        data.setRequestedBins(this.fieldsToBinNames(document, fields));
        this.converter.write(document, data);
        return data;
    }

    WritePolicy expectGenerationCasAwareSavePolicy(AerospikeWriteData data) {
        RecordExistsAction recordExistsAction = data.getVersion().filter(v -> (long)v.intValue() > 0L).map(v -> RecordExistsAction.UPDATE_ONLY).orElse(RecordExistsAction.CREATE_ONLY);
        return this.expectGenerationSavePolicy(data, recordExistsAction);
    }

    BatchWritePolicy expectGenerationCasAwareSaveBatchPolicy(AerospikeWriteData data) {
        RecordExistsAction recordExistsAction = data.getVersion().filter(v -> (long)v.intValue() > 0L).map(v -> RecordExistsAction.UPDATE_ONLY).orElse(RecordExistsAction.CREATE_ONLY);
        return this.expectGenerationSaveBatchPolicy(data, recordExistsAction);
    }

    WritePolicy expectGenerationSavePolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction) {
        return WritePolicyBuilder.builder(this.writePolicyDefault).generationPolicy(GenerationPolicy.EXPECT_GEN_EQUAL).generation(data.getVersion().orElse(0)).expiration(data.getExpiration()).recordExistsAction(recordExistsAction).build();
    }

    BatchWritePolicy expectGenerationSaveBatchPolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction) {
        BatchWritePolicy batchWritePolicy = new BatchWritePolicy(this.batchWritePolicyDefault);
        batchWritePolicy.generationPolicy = GenerationPolicy.EXPECT_GEN_EQUAL;
        batchWritePolicy.generation = data.getVersion().orElse(0);
        batchWritePolicy.expiration = data.getExpiration();
        batchWritePolicy.recordExistsAction = recordExistsAction;
        return batchWritePolicy;
    }

    WritePolicy ignoreGenerationSavePolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction) {
        return WritePolicyBuilder.builder(this.writePolicyDefault).generationPolicy(GenerationPolicy.NONE).expiration(data.getExpiration()).recordExistsAction(recordExistsAction).build();
    }

    BatchWritePolicy ignoreGenerationSaveBatchPolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction) {
        BatchWritePolicy batchWritePolicy = new BatchWritePolicy(this.batchWritePolicyDefault);
        batchWritePolicy.generationPolicy = GenerationPolicy.NONE;
        batchWritePolicy.expiration = data.getExpiration();
        batchWritePolicy.recordExistsAction = recordExistsAction;
        return batchWritePolicy;
    }

    WritePolicy ignoreGenerationDeletePolicy() {
        return WritePolicyBuilder.builder(this.writePolicyDefault).generationPolicy(GenerationPolicy.NONE).build();
    }

    Key getKey(Object id, AerospikePersistentEntity<?> entity) {
        return this.getKey(id, entity.getSetName());
    }

    Key getKey(Object id, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (this.converter.getAerospikeDataSettings().isKeepOriginalKeyTypes()) {
            Key key = id instanceof Byte || id instanceof Short || id instanceof Integer || id instanceof Long ? new Key(this.namespace, setName, this.convertIfNecessary(((Number)id).longValue(), Long.class).longValue()) : (id instanceof Character ? new Key(this.namespace, setName, (int)this.convertIfNecessary(id, Character.class).charValue()) : (id instanceof byte[] ? new Key(this.namespace, setName, this.convertIfNecessary(id, byte[].class)) : new Key(this.namespace, setName, this.convertIfNecessary(id, String.class))));
            return key;
        }
        return new Key(this.namespace, setName, this.convertIfNecessary(id, String.class));
    }

    GroupedEntities toGroupedEntities(EntitiesKeys entitiesKeys, Record[] records) {
        GroupedEntities.GroupedEntitiesBuilder builder = GroupedEntities.builder();
        IntStream.range(0, entitiesKeys.getKeys().length).filter(index -> records[index] != null).mapToObj(index -> this.mapToEntity(entitiesKeys.getKeys()[index], entitiesKeys.getEntityClasses()[index], records[index])).filter(Objects::nonNull).forEach(entity -> builder.entity(this.getEntityClass(entity), entity));
        return builder.build();
    }

    Map<Class<?>, List<Key>> toEntitiesKeyMap(GroupedKeys groupedKeys) {
        return groupedKeys.getEntitiesKeys().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.toKeysList((Class)entry.getKey(), (Collection)entry.getValue())));
    }

    private <T> List<String> fieldsToBinNames(T document, Collection<String> fields) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        return fields.stream().map(field -> {
            if (entity.getPersistentProperty((String)field) != null) {
                return Objects.requireNonNull((AerospikePersistentProperty)entity.getPersistentProperty((String)field)).getFieldName();
            }
            if (this.getFieldAnnotatedValue(entity, (String)field) != null) {
                return field;
            }
            throw this.translateError(new AerospikeException("Cannot convert field: " + field + " to bin name. field doesn't exists."));
        }).collect(Collectors.toList());
    }

    private String getFieldAnnotatedValue(AerospikePersistentEntity<?> entity, String field) {
        for (AerospikePersistentProperty property : entity.getPersistentProperties(Field.class)) {
            if (!property.getFieldName().equals(field)) continue;
            return field;
        }
        return null;
    }

    private <T> List<Key> toKeysList(Class<T> entityClass, Collection<?> ids) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(ids, (String)"List of ids must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        List idsList = IterableConverter.toList(ids);
        return idsList.stream().map(id -> this.getKey(id, entity)).collect(Collectors.toList());
    }

    private <S> S convertIfNecessary(Object source, Class<S> type) {
        return (S)(type.isAssignableFrom(source.getClass()) ? source : this.converter.getConversionService().convert(source, type));
    }

    protected Operation[] getPutAndGetHeaderOperations(AerospikeWriteData data, boolean firstlyDeleteBins) {
        Bin[] bins = data.getBinsAsArray();
        if (bins.length == 0) {
            throw new AerospikeException("Cannot put and get header on a document with no bins and \"@_class\" bin disabled.");
        }
        return firstlyDeleteBins ? CoreUtils.operations(bins, Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}), Operation.array((Operation[])new Operation[]{Operation.getHeader()})) : CoreUtils.operations(bins, Operation::put, null, Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
    }

    public <T> BatchWriteData<T> getBatchWriteForSave(T document, String setName) {
        Operation[] operations;
        BatchWritePolicy policy;
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            policy = this.expectGenerationCasAwareSaveBatchPolicy(data);
            operations = this.getPutAndGetHeaderOperations(data, true);
        } else {
            policy = this.ignoreGenerationSaveBatchPolicy(data, RecordExistsAction.UPDATE);
            operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
        }
        return new BatchWriteData<T>(document, (BatchRecord)new BatchWrite(policy, data.getKey(), operations), entity.hasVersionProperty());
    }

    public <T> BatchWriteData<T> getBatchWriteForInsert(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        BatchWritePolicy policy = this.ignoreGenerationSaveBatchPolicy(data, RecordExistsAction.CREATE_ONLY);
        Operation[] operations = entity.hasVersionProperty() ? this.getPutAndGetHeaderOperations(data, false) : CoreUtils.operations(data.getBinsAsArray(), Operation::put);
        return new BatchWriteData<T>(document, (BatchRecord)new BatchWrite(policy, data.getKey(), operations), entity.hasVersionProperty());
    }

    public <T> BatchWriteData<T> getBatchWriteForUpdate(T document, String setName) {
        Operation[] operations;
        BatchWritePolicy policy;
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            policy = this.expectGenerationSaveBatchPolicy(data, RecordExistsAction.UPDATE_ONLY);
            operations = this.getPutAndGetHeaderOperations(data, true);
        } else {
            policy = this.ignoreGenerationSaveBatchPolicy(data, RecordExistsAction.UPDATE_ONLY);
            operations = (Operation[])Stream.concat(Stream.of(Operation.delete()), data.getBins().stream().map(Operation::put)).toArray(Operation[]::new);
        }
        return new BatchWriteData<T>(document, (BatchRecord)new BatchWrite(policy, data.getKey(), operations), entity.hasVersionProperty());
    }

    protected void validateGroupedKeys(GroupedKeys groupedKeys) {
        Assert.notNull((Object)groupedKeys, (String)"Grouped keys must not be null!");
        this.validateForBatchWrite(groupedKeys.getEntitiesKeys(), "Entities keys");
    }

    protected void validateForBatchWrite(Object object, String objectName) {
        Assert.notNull((Object)object, (String)(objectName + " must not be null!"));
        Assert.isTrue((boolean)this.batchWriteSupported(), (String)"Batch write operations are supported starting with server version 6.0.0");
    }

    protected boolean batchWriteSizeMatch(int batchSize, int currentSize) {
        return batchSize > 0 && currentSize == batchSize;
    }

    protected boolean batchRecordFailed(BatchRecord batchRecord) {
        return batchRecord.resultCode != 0 || batchRecord.record == null;
    }

    protected boolean batchWriteSupported() {
        return this.serverVersionSupport.batchWrite();
    }

    protected record BatchWriteData<T>(T document, BatchRecord batchRecord, boolean hasVersionProperty) {
    }

    protected static enum OperationType {
        SAVE_OPERATION("save"),
        INSERT_OPERATION("insert"),
        UPDATE_OPERATION("update");

        private final String name;

        private OperationType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

