/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupedEntities {
    private final Map<Class<?>, Collection<?>> entitiesResults;

    public <T> List<T> getEntitiesByClass(Class<T> entityClass) {
        return this.entitiesResults.getOrDefault(entityClass, Collections.emptyList());
    }

    public boolean containsEntities() {
        return this.entitiesResults.entrySet().stream().anyMatch(entry -> !((Collection)entry.getValue()).isEmpty());
    }

    GroupedEntities(Map<Class<?>, Collection<?>> entitiesResults) {
        this.entitiesResults = entitiesResults;
    }

    public static GroupedEntitiesBuilder builder() {
        return new GroupedEntitiesBuilder();
    }

    public static class GroupedEntitiesBuilder {
        private Map<Class<?>, Collection<?>> entitiesResults = new HashMap();

        public <T> GroupedEntitiesBuilder entity(Class<T> key, T entity) {
            this.entitiesResults.compute(key, (k, v) -> {
                if (v == null) {
                    return new ArrayList<Object>(Collections.singletonList(entity));
                }
                v.add(entity);
                return v;
            });
            return this;
        }

        public GroupedEntitiesBuilder entities(Map<Class<?>, Collection<?>> keysMap) {
            this.entitiesResults = keysMap;
            return this;
        }

        GroupedEntitiesBuilder() {
        }

        public GroupedEntitiesBuilder entitiesResults(Map<Class<?>, Collection<?>> entitiesResults) {
            this.entitiesResults = entitiesResults;
            return this;
        }

        public GroupedEntities build() {
            return new GroupedEntities(this.entitiesResults);
        }

        public String toString() {
            return "GroupedEntities.GroupedEntitiesBuilder(entitiesResults=" + this.entitiesResults + ")";
        }
    }
}

