/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.Value;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.query.Filter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Qualifier
implements CriteriaDefinition,
Map<String, Object>,
Serializable {
    protected static final String FIELD = "field";
    protected static final String METADATA_FIELD = "metadata_field";
    protected static final String SINGLE_ID_FIELD = "id";
    protected static final String MULTIPLE_IDS_FIELD = "ids";
    protected static final String IGNORE_CASE = "ignoreCase";
    protected static final String VALUE1 = "value1";
    protected static final String VALUE2 = "value2";
    protected static final String VALUE3 = "value3";
    protected static final String DOT_PATH = "dotPath";
    protected static final String CONVERTER = "converter";
    protected static final String QUALIFIERS = "qualifiers";
    protected static final String OPERATION = "operation";
    protected static final String AS_FILTER = "queryAsFilter";
    private static final long serialVersionUID = -2689196529952712849L;
    protected final Map<String, Object> internalMap = new HashMap<String, Object>();

    protected Qualifier(Builder builder) {
        if (!builder.getMap().isEmpty()) {
            this.internalMap.putAll(builder.getMap());
        }
    }

    protected Qualifier(Qualifier qualifier) {
        if (!qualifier.getMap().isEmpty()) {
            this.internalMap.putAll(qualifier.getMap());
        }
    }

    @Override
    public Qualifier getCriteriaObject() {
        return this;
    }

    @Override
    public String getKey() {
        return this.getField();
    }

    private Map<String, Object> getMap() {
        return Collections.unmodifiableMap(this.internalMap);
    }

    public static QualifierBuilder builder() {
        return new QualifierBuilder();
    }

    public static MetadataQualifierBuilder metadataBuilder() {
        return new MetadataQualifierBuilder();
    }

    public FilterOperation getOperation() {
        return (FilterOperation)((Object)this.internalMap.get(OPERATION));
    }

    public String getField() {
        return (String)this.internalMap.get(FIELD);
    }

    public CriteriaDefinition.AerospikeMetadata getMetadataField() {
        return (CriteriaDefinition.AerospikeMetadata)((Object)this.internalMap.get(METADATA_FIELD));
    }

    public void setQueryAsFilter(Boolean queryAsFilter) {
        this.internalMap.put(AS_FILTER, queryAsFilter);
    }

    public Boolean queryAsFilter() {
        return this.internalMap.containsKey(AS_FILTER) && (Boolean)this.internalMap.get(AS_FILTER) != false;
    }

    public boolean hasQualifiers() {
        return this.internalMap.get(QUALIFIERS) != null;
    }

    public boolean hasId() {
        return this.internalMap.get(SINGLE_ID_FIELD) != null || this.internalMap.get(MULTIPLE_IDS_FIELD) != null;
    }

    public boolean hasSingleId() {
        return this.internalMap.get(SINGLE_ID_FIELD) != null;
    }

    public Object getId() {
        return this.hasSingleId() ? this.internalMap.get(SINGLE_ID_FIELD) : this.internalMap.get(MULTIPLE_IDS_FIELD);
    }

    public Qualifier[] getQualifiers() {
        return (Qualifier[])this.internalMap.get(QUALIFIERS);
    }

    public Value getValue1() {
        return (Value)this.internalMap.get(VALUE1);
    }

    public Value getValue2() {
        return (Value)this.internalMap.get(VALUE2);
    }

    public List<String> getDotPath() {
        return (List)this.internalMap.get(DOT_PATH);
    }

    public Filter setQueryAsFilter() {
        return FilterOperation.valueOf(this.getOperation().toString()).sIndexFilter(this.internalMap);
    }

    public Exp toFilterExp() {
        return FilterOperation.valueOf(this.getOperation().toString()).filterExp(this.internalMap);
    }

    protected String luaFieldString(String field) {
        return String.format("rec['%s']", field);
    }

    protected String luaValueString(Value value) {
        if (null == value) {
            return null;
        }
        int type = value.getType();
        return switch (type) {
            case 3, 23 -> String.format("'%s'", value);
            default -> value.toString();
        };
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.internalMap.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.internalMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.internalMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.internalMap.putAll(m);
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.internalMap.entrySet();
    }

    public String toString() {
        if (!StringUtils.hasLength((String)this.getField()) && StringUtils.hasLength((String)this.getMetadataField().toString())) {
            return String.format("%s:%s:%s:%s", new Object[]{this.getField(), this.getOperation(), this.getValue1(), this.getValue2()});
        }
        return String.format("(metadata)%s:%s:%s:%s", new Object[]{this.getMetadataField().toString(), this.getOperation(), this.getValue1(), this.getValue2()});
    }

    public static Qualifier idEquals(String id) {
        return new Qualifier((Builder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(Short id) {
        return new Qualifier((Builder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(Integer id) {
        return new Qualifier((Builder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(Long id) {
        return new Qualifier((Builder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(Character id) {
        return new Qualifier((Builder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(Byte id) {
        return new Qualifier((Builder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(byte[] id) {
        return new Qualifier((Builder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(String ... ids) {
        return new Qualifier((Builder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(Short ... ids) {
        return new Qualifier((Builder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(Integer ... ids) {
        return new Qualifier((Builder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(Long ... ids) {
        return new Qualifier((Builder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(Character ... ids) {
        return new Qualifier((Builder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(Byte ... ids) {
        return new Qualifier((Builder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(byte[] ... ids) {
        return new Qualifier((Builder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier or(Qualifier ... qualifiers) {
        return new Qualifier(((ConjunctionQualifierBuilder)new ConjunctionQualifierBuilder().setFilterOperation(FilterOperation.OR)).setQualifiers(qualifiers));
    }

    public static Qualifier and(Qualifier ... qualifiers) {
        return new Qualifier(((ConjunctionQualifierBuilder)new ConjunctionQualifierBuilder().setFilterOperation(FilterOperation.AND)).setQualifiers(qualifiers));
    }

    protected static interface Builder {
        public Map<String, Object> getMap();

        public Qualifier build();
    }

    public static class QualifierBuilder
    extends BaseQualifierBuilder<QualifierBuilder> {
        private QualifierBuilder() {
        }

        public QualifierBuilder setIgnoreCase(boolean ignoreCase) {
            this.map.put(Qualifier.IGNORE_CASE, ignoreCase);
            return this;
        }

        public QualifierBuilder setField(String field) {
            this.map.put(Qualifier.FIELD, field);
            return this;
        }

        public QualifierBuilder setValue1(Value value1) {
            this.map.put(Qualifier.VALUE1, value1);
            return this;
        }

        public QualifierBuilder setValue2(Value value2) {
            this.map.put(Qualifier.VALUE2, value2);
            return this;
        }

        public QualifierBuilder setValue3(Value value3) {
            this.map.put(Qualifier.VALUE3, value3);
            return this;
        }

        public boolean hasValue3() {
            return this.map.get(Qualifier.VALUE3) != null;
        }

        public void setDotPath(List<String> dotPath) {
            this.map.put(Qualifier.DOT_PATH, dotPath);
        }

        public QualifierBuilder setConverter(MappingAerospikeConverter converter) {
            this.map.put(Qualifier.CONVERTER, converter);
            return this;
        }
    }

    public static class MetadataQualifierBuilder
    extends BaseQualifierBuilder<MetadataQualifierBuilder> {
        private MetadataQualifierBuilder() {
        }

        public CriteriaDefinition.AerospikeMetadata getMetadataField() {
            return (CriteriaDefinition.AerospikeMetadata)((Object)this.map.get(Qualifier.METADATA_FIELD));
        }

        public MetadataQualifierBuilder setMetadataField(CriteriaDefinition.AerospikeMetadata metadataField) {
            this.map.put(Qualifier.METADATA_FIELD, metadataField);
            return this;
        }

        public Object getValue1AsObj() {
            return this.map.get(Qualifier.VALUE1);
        }

        public MetadataQualifierBuilder setValue1AsObj(Object object) {
            this.map.put(Qualifier.VALUE1, object);
            return this;
        }

        public Object getValue2AsObj() {
            return this.map.get(Qualifier.VALUE2);
        }

        public MetadataQualifierBuilder setValue2AsObj(Object object) {
            this.map.put(Qualifier.VALUE2, object);
            return this;
        }

        @Override
        protected void validate() {
            if (this.getMetadataField() != null) {
                if (this.getField() == null) {
                    FilterOperation operation = this.getFilterOperation();
                    switch (operation) {
                        case EQ: 
                        case NOTEQ: 
                        case LT: 
                        case LTEQ: 
                        case GT: 
                        case GTEQ: {
                            Assert.isTrue((boolean)(this.getValue1AsObj() instanceof Long), (String)(operation.name() + ": value1 is expected to be set as Long"));
                            break;
                        }
                        case BETWEEN: {
                            Assert.isTrue((boolean)(this.getValue1AsObj() instanceof Long), (String)"BETWEEN: value1 is expected to be set as Long");
                            Assert.isTrue((boolean)(this.getValue2AsObj() instanceof Long), (String)"BETWEEN: value2 is expected to be set as Long");
                            break;
                        }
                        case NOT_IN: 
                        case IN: {
                            Assert.isTrue((this.getValue1AsObj() instanceof Collection && !((Collection)this.getValue1AsObj()).isEmpty() && ((Collection)this.getValue1AsObj()).toArray()[0] instanceof Long ? 1 : 0) != 0, (String)(operation.name() + ": value1 is expected to be a non-empty Collection<Long>"));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Operation " + operation + " cannot be applied to metadataField");
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Either a field or a metadataField must be set, not both");
                }
            }
        }
    }

    private static class IdQualifierBuilder
    extends BaseQualifierBuilder<IdQualifierBuilder> {
        private IdQualifierBuilder() {
        }

        private IdQualifierBuilder setId(String id) {
            this.map.put(Qualifier.SINGLE_ID_FIELD, id);
            return this;
        }

        private IdQualifierBuilder setId(Short id) {
            this.map.put(Qualifier.SINGLE_ID_FIELD, id);
            return this;
        }

        private IdQualifierBuilder setId(Integer id) {
            this.map.put(Qualifier.SINGLE_ID_FIELD, id);
            return this;
        }

        private IdQualifierBuilder setId(Long id) {
            this.map.put(Qualifier.SINGLE_ID_FIELD, id);
            return this;
        }

        private IdQualifierBuilder setId(Character id) {
            this.map.put(Qualifier.SINGLE_ID_FIELD, id);
            return this;
        }

        private IdQualifierBuilder setId(Byte id) {
            this.map.put(Qualifier.SINGLE_ID_FIELD, id);
            return this;
        }

        private IdQualifierBuilder setId(byte[] id) {
            this.map.put(Qualifier.SINGLE_ID_FIELD, id);
            return this;
        }

        private IdQualifierBuilder setIds(String ... ids) {
            this.map.put(Qualifier.MULTIPLE_IDS_FIELD, ids);
            return this;
        }

        private IdQualifierBuilder setIds(Short ... ids) {
            this.map.put(Qualifier.MULTIPLE_IDS_FIELD, ids);
            return this;
        }

        private IdQualifierBuilder setIds(Integer ... ids) {
            this.map.put(Qualifier.MULTIPLE_IDS_FIELD, ids);
            return this;
        }

        private IdQualifierBuilder setIds(Long ... ids) {
            this.map.put(Qualifier.MULTIPLE_IDS_FIELD, ids);
            return this;
        }

        private IdQualifierBuilder setIds(Character ... ids) {
            this.map.put(Qualifier.MULTIPLE_IDS_FIELD, ids);
            return this;
        }

        private IdQualifierBuilder setIds(Byte ... ids) {
            this.map.put(Qualifier.MULTIPLE_IDS_FIELD, ids);
            return this;
        }

        private IdQualifierBuilder setIds(byte[] ... ids) {
            this.map.put(Qualifier.MULTIPLE_IDS_FIELD, ids);
            return this;
        }
    }

    protected static abstract class BaseQualifierBuilder<T extends BaseQualifierBuilder<?>>
    implements Builder {
        protected final Map<String, Object> map = new HashMap<String, Object>();

        protected BaseQualifierBuilder() {
        }

        public FilterOperation getFilterOperation() {
            return (FilterOperation)((Object)this.map.get(Qualifier.OPERATION));
        }

        public T setFilterOperation(FilterOperation filterOperation) {
            this.map.put(Qualifier.OPERATION, (Object)filterOperation);
            return (T)this;
        }

        public String getField() {
            return (String)this.map.get(Qualifier.FIELD);
        }

        public boolean hasValue1() {
            return this.map.get(Qualifier.VALUE1) != null;
        }

        public boolean hasValue2() {
            return this.map.get(Qualifier.VALUE2) != null;
        }

        public boolean hasDotPath() {
            return this.map.get(Qualifier.DOT_PATH) != null;
        }

        @Override
        public Qualifier build() {
            this.validate();
            return new Qualifier(this);
        }

        @Override
        public Map<String, Object> getMap() {
            return Collections.unmodifiableMap(this.map);
        }

        protected void validate() {
        }
    }

    private static class ConjunctionQualifierBuilder
    extends BaseQualifierBuilder<ConjunctionQualifierBuilder> {
        private ConjunctionQualifierBuilder() {
        }

        private ConjunctionQualifierBuilder setQualifiers(Qualifier ... qualifiers) {
            this.map.put(Qualifier.QUALIFIERS, qualifiers);
            return this;
        }

        private Qualifier[] getQualifiers() {
            return (Qualifier[])this.map.get(Qualifier.QUALIFIERS);
        }

        @Override
        protected void validate() {
            Assert.notNull((Object)this.getQualifiers(), (String)"Qualifiers must not be null");
            Assert.notEmpty((Object[])this.getQualifiers(), (String)"Qualifiers must not be empty");
            Assert.isTrue((this.getQualifiers().length > 1 ? 1 : 0) != 0, (String)"There must be at least 2 qualifiers");
        }
    }
}

