/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;

public final class QualifierUtils {
    public static Qualifier getIdQualifier(Qualifier qualifier) {
        if (qualifier != null) {
            List<Qualifier> idQualifiers = QualifierUtils.getIdQualifiers(qualifier);
            if (idQualifiers.size() > 1) {
                throw new IllegalArgumentException("Expecting not more than one id qualifier in qualifiers array, got " + idQualifiers.size());
            }
            if (idQualifiers.size() == 1) {
                return idQualifiers.get(0);
            }
        }
        return null;
    }

    private static List<Qualifier> getIdQualifiers(Qualifier ... qualifiers) {
        ArrayList<Qualifier> idQualifiers = new ArrayList<Qualifier>();
        for (Qualifier qualifier : qualifiers) {
            if (qualifier.hasId()) {
                idQualifiers.add(qualifier);
                continue;
            }
            if (!qualifier.hasQualifiers()) continue;
            idQualifiers.addAll(QualifierUtils.getIdQualifiers(qualifier.getQualifiers()));
        }
        return idQualifiers;
    }

    public static boolean queryCriteriaIsNotNull(Query query) {
        return query != null && query.getCriteria() != null;
    }

    private QualifierUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

