/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.Key;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.Statement;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import java.util.Objects;
import org.springframework.data.aerospike.query.FilterExpressionsBuilder;
import org.springframework.data.aerospike.query.KeyQualifier;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.StatementBuilder;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorQueryEngine {
    private final IAerospikeReactorClient client;
    private final StatementBuilder statementBuilder;
    private final FilterExpressionsBuilder filterExpressionsBuilder;
    private boolean scansEnabled;
    private long queryMaxRecords;

    public ReactorQueryEngine(IAerospikeReactorClient client, StatementBuilder statementBuilder, FilterExpressionsBuilder filterExpressionsBuilder) {
        this.client = client;
        this.statementBuilder = statementBuilder;
        this.filterExpressionsBuilder = filterExpressionsBuilder;
    }

    public Flux<KeyRecord> select(String namespace, String set, @Nullable Query query) {
        return this.select(namespace, set, null, query);
    }

    public Flux<KeyRecord> select(String namespace, String set, String[] binNames, @Nullable Query query) {
        Qualifier qualifier;
        Qualifier qualifier2 = qualifier = QualifierUtils.queryCriteriaIsNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier instanceof KeyQualifier) {
            KeyQualifier kq = (KeyQualifier)qualifier;
            Key key = kq.makeKey(namespace, set);
            return Flux.from(this.getRecord(null, key, binNames)).filter(keyRecord -> Objects.nonNull(keyRecord.record));
        }
        Statement statement = this.statementBuilder.build(namespace, set, query, binNames);
        statement.setMaxRecords(this.queryMaxRecords);
        QueryPolicy localQueryPolicy = this.getQueryPolicy(query, true);
        if (!this.scansEnabled && statement.getFilter() == null) {
            return Flux.error((Throwable)new IllegalStateException("Query without a filter will initiate a scan. Since scans are potentially dangerous operations, they are disabled by default in spring-data-aerospike. If you still need to use them, enable them via `scansEnabled` property in `org.springframework.data.aerospike.config.AerospikeDataSettings`."));
        }
        return this.client.query(localQueryPolicy, statement);
    }

    public Flux<KeyRecord> selectForCount(String namespace, String set, @Nullable Query query) {
        Statement statement = this.statementBuilder.build(namespace, set, query);
        statement.setMaxRecords(this.queryMaxRecords);
        QueryPolicy localQueryPolicy = this.getQueryPolicy(query, false);
        if (!this.scansEnabled && statement.getFilter() == null) {
            return Flux.error((Throwable)new IllegalStateException("Query without a filter will initiate a scan. Since scans are potentially dangerous operations, they are disabled by default in spring-data-aerospike. If you still need to use them, enable them via `scansEnabled` property in `org.springframework.data.aerospike.config.AerospikeDataSettings`."));
        }
        return this.client.query(localQueryPolicy, statement);
    }

    private QueryPolicy getQueryPolicy(Query query, boolean includeBins) {
        QueryPolicy queryPolicy = new QueryPolicy(this.client.getQueryPolicyDefault());
        queryPolicy.filterExp = this.filterExpressionsBuilder.build(query);
        queryPolicy.includeBinData = includeBins;
        return queryPolicy;
    }

    private Mono<KeyRecord> getRecord(Policy policy, Key key, String[] binNames) {
        if (binNames == null || binNames.length == 0) {
            return this.client.get(policy, key);
        }
        return this.client.get(policy, key, binNames);
    }

    public FilterExpressionsBuilder getFilterExpressionsBuilder() {
        return this.filterExpressionsBuilder;
    }

    public void setScansEnabled(boolean scansEnabled) {
        this.scansEnabled = scansEnabled;
    }

    public void setQueryMaxRecords(long queryMaxRecords) {
        this.queryMaxRecords = queryMaxRecords;
    }

    public long getQueryMaxRecords() {
        return this.queryMaxRecords;
    }
}

