/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.query.Filter;
import com.aerospike.client.query.Statement;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.cache.IndexesCache;
import org.springframework.data.aerospike.query.model.Index;
import org.springframework.data.aerospike.query.model.IndexedField;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class StatementBuilder {
    private static final Logger log = LoggerFactory.getLogger(StatementBuilder.class);
    private final IndexesCache indexesCache;

    public StatementBuilder(IndexesCache indexesCache) {
        this.indexesCache = indexesCache;
    }

    public Statement build(String namespace, String set, Query query) {
        return this.build(namespace, set, query, null);
    }

    public Statement build(String namespace, String set, @Nullable Query query, String[] binNames) {
        Statement stmt = new Statement();
        stmt.setNamespace(namespace);
        stmt.setSetName(set);
        if (binNames != null && binNames.length != 0) {
            stmt.setBinNames(binNames);
        }
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            this.setStatementFilterFromQualifiers(stmt, query.getCriteriaObject());
        }
        return stmt;
    }

    private void setStatementFilterFromQualifiers(Statement stmt, Qualifier qualifier) {
        if (qualifier == null) {
            return;
        }
        if (qualifier.getOperation() == FilterOperation.AND) {
            this.setFilterFromMultipleQualifiers(stmt, qualifier);
        } else if (this.isIndexedBin(stmt, qualifier)) {
            this.setFilterFromSingleQualifier(stmt, qualifier);
        }
    }

    private void setFilterFromMultipleQualifiers(Statement stmt, Qualifier qualifier) {
        int minBinValuesRatio = Integer.MAX_VALUE;
        Qualifier minBinValuesRatioQualifier = null;
        for (Qualifier innerQualifier : qualifier.getQualifiers()) {
            int currBinValuesRatio;
            if (innerQualifier == null || !this.isIndexedBin(stmt, innerQualifier) || (currBinValuesRatio = this.getMinBinValuesRatioForQualifier(stmt, innerQualifier)) == 0 || currBinValuesRatio >= minBinValuesRatio) continue;
            minBinValuesRatio = currBinValuesRatio;
            minBinValuesRatioQualifier = innerQualifier;
        }
        if (minBinValuesRatioQualifier != null) {
            this.setFilterFromSingleQualifier(stmt, minBinValuesRatioQualifier);
        } else {
            for (Qualifier innerQualifier : qualifier.getQualifiers()) {
                Filter filter;
                if (innerQualifier == null || !this.isIndexedBin(stmt, innerQualifier) || (filter = innerQualifier.setQueryAsFilter()) == null) continue;
                stmt.setFilter(filter);
                innerQualifier.setQueryAsFilter(true);
                break;
            }
        }
    }

    private void setFilterFromSingleQualifier(Statement stmt, Qualifier qualifier) {
        Filter filter = qualifier.setQueryAsFilter();
        if (filter != null) {
            stmt.setFilter(filter);
            qualifier.setQueryAsFilter(true);
        }
    }

    private boolean isIndexedBin(Statement stmt, Qualifier qualifier) {
        boolean hasIndex = false;
        boolean hasField = false;
        if (StringUtils.hasLength((String)qualifier.getField())) {
            hasField = true;
            hasIndex = this.indexesCache.hasIndexFor(new IndexedField(stmt.getNamespace(), stmt.getSetName(), qualifier.getField()));
        }
        if (log.isDebugEnabled() && hasField) {
            log.debug("Bin {}.{}.{} has secondary index: {}", new Object[]{stmt.getNamespace(), stmt.getSetName(), qualifier.getField(), hasIndex});
        }
        return hasIndex;
    }

    private int getMinBinValuesRatioForQualifier(Statement stmt, Qualifier qualifier) {
        List<Index> indexList = this.indexesCache.getAllIndexesForField(new IndexedField(stmt.getNamespace(), stmt.getSetName(), qualifier.getField()));
        Optional<Index> minBinValuesRatio = indexList.stream().filter(index -> index.getBinValuesRatio() != 0).min(Comparator.comparing(Index::getBinValuesRatio));
        return minBinValuesRatio.map(Index::getBinValuesRatio).orElse(0);
    }
}

