/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.cache;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.InfoPolicy;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.query.cache.IndexesCacheUpdater;
import org.springframework.data.aerospike.query.cache.InternalIndexOperations;
import org.springframework.data.aerospike.query.model.IndexesInfo;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;

public class IndexRefresher {
    public static final String INDEX_CACHE_REFRESH_SECONDS = "index.cache.refresh.seconds";
    private final Logger log = LoggerFactory.getLogger(IndexRefresher.class);
    private final IAerospikeClient client;
    private final InfoPolicy infoPolicy;
    private final ServerVersionSupport serverVersionSupport;
    private final InternalIndexOperations indexOperations;
    private final IndexesCacheUpdater indexesCacheUpdater;
    private final ScheduledExecutorService executorService;

    public IndexRefresher(IAerospikeClient client, InfoPolicy infoPolicy, InternalIndexOperations indexOperations, IndexesCacheUpdater indexesCacheUpdater, ServerVersionSupport serverVersionSupport) {
        this.client = client;
        this.infoPolicy = infoPolicy;
        this.indexOperations = indexOperations;
        this.indexesCacheUpdater = indexesCacheUpdater;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.serverVersionSupport = serverVersionSupport;
    }

    public void scheduleRefreshIndexes(long intervalSeconds) {
        this.executorService.scheduleWithFixedDelay(this::refreshIndexes, intervalSeconds, intervalSeconds, TimeUnit.SECONDS);
    }

    public void refreshIndexes() {
        this.log.trace("Loading indexes");
        IndexesInfo cache = Arrays.stream(this.client.getNodes()).filter(Node::isActive).findAny().map(node -> Info.request((InfoPolicy)this.infoPolicy, (Node)node, (String)this.indexOperations.buildGetIndexesCommand())).map(response -> {
            IndexesInfo indexesInfo = this.indexOperations.parseIndexesInfo((String)response);
            this.indexOperations.enrichIndexesWithCardinality(this.client, indexesInfo.indexes, this.serverVersionSupport);
            return indexesInfo;
        }).orElse(IndexesInfo.empty());
        this.log.debug("Loaded indexes: {}", cache.indexes);
        this.indexesCacheUpdater.update(cache);
    }

    public void clearCache() {
        this.indexesCacheUpdater.update(IndexesInfo.empty());
    }
}

