/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.cache;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.InfoPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.query.cache.IndexInfoParser;
import org.springframework.data.aerospike.query.model.Index;
import org.springframework.data.aerospike.query.model.IndexKey;
import org.springframework.data.aerospike.query.model.IndexesInfo;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;

public class InternalIndexOperations {
    private static final Logger log = LoggerFactory.getLogger(InternalIndexOperations.class);
    private static final String SINDEX_WITH_BASE64 = "sindex-list:;b64=true";
    private final IndexInfoParser indexInfoParser;

    public InternalIndexOperations(IndexInfoParser indexInfoParser) {
        this.indexInfoParser = indexInfoParser;
    }

    private static IndexKey getIndexKey(Index index) {
        return new IndexKey(index.getNamespace(), index.getSet(), index.getBin(), index.getIndexType(), index.getIndexCollectionType(), index.getCtx());
    }

    public IndexesInfo parseIndexesInfo(String infoResponse) {
        if (infoResponse.isEmpty()) {
            return IndexesInfo.empty();
        }
        return IndexesInfo.of(Arrays.stream(infoResponse.split(";")).map(this.indexInfoParser::parse).collect(Collectors.collectingAndThen(Collectors.toMap(InternalIndexOperations::getIndexKey, index -> index), Collections::unmodifiableMap)));
    }

    public String buildGetIndexesCommand() {
        return SINDEX_WITH_BASE64;
    }

    public void enrichIndexesWithCardinality(IAerospikeClient client, Map<IndexKey, Index> indexes, ServerVersionSupport serverVersionSupport) {
        log.debug("Enriching secondary indexes with cardinality");
        indexes.values().forEach(index -> index.setBinValuesRatio(this.getIndexBinValuesRatio(client, serverVersionSupport, index.getNamespace(), index.getName())));
    }

    public int getIndexBinValuesRatio(IAerospikeClient client, ServerVersionSupport serverVersionSupport, String namespace, String indexName) {
        if (serverVersionSupport.sIndexCardinality()) {
            try {
                String indexStatData = Info.request((InfoPolicy)client.getInfoPolicyDefault(), (Node)client.getCluster().getRandomNode(), (String)String.format("sindex-stat:ns=%s;indexname=%s", namespace, indexName));
                return Integer.parseInt(Arrays.stream(indexStatData.split(";")).map(String::trim).toList().stream().map(stat -> Arrays.stream(stat.split("=")).map(String::trim).collect(Collectors.toList())).collect(Collectors.toMap(t -> (String)t.get(0), t -> (String)t.get(1))).get("entries_per_bval"));
            }
            catch (Exception e) {
                log.warn("Failed to fetch secondary index {} cardinality", (Object)indexName, (Object)e);
            }
        }
        return 0;
    }
}

