/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.Field;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

public class AerospikeQueryCreator
extends AbstractQueryCreator<Query, CriteriaDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(AerospikeQueryCreator.class);
    private final AerospikeMappingContext context;
    private final MappingAerospikeConverter converter;

    public AerospikeQueryCreator(PartTree tree, ParameterAccessor parameters, AerospikeMappingContext context, MappingAerospikeConverter converter) {
        super(tree, parameters);
        this.context = context;
        this.converter = converter;
    }

    protected CriteriaDefinition create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        return this.create(part, property, iterator);
    }

    private CriteriaDefinition create(Part part, AerospikePersistentProperty property, Iterator<?> parameters) {
        Object v1 = null;
        if (parameters.hasNext()) {
            v1 = parameters.next();
        }
        v1 = this.convertIfNecessary(v1);
        return switch (part.getType()) {
            case Part.Type.AFTER, Part.Type.GREATER_THAN -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.GT);
            case Part.Type.GREATER_THAN_EQUAL -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.GTEQ);
            case Part.Type.BEFORE, Part.Type.LESS_THAN -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.LT);
            case Part.Type.LESS_THAN_EQUAL -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.LTEQ);
            case Part.Type.BETWEEN -> this.getCriteria(part, property, v1, this.convertIfNecessary(parameters.next()), parameters, FilterOperation.BETWEEN);
            case Part.Type.LIKE, Part.Type.REGEX -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.LIKE);
            case Part.Type.STARTING_WITH -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.STARTS_WITH);
            case Part.Type.ENDING_WITH -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.ENDS_WITH);
            case Part.Type.CONTAINING -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.CONTAINING);
            case Part.Type.NOT_CONTAINING -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.NOT_CONTAINING);
            case Part.Type.WITHIN -> {
                v1 = Value.get((String)String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", v1, parameters.next(), parameters.next()));
                yield this.getCriteria(part, property, v1, parameters.next(), parameters, FilterOperation.GEO_WITHIN);
            }
            case Part.Type.SIMPLE_PROPERTY -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.EQ);
            case Part.Type.NEGATING_SIMPLE_PROPERTY -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.NOTEQ);
            case Part.Type.IN -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.IN);
            case Part.Type.NOT_IN -> this.getCriteria(part, property, v1, null, parameters, FilterOperation.NOT_IN);
            case Part.Type.TRUE -> this.getCriteria(part, property, true, null, parameters, FilterOperation.EQ);
            case Part.Type.FALSE -> this.getCriteria(part, property, false, null, parameters, FilterOperation.EQ);
            case Part.Type.EXISTS, Part.Type.IS_NOT_NULL -> this.getCriteria(part, property, null, null, parameters, FilterOperation.IS_NOT_NULL);
            case Part.Type.IS_NULL -> this.getCriteria(part, property, null, null, parameters, FilterOperation.IS_NULL);
            default -> throw new IllegalArgumentException("Unsupported keyword '" + part.getType() + "'");
        };
    }

    private Object convertIfNecessary(Object obj) {
        if (obj == null || obj instanceof CriteriaDefinition.AerospikeMapCriteria) {
            return obj;
        }
        Object value = obj;
        TypeInformation valueType = TypeInformation.of(value.getClass());
        return this.converter.toWritableValue(value, valueType);
    }

    public CriteriaDefinition getCriteria(Part part, AerospikePersistentProperty property, Object value1, Object value2, Iterator<?> parameters, FilterOperation op) {
        String fieldName = this.getFieldName(part.getProperty().getSegment(), property);
        Qualifier qualifier = property.isIdProperty() ? this.processId(value1) : (property.isCollectionLike() ? this.processCollection(part, value1, value2, parameters, op, fieldName) : (property.isMap() ? this.processMap(part, value1, value2, parameters, op, fieldName) : this.processOther(part, value1, value2, property, op, fieldName)));
        return qualifier;
    }

    private Qualifier processId(Object value1) {
        Qualifier qualifier;
        if (value1 instanceof Collection) {
            List<String> ids = ((Collection)value1).stream().map(String::valueOf).toList();
            qualifier = Qualifier.idIn((String[])ids.toArray(String[]::new));
        } else {
            qualifier = Qualifier.idEquals((String)value1);
        }
        return qualifier;
    }

    private Qualifier processCollection(Part part, Object value1, Object value2, Iterator<?> parameters, FilterOperation op, String fieldName) {
        Qualifier.QualifierBuilder qb = Qualifier.builder();
        ArrayList<Object> params = new ArrayList<Object>();
        parameters.forEachRemaining(params::add);
        if (!params.isEmpty()) {
            Object nextParam = params.get(params.size() - 1);
            if (op == FilterOperation.CONTAINING && !(nextParam instanceof CriteriaDefinition.AerospikeMapCriteria)) {
                op = FilterOperation.LIST_VAL_CONTAINING;
                params.add(0, value1);
                return this.qualifierAndConcatenated(params, qb, part, fieldName, op, null);
            }
        } else if (!(value1 instanceof Collection)) {
            op = this.getCorrespondingListFilterOperationOrFail(op);
        }
        return this.setQualifier(qb, fieldName, op, part, value1, value2, null, null);
    }

    private Qualifier processMap(Part part, Object value1, Object value2, Iterator<?> parameters, FilterOperation op, String fieldName) {
        ArrayList<Object> params = new ArrayList<Object>();
        parameters.forEachRemaining(params::add);
        Qualifier qualifier = null;
        if (params.size() == 1) {
            qualifier = this.processMap2Params(part, value1, value2, params, op, fieldName);
        } else if (params.isEmpty()) {
            if (op != FilterOperation.BETWEEN) {
                qualifier = this.setQualifier(Qualifier.builder(), fieldName, op, part, value1, Value.get((String)fieldName), null, null);
            }
        } else {
            qualifier = this.processMapMultipleParams(part, value1, value2, params, op, fieldName);
        }
        return qualifier;
    }

    private Qualifier processMap2Params(Part part, Object value1, Object value2, List<Object> params, FilterOperation op, String fieldName) {
        Object nextParam = this.convertIfNecessary(params.get(0));
        Qualifier qualifier = op == FilterOperation.CONTAINING ? this.processMapContaining(nextParam, part, value1, fieldName, FilterOperation.MAP_KEYS_CONTAIN, FilterOperation.MAP_VALUES_CONTAIN, FilterOperation.MAP_VAL_EQ_BY_KEY) : (op == FilterOperation.NOT_CONTAINING ? this.processMapContaining(nextParam, part, value1, fieldName, FilterOperation.MAP_KEYS_NOT_CONTAIN, FilterOperation.MAP_VALUES_NOT_CONTAIN, FilterOperation.MAP_VAL_NOTEQ_BY_KEY) : this.processMapBetween(part, value1, value2, op, fieldName, nextParam));
        return qualifier;
    }

    private Qualifier processMapContaining(Object nextParam, Part part, Object value1, String fieldName, FilterOperation keysOp, FilterOperation valuesOp, FilterOperation byKeyOp) {
        FilterOperation op;
        Qualifier.QualifierBuilder qb;
        List<String> dotPath;
        block5: {
            block4: {
                dotPath = null;
                qb = Qualifier.builder();
                if (!(nextParam instanceof CriteriaDefinition.AerospikeMapCriteria)) break block4;
                CriteriaDefinition.AerospikeMapCriteria onMap = (CriteriaDefinition.AerospikeMapCriteria)((Object)nextParam);
                switch (onMap) {
                    case KEY: {
                        op = keysOp;
                        break block5;
                    }
                    case VALUE: {
                        op = valuesOp;
                        break block5;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported parameter: " + onMap);
                    }
                }
            }
            op = byKeyOp;
            dotPath = List.of(part.getProperty().toDotPath(), Value.get((Object)value1).toString());
            this.setQbValuesForMapByKey(qb, value1, nextParam);
        }
        return this.setQualifier(qb, fieldName, op, part, value1, null, null, dotPath);
    }

    private Qualifier processMapBetween(Part part, Object value1, Object value2, FilterOperation op, String fieldName, Object nextParam) {
        Qualifier.QualifierBuilder qb = Qualifier.builder();
        List<String> dotPath = List.of(part.getProperty().toDotPath(), Value.get((Object)value1).toString());
        if (op == FilterOperation.BETWEEN) {
            op = this.getCorrespondingMapValueFilterOperationOrFail(op);
            qb.setValue2(Value.get((Object)value1));
            qb.setValue1(Value.get((Object)value2));
            qb.setValue3(Value.get((Object)nextParam));
        } else {
            if (op == FilterOperation.EQ) {
                throw new IllegalArgumentException("Unsupported arguments '" + value1 + "' and '" + nextParam + "', expecting Map argument in findByMapEquals queries");
            }
            op = this.getCorrespondingMapValueFilterOperationOrFail(op);
            this.setQbValuesForMapByKey(qb, value1, nextParam);
        }
        return this.setQualifier(qb, fieldName, op, part, value1, value2, null, dotPath);
    }

    private Qualifier processMapMultipleParams(Part part, Object value1, Object value2, List<Object> params, FilterOperation op, String fieldName) {
        if (op == FilterOperation.CONTAINING) {
            return this.processMapMultipleParamsContaining(part, value1, value2, params, op, fieldName);
        }
        String paramsString = params.stream().map(Object::toString).collect(Collectors.joining(", "));
        throw new IllegalArgumentException("Expected not more than 2 arguments (propertyType: Map, filterOperation: " + op + "),  got " + (params.size() + 1) + " instead: '" + value1 + ", " + paramsString + "'");
    }

    private Qualifier processMapMultipleParamsContaining(Part part, Object value1, Object value2, List<Object> params, FilterOperation op, String fieldName) {
        List<String> dotPath = null;
        Qualifier.QualifierBuilder qb = Qualifier.builder();
        Object object = params.get(params.size() - 1);
        if (object instanceof CriteriaDefinition.AerospikeMapCriteria) {
            CriteriaDefinition.AerospikeMapCriteria mapCriteria = (CriteriaDefinition.AerospikeMapCriteria)((Object)object);
            switch (mapCriteria) {
                case KEY: {
                    op = FilterOperation.MAP_KEYS_CONTAIN;
                    break;
                }
                case VALUE: {
                    op = FilterOperation.MAP_VALUES_CONTAIN;
                    break;
                }
                case VALUE_CONTAINING: {
                    op = FilterOperation.MAP_VAL_CONTAINING_BY_KEY;
                }
            }
            params = params.stream().limit((long)params.size() - 1L).collect(Collectors.toList());
        } else {
            op = FilterOperation.MAP_VAL_EQ_BY_KEY;
            dotPath = List.of(part.getProperty().toDotPath(), Value.get((Object)value1).toString());
        }
        params.add(0, value1);
        if (op == FilterOperation.MAP_VAL_CONTAINING_BY_KEY || op == FilterOperation.MAP_VAL_EQ_BY_KEY) {
            return this.processMapMultipleParamsContainingPerSize(params, qb, part, value1, value2, fieldName, op, dotPath);
        }
        return this.qualifierAndConcatenated(params, qb, part, fieldName, op, dotPath);
    }

    private Qualifier processMapMultipleParamsContainingPerSize(List<Object> params, Qualifier.QualifierBuilder qb, Part part, Object value1, Object value2, String fieldName, FilterOperation op, List<String> dotPath) {
        if (params.size() > 2) {
            if ((params.size() & 1) != 0) {
                throw new IllegalArgumentException("FindByMapContaining: expected either one, two or even number of key/value arguments, instead got " + params.size());
            }
            return this.qualifierAndConcatenated(params, qb, part, fieldName, op, dotPath, true);
        }
        if (params.size() == 2) {
            this.setQbValuesForMapByKey(qb, params.get(0), params.get(1));
            return this.setQualifier(qb, fieldName, op, part, value1, value2, null, null);
        }
        throw new UnsupportedOperationException("Unsupported combination of operation " + op + " and parameters with size of + " + params.size());
    }

    private Qualifier processOther(Part part, Object value1, Object value2, AerospikePersistentProperty property, FilterOperation op, String fieldName) {
        List<String> dotPath = null;
        Value value3 = null;
        Qualifier.QualifierBuilder qb = Qualifier.builder();
        if (part.getProperty().hasNext()) {
            if (op == FilterOperation.BETWEEN) {
                value3 = Value.get((Object)value2);
            } else if (op == FilterOperation.IS_NOT_NULL || op == FilterOperation.IS_NULL) {
                value1 = Value.get((String)property.getFieldName());
            }
            op = this.getCorrespondingMapValueFilterOperationOrFail(op);
            value2 = Value.get((String)property.getFieldName());
            dotPath = List.of(part.getProperty().toDotPath());
        } else if (this.isPojo(part) && op != FilterOperation.BETWEEN) {
            value2 = Value.get((String)property.getFieldName());
        }
        return this.setQualifier(qb, fieldName, op, part, value1, value2, value3, dotPath);
    }

    private String getFieldName(String segmentName, AerospikePersistentProperty property) {
        Field annotation = (Field)property.findAnnotation(Field.class);
        if (annotation != null && StringUtils.hasText((String)annotation.value())) {
            return annotation.value();
        }
        if (!StringUtils.hasText((String)segmentName)) {
            throw new IllegalStateException("Segment name is null or empty");
        }
        return segmentName;
    }

    private Qualifier qualifierAndConcatenated(List<Object> params, Qualifier.QualifierBuilder qb, Part part, String fieldName, FilterOperation op, List<String> dotPath) {
        return this.qualifierAndConcatenated(params, qb, part, fieldName, op, dotPath, false);
    }

    private Qualifier qualifierAndConcatenated(List<Object> params, Qualifier.QualifierBuilder qb, Part part, String fieldName, FilterOperation op, List<String> dotPath, boolean containingMapKeyValuePairs) {
        if (containingMapKeyValuePairs) {
            Qualifier[] qualifiers = new Qualifier[params.size() / 2];
            int i = 0;
            int j = 0;
            while (i < params.size()) {
                this.setQbValuesForMapByKey(qb, params.get(i), params.get(i + 1));
                qualifiers[j] = this.setQualifier(qb, fieldName, op, part, params.get(i), null, null, dotPath);
                i += 2;
                ++j;
            }
            return Qualifier.and(qualifiers);
        }
        Qualifier[] qualifiers = new Qualifier[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            this.setQbValuesForMapByKey(qb, params.get(i), params.get(i));
            qualifiers[i] = this.setQualifier(qb, fieldName, op, part, params.get(i), null, null, dotPath);
        }
        return Qualifier.and(qualifiers);
    }

    private Qualifier setQualifier(Qualifier.QualifierBuilder qb, String fieldName, FilterOperation op, Part part, Object value1, Object value2, Object value3, List<String> dotPath) {
        ((Qualifier.QualifierBuilder)qb.setField(fieldName).setFilterOperation(op)).setIgnoreCase(this.ignoreCaseToBoolean(part)).setConverter(this.converter);
        this.setNotNullQbValues(qb, value1, value2, value3, dotPath);
        return qb.build();
    }

    private FilterOperation getCorrespondingMapValueFilterOperationOrFail(FilterOperation op) {
        try {
            return FilterOperation.valueOf("MAP_VAL_" + op + "_BY_KEY");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot find corresponding MAP_VAL_..._BY_KEY FilterOperation for '" + op + "'");
        }
    }

    private FilterOperation getCorrespondingListFilterOperationOrFail(FilterOperation op) {
        try {
            return FilterOperation.valueOf("LIST_VAL_" + op);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot find corresponding LIST_VAL_... FilterOperation for '" + op + "'");
        }
    }

    private void setNotNullQbValues(Qualifier.QualifierBuilder qb, Object v1, Object v2, Object v3, List<String> dotPath) {
        if (v1 != null && !qb.hasValue1()) {
            qb.setValue1(Value.get((Object)v1));
        }
        if (v2 != null && !qb.hasValue2()) {
            qb.setValue2(Value.get((Object)v2));
        }
        if (v3 != null && !qb.hasValue3()) {
            qb.setValue3(Value.get((Object)v3));
        }
        if (dotPath != null && !qb.hasDotPath()) {
            qb.setDotPath(dotPath);
        }
    }

    private void setQbValuesForMapByKey(Qualifier.QualifierBuilder qb, Object key, Object value) {
        qb.setValue1(Value.get((Object)value));
        qb.setValue2(Value.get((Object)key));
    }

    private boolean isPojo(Part part) {
        TypeInformation type = TypeInformation.of((Class)part.getProperty().getType());
        return !this.converter.getCustomConversions().isSimpleType(part.getProperty().getType()) && !type.isCollectionLike();
    }

    protected CriteriaDefinition and(Part part, CriteriaDefinition base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        return Qualifier.and(base.getCriteriaObject(), this.create(part, property, iterator).getCriteriaObject());
    }

    protected CriteriaDefinition or(CriteriaDefinition base, CriteriaDefinition criteria) {
        return Qualifier.or(base.getCriteriaObject(), criteria.getCriteriaObject());
    }

    protected Query complete(CriteriaDefinition criteria, Sort sort) {
        Query query;
        Query query2 = query = criteria == null ? null : new Query(criteria).with(sort);
        if (LOG.isDebugEnabled() && criteria != null) {
            this.logQualifierDetails(criteria);
        }
        return query;
    }

    private void logQualifierDetails(CriteriaDefinition criteria) {
        Qualifier qualifier = criteria.getCriteriaObject();
        Qualifier[] qualifiers = qualifier.getQualifiers();
        if (qualifiers != null && qualifiers.length > 0) {
            Arrays.stream(qualifiers).forEach(this::logQualifierDetails);
        }
        String field = StringUtils.hasLength((String)qualifier.getField()) ? qualifier.getField() : "";
        String operation = StringUtils.hasLength((String)qualifier.getOperation().toString()) ? qualifier.getOperation().toString() : "N/A";
        String value1 = qualifier.getValue1() != null && !qualifier.getValue1().toString().isEmpty() ? qualifier.getValue1().toString() : "";
        String value2 = qualifier.getValue2() != null && !qualifier.getValue2().toString().isEmpty() ? qualifier.getValue2().toString() : "";
        LOG.debug("Created query: {} {} {} {}", new Object[]{field, operation, value1, value2});
    }

    private boolean ignoreCaseToBoolean(Part part) {
        return switch (part.shouldIgnoreCase()) {
            case Part.IgnoreCaseType.WHEN_POSSIBLE -> {
                if (part.getProperty().getType() == String.class) {
                    yield true;
                }
                yield false;
            }
            case Part.IgnoreCaseType.ALWAYS -> true;
            default -> false;
        };
    }
}

