/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeCriteria;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.domain.Sort;

public class Query {
    private static final int NOT_SPECIFIED = -1;
    private Sort sort;
    private long offset = -1L;
    private int rows = -1;
    private CriteriaDefinition criteria;
    private boolean isDistinct;

    public Query(CriteriaDefinition criteria) {
        this.criteria = criteria;
    }

    @Deprecated(since="4.6.0", forRemoval=true)
    public Query(Sort sort) {
        this.sort = sort;
    }

    public CriteriaDefinition getCriteria() {
        return this.criteria;
    }

    @Deprecated(since="4.6.0", forRemoval=true)
    public AerospikeCriteria getAerospikeCriteria() {
        return (AerospikeCriteria)this.criteria;
    }

    public Qualifier getCriteriaObject() {
        return this.criteria.getCriteriaObject();
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public boolean hasOffset() {
        return this.offset != -1L;
    }

    public boolean hasRows() {
        return this.rows != -1;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public Query orderBy(Sort sort) {
        if (sort == null) {
            return this;
        }
        if (this.sort != null) {
            this.sort.and(sort);
        } else {
            this.sort = sort;
        }
        return this;
    }

    public Query skip(long offset) {
        this.setOffset(offset);
        return this;
    }

    public Query limit(int rows) {
        this.setRows(rows);
        return this;
    }

    public Query with(Sort sort) {
        if (sort == null) {
            return this;
        }
        for (Sort.Order order : sort) {
            if (!order.isIgnoreCase()) continue;
            throw new IllegalArgumentException(String.format("Given sort contained an Order for %s with ignore case! Aerospike does not support sorting ignoring case currently!", order.getProperty()));
        }
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return this;
    }

    public void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }
}

