/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.utility;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Node;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.aerospike.utility.InfoResponseUtils;
import org.springframework.util.StringUtils;

public final class Utils {
    public static String[] infoAll(IAerospikeClient client, String infoString) {
        String[] messages = new String[client.getNodes().length];
        int index = 0;
        for (Node node : client.getNodes()) {
            messages[index] = Info.request((Node)node, (String)infoString);
        }
        return messages;
    }

    public static int getReplicationFactor(Node[] nodes, String namespace) {
        Node randomNode = Utils.getRandomNode(nodes);
        String response = Info.request((Node)randomNode, (String)("get-config:context=namespace;id=" + namespace));
        if (response.equalsIgnoreCase("ns_type=unknown")) {
            throw new InvalidDataAccessResourceUsageException("Namespace: " + namespace + " does not exist");
        }
        return InfoResponseUtils.getPropertyFromConfigResponse(response, "replication-factor", Integer::parseInt);
    }

    public static Node getRandomNode(Node[] nodes) {
        if (nodes.length == 0) {
            throw new AerospikeException(-8, "Command failed because cluster is empty.");
        }
        int offset = ThreadLocalRandom.current().nextInt(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            int index = (offset + i) % nodes.length;
            Node node = nodes[index];
            if (!node.isActive()) continue;
            return node;
        }
        throw new AerospikeException.InvalidNode("Command failed because no active nodes found.");
    }

    public static long getObjectsCount(Node node, String namespace, String setName) {
        String infoString = Info.request((Node)node, (String)("sets/" + namespace + "/" + setName));
        if (infoString.isEmpty()) {
            return 0L;
        }
        return InfoResponseUtils.getPropertyFromInfoResponse(infoString, "objects", Long::parseLong);
    }

    public static Optional<Integer> getIntegerProperty(String property) {
        if (StringUtils.hasText((String)property)) {
            int result;
            try {
                result = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static boolean allArrayElementsAreNull(Object[] array) {
        return Arrays.stream(array).allMatch(Objects::isNull);
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

